/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class SmartExpander {
    public static void installOn(final JTree tree) {
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                TreePath path2 = event.getPath();
                Enumeration<? extends TreeNode> children2 = ((TreeNode)path2.getLastPathComponent()).children();
                while (children2.hasMoreElements()) {
                    TreePath childPath = path2.pathByAddingChild(children2.nextElement());
                    if (!tree.isExpanded(childPath)) continue;
                    tree.collapsePath(childPath);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path2 = event.getPath();
                TreeNode lastPathComponent = (TreeNode)path2.getLastPathComponent();
                if (lastPathComponent.getChildCount() == 1) {
                    TreePath firstChildPath = path2.pathByAddingChild(lastPathComponent.getChildAt(0));
                    tree.expandPath(firstChildPath);
                }
            }
        });
    }
}

