/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.LinkedHashSet;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler;", "", "()V", "repaintScheduler", "Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintScheduler;", "createRepaintRequest", "Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintRequest;", "c", "Ljava/awt/Component;", "x", "", "y", "getTarget", "scheduleRepaint", "", "request", "iconWidth", "iconHeight", "alwaysSchedule", "", "RepaintRequest", "RepaintScheduler", "RepaintSchedulerRequest", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class DeferredIconRepaintScheduler {
    private final RepaintScheduler repaintScheduler = new RepaintScheduler();

    @RequiresEdt
    @NotNull
    public final RepaintRequest createRepaintRequest(@Nullable Component c, int x, int y) {
        Rectangle rectangle;
        Component target2 = this.getTarget(c);
        Component paintingParent = SwingUtilities.getAncestorOfClass(PaintingParent.class, c);
        if (paintingParent == null) {
            rectangle = null;
        } else {
            PaintingParent paintingParent2 = (PaintingParent)paintingParent;
            Component component2 = c;
            Intrinsics.checkNotNull((Object)component2);
            rectangle = paintingParent2.getChildRec(component2);
        }
        Rectangle paintingParentRec = rectangle;
        return new RepaintRequest(c, x, y, target2, paintingParent, paintingParentRec);
    }

    @RequiresEdt
    public final void scheduleRepaint(@NotNull RepaintRequest request2, int iconWidth, int iconHeight, boolean alwaysSchedule) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Component actualTarget = request2.getActualTarget();
        if (actualTarget == null) {
            return;
        }
        Component component2 = request2.getComponent();
        if (!alwaysSchedule && Intrinsics.areEqual((Object)component2, (Object)actualTarget)) {
            component2.repaint(request2.getX(), request2.getY(), iconWidth, iconHeight);
        } else {
            this.repaintScheduler.pushDirtyComponent(actualTarget, request2.getPaintingParentRec());
        }
    }

    private final Component getTarget(Component c) {
        Container list2 = SwingUtilities.getAncestorOfClass(JList.class, c);
        if (list2 != null) {
            return list2;
        }
        Container table = SwingUtilities.getAncestorOfClass(JTable.class, c);
        if (table != null) {
            return table;
        }
        Container tree = SwingUtilities.getAncestorOfClass(JTree.class, c);
        if (tree != null) {
            return tree;
        }
        Container box2 = SwingUtilities.getAncestorOfClass(JComboBox.class, c);
        if (box2 != null) {
            return box2;
        }
        Container tabLabel = SwingUtilities.getAncestorOfClass(TabLabel.class, c);
        if (tabLabel != null) {
            return tabLabel;
        }
        return c;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B=\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintRequest;", "", "component", "Ljava/awt/Component;", "x", "", "y", "target", "paintingParent", "paintingParentRec", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;IILjava/awt/Component;Ljava/awt/Component;Ljava/awt/Rectangle;)V", "getComponent", "()Ljava/awt/Component;", "getPaintingParent", "getPaintingParentRec", "()Ljava/awt/Rectangle;", "getTarget", "getX", "()I", "getY", "getActualTarget", "intellij.platform.lang.impl"})
    public static final class RepaintRequest {
        @Nullable
        private final Component component;
        private final int x;
        private final int y;
        @Nullable
        private final Component target;
        @Nullable
        private final Component paintingParent;
        @Nullable
        private final Rectangle paintingParentRec;

        @Nullable
        public final Component getActualTarget() {
            if (this.target == null) {
                return null;
            }
            if (SwingUtilities.getWindowAncestor(this.target) != null) {
                return this.target;
            }
            if (this.paintingParent != null && SwingUtilities.getWindowAncestor(this.paintingParent) != null) {
                return this.paintingParent;
            }
            return null;
        }

        @Nullable
        public final Component getComponent() {
            return this.component;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        @Nullable
        public final Component getTarget() {
            return this.target;
        }

        @Nullable
        public final Component getPaintingParent() {
            return this.paintingParent;
        }

        @Nullable
        public final Rectangle getPaintingParentRec() {
            return this.paintingParentRec;
        }

        public RepaintRequest(@Nullable Component component2, int x, int y, @Nullable Component target2, @Nullable Component paintingParent, @Nullable Rectangle paintingParentRec) {
            this.component = component2;
            this.x = x;
            this.y = y;
            this.target = target2;
            this.paintingParent = paintingParent;
            this.paintingParentRec = paintingParentRec;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintScheduler;", "", "()V", "myAlarm", "Lcom/intellij/util/Alarm;", "myQueue", "Ljava/util/LinkedHashSet;", "Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintSchedulerRequest;", "Lkotlin/collections/LinkedHashSet;", "pushDirtyComponent", "", "c", "Ljava/awt/Component;", "rec", "Ljava/awt/Rectangle;", "intellij.platform.lang.impl"})
    private static final class RepaintScheduler {
        private final Alarm myAlarm = new Alarm();
        private final LinkedHashSet<RepaintSchedulerRequest> myQueue = new LinkedHashSet();

        public final void pushDirtyComponent(@NotNull Component c, @Nullable Rectangle rec) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(new Runnable(this){
                final /* synthetic */ RepaintScheduler this$0;

                public final void run() {
                    for (RepaintSchedulerRequest each : RepaintScheduler.access$getMyQueue$p(this.this$0)) {
                        Rectangle r = each.getRectangle();
                        if (r == null) {
                            each.getComponent().repaint();
                            continue;
                        }
                        each.getComponent().repaint(r.x, r.y, r.width, r.height);
                    }
                    RepaintScheduler.access$getMyQueue$p(this.this$0).clear();
                }
                {
                    this.this$0 = repaintScheduler;
                }
            }, 50);
            this.myQueue.add(new RepaintSchedulerRequest(c, rec));
        }

        public static final /* synthetic */ LinkedHashSet access$getMyQueue$p(RepaintScheduler $this) {
            return $this.myQueue;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintSchedulerRequest;", "", "component", "Ljava/awt/Component;", "rectangle", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ljava/awt/Rectangle;)V", "getComponent", "()Ljava/awt/Component;", "getRectangle", "()Ljava/awt/Rectangle;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    private static final class RepaintSchedulerRequest {
        @NotNull
        private final Component component;
        @Nullable
        private final Rectangle rectangle;

        @NotNull
        public final Component getComponent() {
            return this.component;
        }

        @Nullable
        public final Rectangle getRectangle() {
            return this.rectangle;
        }

        public RepaintSchedulerRequest(@NotNull Component component2, @Nullable Rectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.component = component2;
            this.rectangle = rectangle;
        }

        @NotNull
        public final Component component1() {
            return this.component;
        }

        @Nullable
        public final Rectangle component2() {
            return this.rectangle;
        }

        @NotNull
        public final RepaintSchedulerRequest copy(@NotNull Component component2, @Nullable Rectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            return new RepaintSchedulerRequest(component2, rectangle);
        }

        public static /* synthetic */ RepaintSchedulerRequest copy$default(RepaintSchedulerRequest repaintSchedulerRequest, Component component2, Rectangle rectangle, int n, Object object) {
            if ((n & 1) != 0) {
                component2 = repaintSchedulerRequest.component;
            }
            if ((n & 2) != 0) {
                rectangle = repaintSchedulerRequest.rectangle;
            }
            return repaintSchedulerRequest.copy(component2, rectangle);
        }

        @NotNull
        public String toString() {
            return "RepaintSchedulerRequest(component=" + this.component + ", rectangle=" + this.rectangle + ")";
        }

        public int hashCode() {
            Component component2 = this.component;
            Rectangle rectangle = this.rectangle;
            return (component2 != null ? component2.hashCode() : 0) * 31 + (rectangle != null ? ((Object)rectangle).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RepaintSchedulerRequest)) break block3;
                    RepaintSchedulerRequest repaintSchedulerRequest = (RepaintSchedulerRequest)object;
                    if (!Intrinsics.areEqual((Object)this.component, (Object)repaintSchedulerRequest.component) || !Intrinsics.areEqual((Object)this.rectangle, (Object)repaintSchedulerRequest.rectangle)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

