/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ClientProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtil {
    @Deprecated
    public static <T> T getClientProperty(@NotNull JComponent component2, @NotNull Key<T> key) {
        if (component2 == null) {
            ComponentUtil.$$$reportNull$$$0(0);
        }
        if (key == null) {
            ComponentUtil.$$$reportNull$$$0(1);
        }
        return ClientProperty.get((Component)component2, key);
    }

    @Deprecated
    public static <T> void putClientProperty(@NotNull JComponent component2, @NotNull Key<T> key, T value) {
        if (component2 == null) {
            ComponentUtil.$$$reportNull$$$0(2);
        }
        if (key == null) {
            ComponentUtil.$$$reportNull$$$0(3);
        }
        component2.putClientProperty(key, value);
    }

    public static boolean isDisableAutoRequestFocus() {
        return Registry.is("suppress.focus.stealing.disable.auto.request.focus", true) && !SystemInfo.isXfce && !SystemInfo.isI3;
    }

    public static boolean isMinimized(@Nullable Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)window;
        return frame.getExtendedState() == 1;
    }

    @NotNull
    public static Window getActiveWindow() {
        for (Window each : Window.getWindows()) {
            if (!each.isVisible() || !each.isActive()) continue;
            Window window = each;
            if (window == null) {
                ComponentUtil.$$$reportNull$$$0(4);
            }
            return window;
        }
        Frame frame = JOptionPane.getRootFrame();
        if (frame == null) {
            ComponentUtil.$$$reportNull$$$0(5);
        }
        return frame;
    }

    @NotNull
    public static Component findUltimateParent(@NotNull Component c) {
        if (c == null) {
            ComponentUtil.$$$reportNull$$$0(6);
        }
        Component parent = c;
        while (true) {
            Container nextParent;
            if ((nextParent = parent.getParent()) == null) {
                Component component2 = parent;
                if (component2 == null) {
                    ComponentUtil.$$$reportNull$$$0(7);
                }
                return component2;
            }
            parent = nextParent;
        }
    }

    @Nullable
    public static Window getWindow(@Nullable Component component2) {
        return component2 == null ? null : (component2 instanceof Window ? (Window)component2 : SwingUtilities.getWindowAncestor(component2));
    }

    @Nullable
    public static Component findParentByCondition(@Nullable Component c, @NotNull Predicate<? super Component> condition) {
        if (condition == null) {
            ComponentUtil.$$$reportNull$$$0(8);
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!condition.test(eachParent)) continue;
            return eachParent;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component2) {
        if (type == null) {
            ComponentUtil.$$$reportNull$$$0(9);
        }
        while (component2 != null) {
            if (type.isInstance(component2)) {
                return (T)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    @Nullable
    public static JScrollPane getScrollPane(@Nullable Component component2) {
        return component2 instanceof JScrollBar ? ComponentUtil.getScrollPane((JScrollBar)component2) : ComponentUtil.getScrollPane(component2 instanceof JViewport ? (JViewport)component2 : ComponentUtil.getViewport(component2));
    }

    @Nullable
    public static JScrollPane getScrollPane(@Nullable JScrollBar bar) {
        Container parent = bar == null ? null : bar.getParent();
        return parent instanceof JScrollPane ? (JScrollPane)parent : null;
    }

    @Nullable
    public static JScrollPane getScrollPane(@Nullable JViewport viewport) {
        Container parent = viewport == null ? null : viewport.getParent();
        return parent instanceof JScrollPane ? (JScrollPane)parent : null;
    }

    @Nullable
    public static JViewport getViewport(@Nullable Component component2) {
        Container parent = component2 == null ? null : SwingUtilities.getUnwrappedParent(component2);
        return parent instanceof JViewport ? (JViewport)parent : null;
    }

    @NotNull
    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent, @NotNull Class<? extends T> cls) {
        if (cls == null) {
            ComponentUtil.$$$reportNull$$$0(10);
        }
        ArrayList result2 = new ArrayList();
        ComponentUtil.findComponentsOfType(parent, cls, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ComponentUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static <T extends JComponent> void findComponentsOfType(JComponent parent, @NotNull Class<T> cls, @NotNull List<? super T> result2) {
        if (cls == null) {
            ComponentUtil.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            ComponentUtil.$$$reportNull$$$0(13);
        }
        if (parent == null) {
            return;
        }
        if (cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            result2.add(t);
        }
        for (Component c : parent.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            ComponentUtil.findComponentsOfType((JComponent)c, cls, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ComponentUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ComponentUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUltimateParent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentsOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUltimateParent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findParentByCondition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findComponentsOfType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

