/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ListModel;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ChooserInterceptor
extends UiInterceptors.UiInterceptor<JBPopup> {
    final List<String> myOptions;
    final Pattern myToSelect;

    public ChooserInterceptor(@Nullable List<String> expectedOptions, @NotNull @RegExp String pattern) {
        if (pattern == null) {
            ChooserInterceptor.$$$reportNull$$$0(0);
        }
        super(JBPopup.class);
        this.myOptions = expectedOptions;
        this.myToSelect = Pattern.compile(pattern);
    }

    @Override
    protected void doIntercept(@NotNull JBPopup popup2) {
        List<String> matched;
        JBList content2;
        if (popup2 == null) {
            ChooserInterceptor.$$$reportNull$$$0(1);
        }
        JBList jBList = content2 = popup2.isDisposed() ? null : UIUtil.findComponentOfType(popup2.getContent(), JBList.class);
        if (content2 == null) {
            Assert.fail((String)("JBList not found under " + popup2.getContent()));
        }
        ListModel model2 = content2.getModel();
        List actualOptions = IntStream.range(0, model2.getSize()).mapToObj(model2::getElementAt).map(Object::toString).collect(Collectors.toList());
        if (this.myOptions != null) {
            Assert.assertEquals(this.myOptions, actualOptions);
        }
        if ((matched = ContainerUtil.filter(actualOptions, opt -> this.myToSelect.matcher((CharSequence)opt).matches())).isEmpty()) {
            Assert.fail((String)("No option matches pattern " + this.myToSelect + " (available options: " + String.join((CharSequence)", ", actualOptions) + ")"));
        }
        if (matched.size() > 1) {
            Assert.fail((String)("Several options matched: " + matched + " (pattern: " + this.myToSelect + ")"));
        }
        content2.setSelectedIndex(actualOptions.indexOf(matched.get(0)));
        Assert.assertTrue((boolean)popup2.canClose());
        popup2.closeOk(null);
    }

    @Override
    public String toString() {
        return "Popup Chooser where '" + this.myToSelect + "' should be selected";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ChooserInterceptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doIntercept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

