/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.AsyncImageIcon;
import com.intellij.ui.RepaintScheduler;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B?\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012&\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J*\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0006H\u0016R\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a \u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\f \u0011*\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b0\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ui/AsyncImageIcon;", "Ljavax/swing/Icon;", "Lcom/intellij/openapi/util/ScalableIcon;", "Lcom/intellij/ui/icons/CopyableIcon;", "defaultIcon", "scale", "", "imageLoader", "Lkotlin/Function3;", "Lcom/intellij/ui/scale/ScaleContext;", "", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "(Ljavax/swing/Icon;FLkotlin/jvm/functions/Function3;)V", "Lorg/jetbrains/annotations/NotNull;", "imageRequestsCache", "Lcom/intellij/ui/scale/ScaleContext$Cache;", "kotlin.jvm.PlatformType", "repaintScheduler", "Lcom/intellij/ui/RepaintScheduler;", "copy", "getIconHeight", "getIconWidth", "getScale", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "scaleFactor", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public final class AsyncImageIcon
implements Icon,
ScalableIcon,
CopyableIcon {
    private final Icon defaultIcon;
    private final RepaintScheduler repaintScheduler;
    private final ScaleContext.Cache<CompletableFuture<Image>> imageRequestsCache;
    private final float scale;
    private final Function3<ScaleContext, Integer, Integer, CompletableFuture<Image>> imageLoader;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public int getIconHeight() {
        return this.defaultIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.defaultIcon.getIconWidth();
    }

    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Object d = this.imageRequestsCache.getOrProvide((UserScaleContext)ScaleContext.create(c));
        Intrinsics.checkNotNull(d);
        Intrinsics.checkNotNullExpressionValue(d, (String)"imageRequestsCache.getOr\u2026ScaleContext.create(c))!!");
        CompletableFuture imageRequest = (CompletableFuture)d;
        if (!imageRequest.isDone() && c != null) {
            this.repaintScheduler.requestRepaint(c, x, y);
        }
        try {
            image = imageRequest.getNow(null);
        }
        catch (Throwable error) {
            LOG.debug("Image loading failed", error);
            image = null;
        }
        Image image2 = image;
        if (image2 == null) {
            this.defaultIcon.paintIcon(c, g, x, y);
        } else {
            Rectangle bounds = new Rectangle(x, y, this.getIconWidth(), this.getIconHeight());
            StartupUiUtil.drawImage(g, image2, bounds, c);
        }
    }

    @Override
    @NotNull
    public Icon copy() {
        return new AsyncImageIcon(this.defaultIcon, this.scale, this.imageLoader);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    @NotNull
    public Icon scale(float scaleFactor) {
        return new AsyncImageIcon(this.defaultIcon, scaleFactor, this.imageLoader);
    }

    public AsyncImageIcon(@NotNull Icon defaultIcon, float scale, @NotNull Function3<? super ScaleContext, ? super Integer, ? super Integer, ? extends CompletableFuture<Image>> imageLoader) {
        Intrinsics.checkNotNullParameter((Object)defaultIcon, (String)"defaultIcon");
        Intrinsics.checkNotNullParameter(imageLoader, (String)"imageLoader");
        this.scale = scale;
        this.imageLoader = imageLoader;
        Icon icon2 = IconUtil.scale((Icon)defaultIcon, null, (float)this.scale);
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"IconUtil.scale(defaultIcon, null, scale)");
        this.defaultIcon = icon2;
        this.repaintScheduler = new RepaintScheduler();
        this.imageRequestsCache = new ScaleContext.Cache(new Function(this){
            final /* synthetic */ AsyncImageIcon this$0;

            public final CompletableFuture<Image> apply(ScaleContext scaleCtx) {
                Function3 function3 = AsyncImageIcon.access$getImageLoader$p(this.this$0);
                ScaleContext scaleContext = scaleCtx;
                Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"scaleCtx");
                Object object = function3.invoke((Object)scaleContext, (Object)this.this$0.getIconWidth(), (Object)this.this$0.getIconHeight());
                CompletableFuture it = (CompletableFuture)object;
                boolean bl = false;
                it.thenRunAsync(new Runnable(this){
                    final /* synthetic */ imageRequestsCache.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        AsyncImageIcon.access$getRepaintScheduler$p(this.this$0.this$0).scheduleRepaint(this.this$0.this$0.getIconWidth(), this.this$0.this$0.getIconHeight());
                    }
                }, (Executor)EdtExecutorService.getInstance());
                return (CompletableFuture)object;
            }
            {
                this.this$0 = asyncImageIcon;
            }
        });
    }

    public /* synthetic */ AsyncImageIcon(Icon icon2, float f, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(icon2, f, (Function3<? super ScaleContext, ? super Integer, ? super Integer, ? extends CompletableFuture<Image>>)function3);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AsyncImageIcon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Function3 access$getImageLoader$p(AsyncImageIcon $this) {
        return $this.imageLoader;
    }

    public static final /* synthetic */ RepaintScheduler access$getRepaintScheduler$p(AsyncImageIcon $this) {
        return $this.repaintScheduler;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/AsyncImageIcon$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

