/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsGroup;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ToolsProcessor<T extends Tool>
extends NonLazySchemeProcessor<ToolsGroup<T>, ToolsGroup<T>> {
    @NonNls
    private static final String TOOL_SET = "toolSet";
    @NonNls
    private static final String TOOL = "tool";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHOW_IN_MAIN_MENU = "showInMainMenu";
    @NonNls
    private static final String SHOW_IN_EDITOR = "showInEditor";
    @NonNls
    private static final String SHOW_IN_PROJECT = "showInProject";
    @NonNls
    private static final String SHOW_IN_SEARCH_POPUP = "showInSearchPopup";
    @NonNls
    private static final String DISABLED = "disabled";
    @NonNls
    private static final String USE_CONSOLE = "useConsole";
    @NonNls
    private static final String SHOW_CONSOLE_ON_STDOUT = "showConsoleOnStdOut";
    @NonNls
    private static final String SHOW_CONSOLE_ON_STDERR = "showConsoleOnStdErr";
    @NonNls
    private static final String SYNCHRONIZE_AFTER_EXECUTION = "synchronizeAfterRun";
    @NonNls
    private static final String EXEC = "exec";
    @NonNls
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    @NonNls
    private static final String COMMAND = "COMMAND";
    @NonNls
    private static final String PARAMETERS = "PARAMETERS";
    @NonNls
    private static final String FILTER = "filter";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    @Override
    @NotNull
    public ToolsGroup<T> readScheme(@NotNull Element root, boolean duringLoad) throws InvalidDataException, IOException, JDOMException {
        if (root == null) {
            ToolsProcessor.$$$reportNull$$$0(0);
        }
        if (!TOOL_SET.equals(root.getName())) {
            throw new InvalidDataException();
        }
        String attrName = root.getAttributeValue("name");
        String groupName = StringUtil.isEmpty(attrName) ? this.getDefaultGroupName() : attrName;
        ToolsGroup<T> result2 = this.createToolsGroup(groupName);
        PathMacroManager macroManager = PathMacroManager.getInstance(ApplicationManager.getApplication());
        for (Element element2 : root.getChildren(TOOL)) {
            T tool = this.createTool();
            this.readToolAttributes(element2, tool);
            Element exec = element2.getChild(EXEC);
            if (exec != null) {
                for (Element optionElement : exec.getChildren(ELEMENT_OPTION)) {
                    String name2 = optionElement.getAttributeValue("name");
                    String value = optionElement.getAttributeValue(ATTRIBUTE_VALUE);
                    if (WORKING_DIRECTORY.equals(name2) && value != null) {
                        String replace = macroManager.expandPath(value).replace('/', File.separatorChar);
                        ((Tool)tool).setWorkingDirectory(replace);
                    }
                    if (COMMAND.equals(name2)) {
                        ((Tool)tool).setProgram(macroManager.expandPath(BaseToolManager.convertString(value)));
                    }
                    if (!PARAMETERS.equals(name2)) continue;
                    ((Tool)tool).setParameters(macroManager.expandPath(BaseToolManager.convertString(value)));
                }
            }
            for (Element childNode : element2.getChildren(FILTER)) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.readExternal(childNode);
                ((Tool)tool).addOutputFilter(filterInfo);
            }
            ((Tool)tool).setGroup(groupName);
            result2.addElement(tool);
        }
        ToolsGroup<T> toolsGroup = result2;
        if (toolsGroup == null) {
            ToolsProcessor.$$$reportNull$$$0(1);
        }
        return toolsGroup;
    }

    protected void readToolAttributes(Element element2, T tool) {
        ((Tool)tool).setName(BaseToolManager.convertString(element2.getAttributeValue("name")));
        ((Tool)tool).setDescription(BaseToolManager.convertString(element2.getAttributeValue(DESCRIPTION)));
        ((Tool)tool).setShownInMainMenu(Boolean.valueOf(element2.getAttributeValue(SHOW_IN_MAIN_MENU)));
        ((Tool)tool).setShownInEditor(Boolean.valueOf(element2.getAttributeValue(SHOW_IN_EDITOR)));
        ((Tool)tool).setShownInProjectViews(Boolean.valueOf(element2.getAttributeValue(SHOW_IN_PROJECT)));
        ((Tool)tool).setShownInSearchResultsPopup(Boolean.valueOf(element2.getAttributeValue(SHOW_IN_SEARCH_POPUP)));
        ((Tool)tool).setEnabled(Boolean.valueOf(element2.getAttributeValue(DISABLED)) == false);
        ((Tool)tool).setUseConsole(Boolean.valueOf(element2.getAttributeValue(USE_CONSOLE)));
        ((Tool)tool).setShowConsoleOnStdOut(Boolean.valueOf(element2.getAttributeValue(SHOW_CONSOLE_ON_STDOUT)));
        ((Tool)tool).setShowConsoleOnStdErr(Boolean.valueOf(element2.getAttributeValue(SHOW_CONSOLE_ON_STDERR)));
        ((Tool)tool).setFilesSynchronizedAfterRun(Boolean.valueOf(element2.getAttributeValue(SYNCHRONIZE_AFTER_EXECUTION)));
    }

    protected String getDefaultGroupName() {
        return "External Tools";
    }

    protected abstract ToolsGroup<T> createToolsGroup(String var1);

    protected abstract T createTool();

    @NotNull
    public Element writeScheme(@NotNull ToolsGroup<T> scheme) throws WriteExternalException {
        if (scheme == null) {
            ToolsProcessor.$$$reportNull$$$0(2);
        }
        Element groupElement = new Element(TOOL_SET);
        groupElement.setAttribute("name", scheme.getName());
        for (Tool tool : scheme.getElements()) {
            this.saveTool(tool, groupElement);
        }
        Element element2 = groupElement;
        if (element2 == null) {
            ToolsProcessor.$$$reportNull$$$0(3);
        }
        return element2;
    }

    private void saveTool(T tool, Element groupElement) {
        FilterInfo[] filters;
        Element element2 = new Element(TOOL);
        if (((Tool)tool).getName() != null) {
            element2.setAttribute("name", ((Tool)tool).getName());
        }
        if (((Tool)tool).getDescription() != null) {
            element2.setAttribute(DESCRIPTION, ((Tool)tool).getDescription());
        }
        this.saveToolAttributes(tool, element2);
        Element taskElement = new Element(EXEC);
        PathMacroManager macroManager = PathMacroManager.getInstance(ApplicationManager.getApplication());
        Element option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", COMMAND);
        if (((Tool)tool).getProgram() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getProgram()));
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", PARAMETERS);
        if (((Tool)tool).getParameters() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getParameters()));
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", WORKING_DIRECTORY);
        if (((Tool)tool).getWorkingDirectory() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getWorkingDirectory()).replace(File.separatorChar, '/'));
        }
        element2.addContent(taskElement);
        for (FilterInfo filter2 : filters = ((Tool)tool).getOutputFilters()) {
            Element filterElement = new Element(FILTER);
            filter2.writeExternal(filterElement);
            element2.addContent(filterElement);
        }
        groupElement.addContent(element2);
    }

    protected void saveToolAttributes(T tool, Element element2) {
        element2.setAttribute(SHOW_IN_MAIN_MENU, Boolean.toString(((Tool)tool).isShownInMainMenu()));
        element2.setAttribute(SHOW_IN_EDITOR, Boolean.toString(((Tool)tool).isShownInEditor()));
        element2.setAttribute(SHOW_IN_PROJECT, Boolean.toString(((Tool)tool).isShownInProjectViews()));
        element2.setAttribute(SHOW_IN_SEARCH_POPUP, Boolean.toString(((Tool)tool).isShownInSearchResultsPopup()));
        element2.setAttribute(DISABLED, Boolean.toString(!((Tool)tool).isEnabled()));
        element2.setAttribute(USE_CONSOLE, Boolean.toString(((Tool)tool).isUseConsole()));
        element2.setAttribute(SHOW_CONSOLE_ON_STDOUT, Boolean.toString(((Tool)tool).isShowConsoleOnStdOut()));
        element2.setAttribute(SHOW_CONSOLE_ON_STDERR, Boolean.toString(((Tool)tool).isShowConsoleOnStdErr()));
        element2.setAttribute(SYNCHRONIZE_AFTER_EXECUTION, Boolean.toString(((Tool)tool).synchronizeAfterExecution()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ToolsProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ToolsProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readScheme";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeScheme";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

