/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolSelectDialog;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolSelectComboBox<T extends Tool>
extends ComboboxWithBrowseButton {
    public static final Object NONE_TOOL = ObjectUtils.sentinel("NONE_TOOL");

    public BaseToolSelectComboBox() {
        final JComboBox comboBox = this.getComboBox();
        comboBox.setModel(new CollectionComboBoxModel(this.getComboBoxElements(), null){

            @Override
            public void setSelectedItem(@Nullable Object item) {
                if (item instanceof ToolsGroup) {
                    return;
                }
                super.setSelectedItem(item);
            }
        });
        comboBox.setRenderer(new ColoredListCellRenderer<Object>(){

            public Component getListCellRendererComponent(JList<?> list2, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ToolsGroup) {
                    SeparatorWithText separator = new SeparatorWithText();
                    separator.setCaption(StringUtil.notNullize(((ToolsGroup)value).getName(), ToolsBundle.message("tools.unnamed.group", new Object[0])));
                    separator.setCaptionCentered(false);
                    return separator;
                }
                return super.getListCellRendererComponent(list2, value, index, selected, hasFocus);
            }

            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(value instanceof ToolsGroup)) {
                    if (value instanceof Tool) {
                        this.append(StringUtil.notNullize(((Tool)value).getName()), ((Tool)value).isEnabled() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else {
                        this.append(ToolsBundle.message("tools.list.item.none", new Object[0]));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/tools/BaseToolSelectComboBox$2", "customizeCellRenderer"));
            }
        });
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolSelectDialog dialog;
                Object item = comboBox.getSelectedItem();
                String id2 = null;
                if (item instanceof Tool) {
                    id2 = ((Tool)item).getActionId();
                }
                if (!(dialog = BaseToolSelectComboBox.this.getToolSelectDialog(id2)).showAndGet()) {
                    return;
                }
                comboBox.setModel(new CollectionComboBoxModel<Tool>(BaseToolSelectComboBox.this.getComboBoxElements(), dialog.getSelectedTool()));
            }
        });
    }

    @NotNull
    protected abstract BaseToolManager<T> getToolManager();

    @NotNull
    protected abstract ToolSelectDialog getToolSelectDialog(@Nullable String var1);

    @NotNull
    protected List<Object> getComboBoxElements() {
        SmartList<Object> result2 = new SmartList<Object>();
        BaseToolManager<T> manager = this.getToolManager();
        result2.add(NONE_TOOL);
        for (ToolsGroup<T> group : manager.getGroups()) {
            result2.add(group);
            result2.addAll(manager.getTools(group.getName()));
        }
        SmartList<Object> smartList = result2;
        if (smartList == null) {
            BaseToolSelectComboBox.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    public int getValuableItemCount() {
        JComboBox comboBox = this.getComboBox();
        int itemCount = comboBox.getItemCount();
        if (itemCount == 0) {
            return 0;
        }
        int valuableCount = 0;
        for (int i = 0; i < itemCount; ++i) {
            if (comboBox.getItemAt(i) == NONE_TOOL) continue;
            ++valuableCount;
        }
        return valuableCount;
    }

    @Nullable
    public Tool selectTool(@Nullable String toolId) {
        JComboBox comboBox = this.getComboBox();
        if (toolId == null) {
            comboBox.setSelectedIndex(-1);
            return null;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object itemAt = comboBox.getItemAt(i);
            if (!(itemAt instanceof Tool) || !toolId.equals(((Tool)itemAt).getActionId())) continue;
            comboBox.setSelectedIndex(i);
            return (Tool)itemAt;
        }
        return null;
    }

    @Nullable
    public Tool getSelectedTool() {
        Object item = this.getComboBox().getSelectedItem();
        return item instanceof Tool ? (Tool)item : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolSelectComboBox", "getComboBoxElements"));
    }
}

