/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.SimpleActionGroup;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExternalToolsGroup<T extends Tool>
extends SimpleActionGroup
implements DumbAware {
    protected BaseExternalToolsGroup() {
        this.updateGroups(true);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = event.getPresentation();
        this.removeAll();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        this.updateGroups(false);
        presentation2.setEnabled(true);
        presentation2.setVisible(this.getChildrenCount() > 0);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    protected void updateGroups(boolean registerActions) {
        List<ToolsGroup<T>> groups2 = this.getToolsGroups();
        for (ToolsGroup<T> group : groups2) {
            String groupName = group.getName();
            if (!StringUtil.isEmptyOrSpaces(groupName)) {
                SimpleActionGroup subgroup = new SimpleActionGroup();
                subgroup.getTemplatePresentation().setText(groupName, false);
                subgroup.setPopup(true);
                this.fillGroup(groupName, subgroup);
                if (subgroup.getChildrenCount() <= 0) continue;
                this.add((AnAction)subgroup);
                if (!registerActions) continue;
                ActionManager.getInstance().registerAction(this.getGroupIdPrefix() + groupName, (AnAction)subgroup);
                continue;
            }
            this.fillGroup(null, this);
        }
    }

    @NonNls
    @NotNull
    protected abstract String getGroupIdPrefix();

    protected abstract List<ToolsGroup<T>> getToolsGroups();

    private void fillGroup(@Nullable String groupName, SimpleActionGroup group) {
        List<T> tools = this.getToolsByGroupName(groupName);
        for (Tool tool : tools) {
            if (!tool.isEnabled()) continue;
            this.addToolToGroup(tool, group);
        }
    }

    private void addToolToGroup(T tool, SimpleActionGroup group) {
        String id2 = ((Tool)tool).getActionId();
        AnAction action2 = ActionManager.getInstance().getAction(id2);
        if (action2 == null) {
            action2 = this.createToolAction(tool);
            ActionManager.getInstance().registerAction(id2, action2);
        }
        group.add(action2);
    }

    protected abstract List<T> getToolsByGroupName(String var1);

    protected abstract ToolAction createToolAction(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/BaseExternalToolsGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/BaseExternalToolsGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

