/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.rules.TempDirectory;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.DirectoryContentBuilder;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentBuilderImpl;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0006\u0010 \u001a\u00020\bJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0004J\u0018\u0010$\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010&J\u000e\u0010'\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0004J\u0018\u0010(\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010&R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/testFramework/rules/TempDirectory;", "Lorg/junit/rules/ExternalResource;", "()V", "myName", "", "myNextDirNameSuffix", "Ljava/util/concurrent/atomic/AtomicInteger;", "myRoot", "Ljava/io/File;", "myVirtualFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "getRoot", "()Ljava/io/File;", "rootPath", "Ljava/nio/file/Path;", "getRootPath", "()Ljava/nio/file/Path;", "virtualFileRoot", "getVirtualFileRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "after", "", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "before", "methodName", "makeDirectories", "path", "newDirectory", "relativePath", "newDirectoryPath", "newEmptyVirtualJarFile", "newFile", "content", "", "newVirtualDirectory", "newVirtualFile", "intellij.platform.testFramework"})
public class TempDirectory
extends ExternalResource {
    private String myName;
    private final AtomicInteger myNextDirNameSuffix = new AtomicInteger();
    private File myRoot;
    private VirtualFile myVirtualFileRoot;

    @NotNull
    public final File getRoot() {
        if (this.myRoot == null) {
            String string2 = this.myName;
            if (string2 == null) {
                boolean bl = false;
                String string3 = "apply() was not called";
                throw new IllegalStateException(string3.toString());
            }
            this.myRoot = Files.createTempDirectory("unitTest_" + this.myName + "_", new FileAttribute[0]).toRealPath(new LinkOption[0]).toFile();
        }
        File file2 = this.myRoot;
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @NotNull
    public final Path getRootPath() {
        Path path2 = this.getRoot().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"root.toPath()");
        return path2;
    }

    @NotNull
    public final VirtualFile getVirtualFileRoot() {
        if (this.myVirtualFileRoot == null) {
            this.myVirtualFileRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.getRoot());
            VirtualFile virtualFile2 = this.myVirtualFileRoot;
            if (virtualFile2 == null) {
                boolean bl = false;
                String string2 = "Cannot find virtual file by " + this.getRoot();
                throw new IllegalStateException(string2.toString());
            }
            VfsUtil.markDirtyAndRefresh(false, true, true, this.myVirtualFileRoot);
        }
        VirtualFile virtualFile3 = this.myVirtualFileRoot;
        Intrinsics.checkNotNull((Object)virtualFile3);
        return virtualFile3;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string2 = description.getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"description.methodName");
        this.before(string2);
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"super.apply(base, description)");
        return statement2;
    }

    public final void before(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        this.myName = PlatformTestUtil.lowercaseFirstLetter(FileUtil.sanitizeFileName(StringsKt.take((String)methodName, (int)30), true), true);
    }

    public void after() {
        File file2 = this.myRoot;
        Path path2 = file2 != null ? file2.toPath() : null;
        VirtualFile vfsDir = this.myVirtualFileRoot;
        this.myVirtualFileRoot = null;
        this.myRoot = null;
        this.myName = null;
        new RunAll(after.1.INSTANCE, new ThrowableRunnable(vfsDir){
            final /* synthetic */ VirtualFile $vfsDir;

            public final void run() {
                if (this.$vfsDir != null) {
                    VfsTestUtil.deleteFile(this.$vfsDir);
                }
            }
            {
                this.$vfsDir = virtualFile2;
            }
        }, new ThrowableRunnable(path2){
            final /* synthetic */ Path $path;

            public final void run() {
                if (this.$path != null) {
                    FileUtil.delete(this.$path);
                }
            }
            {
                this.$path = path2;
            }
        }).run();
    }

    @NotNull
    public final File newDirectory() {
        File file2 = this.newDirectoryPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"newDirectoryPath().toFile()");
        return file2;
    }

    @NotNull
    public final Path newDirectoryPath() {
        return this.newDirectoryPath("dir" + this.myNextDirNameSuffix.incrementAndGet());
    }

    @NotNull
    public final File newDirectory(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File file2 = this.newDirectoryPath(relativePath).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"newDirectoryPath(relativePath).toFile()");
        return file2;
    }

    @NotNull
    public final Path newDirectoryPath(@NotNull String relativePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path dir = this.getRootPath().resolve(relativePath);
        boolean bl2 = bl = !Files.exists(dir, new LinkOption[0]);
        if (!bl) {
            boolean bl3 = false;
            String string2 = "Already exists: " + dir;
            throw new IllegalArgumentException(string2.toString());
        }
        Path path2 = dir;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir");
        this.makeDirectories(path2);
        return dir;
    }

    @NotNull
    public final File newFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.newFile(relativePath, null);
    }

    @NotNull
    public final File newFile(@NotNull String relativePath, @Nullable byte[] content2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path file2 = this.getRootPath().resolve(relativePath);
        boolean bl2 = bl = !Files.exists(file2, new LinkOption[0]);
        if (!bl) {
            boolean bl3 = false;
            String string2 = "Already exists: " + file2;
            throw new IllegalArgumentException(string2.toString());
        }
        Path path2 = file2;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
        Path path3 = path2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file.parent");
        this.makeDirectories(path3);
        Files.createFile(file2, new FileAttribute[0]);
        if (content2 != null) {
            Files.write(file2, content2, new OpenOption[0]);
        }
        File file3 = file2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.toFile()");
        return file3;
    }

    @NotNull
    public final VirtualFile newVirtualDirectory(@NotNull String relativePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        boolean bl2 = bl = existing == null;
        if (!bl) {
            boolean bl3 = false;
            VirtualFile virtualFile2 = existing;
            Intrinsics.checkNotNull((Object)virtualFile2);
            String string2 = "Already exists: " + virtualFile2.getPath();
            throw new IllegalArgumentException(string2.toString());
        }
        VirtualFile virtualFile3 = VfsTestUtil.createDir(this.getVirtualFileRoot(), relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"VfsTestUtil.createDir(vi\u2026alFileRoot, relativePath)");
        return virtualFile3;
    }

    @NotNull
    public final VirtualFile newVirtualFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.newVirtualFile(relativePath, null);
    }

    @NotNull
    public final VirtualFile newVirtualFile(@NotNull String relativePath, @Nullable byte[] content2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        boolean bl2 = bl = existing == null;
        if (!bl) {
            boolean bl3 = false;
            VirtualFile virtualFile2 = existing;
            Intrinsics.checkNotNull((Object)virtualFile2);
            String string2 = "Already exists: " + virtualFile2.getPath();
            throw new IllegalArgumentException(string2.toString());
        }
        VirtualFile virtualFile3 = VfsTestUtil.createFile(this.getVirtualFileRoot(), relativePath, content2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"VfsTestUtil.createFile(v\u2026t, relativePath, content)");
        return virtualFile3;
    }

    @NotNull
    public final VirtualFile newEmptyVirtualJarFile(@NotNull String relativePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        boolean bl2 = bl = existing == null;
        if (!bl) {
            boolean $i$a$-require-TempDirectory$newEmptyVirtualJarFile$22 = false;
            VirtualFile virtualFile2 = existing;
            Intrinsics.checkNotNull((Object)virtualFile2);
            String $i$a$-require-TempDirectory$newEmptyVirtualJarFile$22 = "Already exists: " + virtualFile2.getPath();
            throw new IllegalArgumentException($i$a$-require-TempDirectory$newEmptyVirtualJarFile$22.toString());
        }
        File jarFile = new File(this.getRoot(), relativePath);
        boolean $i$f$zipFile = false;
        DirectoryContentBuilderImpl builder$iv = new DirectoryContentBuilderImpl(new ZipSpec());
        DirectoryContentBuilder $this$zipFile = builder$iv;
        boolean bl3 = false;
        ((DirectoryContentSpec)builder$iv.getResult()).generate(jarFile);
        VirtualFile virtualFile3 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(jarFile);
        Intrinsics.checkNotNull((Object)virtualFile3);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"LocalFileSystem.getInsta\u2026ndFileByIoFile(jarFile)!!");
        VirtualFile localFile = virtualFile3;
        VirtualFile virtualFile4 = JarFileSystem.getInstance().getJarRootForLocalFile(localFile);
        Intrinsics.checkNotNull((Object)virtualFile4);
        return virtualFile4;
    }

    private final void makeDirectories(Path path2) {
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            Path path3 = path2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.parent");
            this.makeDirectories(path3);
            Files.createDirectory(path2, new FileAttribute[0]);
        }
    }
}

