/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5;

import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.RunsInEdt;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class EdtInterceptor
implements InvocationInterceptor {
    private final boolean myAnnotationDependant;

    public EdtInterceptor() {
        this(false);
    }

    public EdtInterceptor(boolean annotationDependant) {
        this.myAnnotationDependant = annotationDependant;
    }

    private void doRun(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        if (this.myAnnotationDependant && AnnotationSupport.findAnnotation((Optional)extensionContext.getTestClass(), RunsInEdt.class).isEmpty() && AnnotationSupport.findAnnotation((Optional)extensionContext.getTestMethod(), RunsInEdt.class).isEmpty()) {
            invocation.proceed();
            return;
        }
        EdtTestUtil.runInEdtAndWait(() -> invocation.proceed());
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doRun(invocation, extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doRun(invocation, extensionContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doRun(invocation, extensionContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.doRun(invocation, extensionContext);
    }
}

