/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.EditorTestFixture;
import com.intellij.testFramework.fixtures.InjectionAssertionData;
import com.intellij.testFramework.fixtures.InjectionTestFixture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u001a2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u001c\"\u00020!\u00a2\u0006\u0002\u0010\"J\u001c\u0010\u001f\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%J\u0010\u0010&\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010!J\u0018\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160)0%J\u0006\u0010*\u001a\u00020+J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/intellij/testFramework/fixtures/InjectionTestFixture;", "", "javaFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "injectedElement", "Lcom/intellij/psi/PsiElement;", "getInjectedElement", "()Lcom/intellij/psi/PsiElement;", "injectedLanguageManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "getInjectedLanguageManager", "()Lcom/intellij/lang/injection/InjectedLanguageManager;", "topLevelCaretPosition", "", "getTopLevelCaretPosition", "()I", "topLevelEditor", "Lcom/intellij/openapi/editor/Editor;", "getTopLevelEditor", "()Lcom/intellij/openapi/editor/Editor;", "topLevelFile", "Lcom/intellij/psi/PsiFile;", "getTopLevelFile", "()Lcom/intellij/psi/PsiFile;", "assertInjected", "", "expectedInjections", "", "Lcom/intellij/testFramework/fixtures/InjectionAssertionData;", "([Lcom/intellij/testFramework/fixtures/InjectionAssertionData;)V", "assertInjectedContent", "expectedInjectFileTexts", "", "([Ljava/lang/String;)V", "message", "expectedFilesTexts", "", "assertInjectedLangAtCaret", "lang", "getAllInjections", "Lkotlin/Pair;", "openInFragmentEditor", "Lcom/intellij/testFramework/fixtures/EditorTestFixture;", "quickEditHandler", "Lcom/intellij/codeInsight/intention/impl/QuickEditHandler;", "intellij.platform.testFramework"})
public final class InjectionTestFixture {
    private final CodeInsightTestFixture javaFixture;

    @NotNull
    public final InjectedLanguageManager getInjectedLanguageManager() {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(this.javaFixture.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"InjectedLanguageManager.\u2026ance(javaFixture.project)");
        return injectedLanguageManager;
    }

    @Nullable
    public final PsiElement getInjectedElement() {
        PsiFile psiFile = this.getTopLevelFile();
        if (psiFile == null) {
            return null;
        }
        return this.getInjectedLanguageManager().findInjectedElementAt(psiFile, this.getTopLevelCaretPosition());
    }

    public final void assertInjectedLangAtCaret(@Nullable String lang) {
        PsiElement injectedElement = this.getInjectedElement();
        if (lang != null) {
            TestCase.assertNotNull((String)("injection of '" + lang + "' expected"), (Object)injectedElement);
            PsiElement psiElement = injectedElement;
            Intrinsics.checkNotNull((Object)psiElement);
            Language language = psiElement.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"injectedElement!!.language");
            TestCase.assertEquals((String)lang, (String)language.getID());
        } else {
            TestCase.assertNull((Object)injectedElement);
        }
    }

    @NotNull
    public final List<Pair<PsiElement, PsiFile>> getAllInjections() {
        List injected = new ArrayList();
        Collection<PsiLanguageInjectionHost> collection = PsiTreeUtil.collectElementsOfType(this.getTopLevelFile(), PsiLanguageInjectionHost.class);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"PsiTreeUtil.collectEleme\u2026njectionHost::class.java)");
        Collection<PsiLanguageInjectionHost> hosts = collection;
        for (PsiLanguageInjectionHost host : hosts) {
            this.getInjectedLanguageManager().enumerate(host, new PsiLanguageInjectionHost.InjectedPsiVisitor(injected, host){
                final /* synthetic */ List $injected;
                final /* synthetic */ PsiLanguageInjectionHost $host;

                public final void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)injectedPsi, (String)"injectedPsi");
                    Intrinsics.checkNotNullParameter($noName_1, (String)"<anonymous parameter 1>");
                    this.$injected.add(TuplesKt.to((Object)this.$host, (Object)injectedPsi));
                }
                {
                    this.$injected = list2;
                    this.$host = psiLanguageInjectionHost;
                }
            });
        }
        return injected;
    }

    public final void assertInjectedContent(String ... expectedInjectFileTexts) {
        Intrinsics.checkNotNullParameter((Object)expectedInjectFileTexts, (String)"expectedInjectFileTexts");
        this.assertInjectedContent("injected content expected", ArraysKt.toList((Object[])expectedInjectFileTexts));
    }

    /*
     * WARNING - void declaration
     */
    public final void assertInjectedContent(@NotNull String message2, @NotNull List<String> expectedFilesTexts) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Collection<Object> collection;
        void destination$iv;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter(expectedFilesTexts, (String)"expectedFilesTexts");
        Iterable iterable = this.getAllInjections();
        Collection collection2 = new HashSet();
        String string2 = message2;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Pair pair = (Pair)item$iv;
            collection = destination$iv;
            boolean bl = false;
            object = (PsiFile)it.getSecond();
            collection.add(object);
        }
        collection = destination$iv;
        $this$mapTo$iv = collection;
        boolean $i$f$map = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFile psiFile = (PsiFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getText();
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        UsefulTestCase.assertSameElements(string2, (Collection)collection, (Collection)expectedFilesTexts);
    }

    /*
     * Unable to fully structure code
     */
    public final void assertInjected(InjectionAssertionData ... expectedInjections) {
        Intrinsics.checkNotNullParameter((Object)expectedInjections, (String)"expectedInjections");
        expected = (LinkedList)ArraysKt.toCollection((Object[])expectedInjections, (Collection)new LinkedList<E>());
        foundInjections = (LinkedList)CollectionsKt.toCollection((Iterable)this.getAllInjections(), (Collection)new LinkedList<E>());
        while ((var4_4 = (Collection)expected).isEmpty() == false) {
            block5: {
                var6_6 = (InjectionAssertionData)expected.pop();
                var4_4 = var6_6.component1();
                injectedLanguage = var6_6.component2();
                var8_8 = var7_7 = (Iterable)foundInjections;
                for (T var10_10 : var8_8) {
                    $dstr$psi$file = (Pair)var10_10;
                    $i$a$-find-InjectionTestFixture$assertInjected$found$1 = false;
                    var13_13 = (PsiElement)$dstr$psi$file.component1();
                    file = (PsiFile)$dstr$psi$file.component2();
                    if (!Intrinsics.areEqual((Object)psi.getText(), (Object)text)) ** GOTO lbl-1000
                    v0 = file.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"file.language");
                    if (Intrinsics.areEqual((Object)v0.getID(), (Object)injectedLanguage)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = var10_10;
                    break block5;
                }
                v2 = null;
            }
            if ((v3 = (Pair)v2) == null) {
                Assert.fail((String)("no injection '" + (String)text + "' -> '" + injectedLanguage + "' were found, remains: " + CollectionsKt.joinToString$default((Iterable)foundInjections, null, null, null, (int)0, null, (Function1)assertInjected.found.2.INSTANCE, (int)31, null) + "   "));
                v3 = Unit.INSTANCE;
            }
            found = v3;
            var7_7 = foundInjections;
            TypeIntrinsics.asMutableCollection((Object)var7_7).remove(found);
        }
    }

    @NotNull
    public final EditorTestFixture openInFragmentEditor() {
        QuickEditHandler quickEditHandler;
        QuickEditHandler quickEditHandler2 = quickEditHandler = new QuickEditAction().invokeImpl(this.javaFixture.getProject(), this.getTopLevelEditor(), this.getTopLevelFile());
        Intrinsics.checkNotNullExpressionValue((Object)quickEditHandler2, (String)"quickEditHandler");
        return this.openInFragmentEditor(quickEditHandler2);
    }

    @NotNull
    public final EditorTestFixture openInFragmentEditor(@NotNull QuickEditHandler quickEditHandler) {
        Editor fragmentEditor;
        Intrinsics.checkNotNullParameter((Object)quickEditHandler, (String)"quickEditHandler");
        PsiFile injectedFile = quickEditHandler.getNewFile();
        Project project2 = this.javaFixture.getProject();
        PsiElement psiElement = this.getInjectedElement();
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        Intrinsics.checkNotNull((Object)psiFile);
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow(psiFile);
        CaretModel caretModel = this.getTopLevelEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"topLevelEditor.caretModel");
        int offset = caretModel.getOffset();
        int unEscapedOffset = InjectedLanguageUtil.hostToInjectedUnescaped(documentWindow, offset);
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project2);
        PsiFile psiFile2 = injectedFile;
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"injectedFile");
        Editor editor2 = fragmentEditor = fileEditorManagerEx.openTextEditor(new OpenFileDescriptor(project2, psiFile2.getVirtualFile(), unEscapedOffset), true);
        Intrinsics.checkNotNull((Object)editor2);
        return new EditorTestFixture(project2, editor2, injectedFile.getVirtualFile());
    }

    @NotNull
    public final PsiFile getTopLevelFile() {
        PsiFile psiFile;
        PsiFile psiFile2 = this.javaFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        PsiFile it = psiFile = psiFile2;
        boolean bl = false;
        PsiFile psiFile3 = this.getInjectedLanguageManager().getTopLevelFile(it);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"javaFixture.file!!.let {\u2026ger.getTopLevelFile(it) }");
        return psiFile3;
    }

    public final int getTopLevelCaretPosition() {
        CaretModel caretModel = this.getTopLevelEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"topLevelEditor.caretModel");
        return caretModel.getOffset();
    }

    @NotNull
    public final Editor getTopLevelEditor() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance(this.javaFixture.getProject());
        PsiFile psiFile = this.getTopLevelFile();
        Intrinsics.checkNotNull((Object)psiFile);
        FileEditor fileEditor = fileEditorManager.getSelectedEditor(psiFile.getVirtualFile());
        if (fileEditor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        Editor editor2 = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"(FileEditorManager.getIn\u2026le) as TextEditor).editor");
        return editor2;
    }

    public InjectionTestFixture(@NotNull CodeInsightTestFixture javaFixture) {
        Intrinsics.checkNotNullParameter((Object)javaFixture, (String)"javaFixture");
        this.javaFixture = javaFixture;
    }
}

