/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.ide.GeneratedSourceFileChangeTrackerImpl;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.UiInterceptors;
import com.intellij.util.ErrorKt;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import sun.awt.AWTAutoShutdown;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a$\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007\u001a,\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\n\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0015\"\n\b\u0001\u0010\u0013\u0018\u0001*\u00020\u0015*\u00020\u0016H\u0086\b\u00a2\u0006\u0002\u0010\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"testCounter", "", "checkJavaSwingTimersAreDisposed", "", "disposeApplicationAndCheckForLeaks", "dropModuleRootCaches", "project", "Lcom/intellij/openapi/project/Project;", "publishHeapDump", "", "fileNamePrefix", "replaceIdeEventQueueSafely", "tearDownProjectAndApp", "waitForProjectLeakingThreads", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "serviceIfCreated", "TI", "T", "", "Lcom/intellij/openapi/application/Application;", "(Lcom/intellij/openapi/application/Application;)Ljava/lang/Object;", "intellij.platform.testFramework"})
public final class TestApplicationManagerKt {
    private static int testCounter;

    public static final void replaceIdeEventQueueSafely() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"Toolkit.getDefaultToolkit()");
        if (toolkit.getSystemEventQueue() instanceof IdeEventQueue) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw (Throwable)new IllegalStateException("must not call under EDT");
        }
        AWTAutoShutdown.getInstance().notifyThreadBusy(Thread.currentThread());
        UIUtil.pump();
        EventQueue.invokeAndWait(replaceIdeEventQueueSafely.1.INSTANCE);
        EventQueue.invokeAndWait(EmptyRunnable.getInstance());
        EventQueue.invokeAndWait(EmptyRunnable.getInstance());
    }

    public static final /* synthetic */ <T, TI> TI serviceIfCreated(Application $this$serviceIfCreated) {
        int $i$f$serviceIfCreated = 0;
        Intrinsics.checkNotNullParameter((Object)$this$serviceIfCreated, (String)"$this$serviceIfCreated");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = $this$serviceIfCreated.getServiceIfCreated(Object.class);
        Intrinsics.reifiedOperationMarker((int)2, (String)"TI");
        return (TI)object;
    }

    @ApiStatus.Internal
    @TestOnly
    public static final void tearDownProjectAndApp(@NotNull Project project2) {
        boolean $i$f$serviceIfCreated;
        ComponentManager $this$serviceIfCreated$iv;
        boolean $i$f$catchAndStoreExceptions;
        List $this$catchAndStoreExceptions$iv;
        Application app;
        List l;
        block117: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (project2.isDisposed()) {
                return;
            }
            boolean isLightProject = ProjectManagerImpl.isLight((Project)project2);
            l = new ArrayList();
            app = ApplicationManager.getApplication();
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                Unit unit;
                boolean bl = false;
                Application application = app;
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                $this$serviceIfCreated$iv = application;
                $i$f$serviceIfCreated = false;
                FileTypeManager fileTypeManager = $this$serviceIfCreated$iv.getServiceIfCreated(FileTypeManager.class);
                if (!(fileTypeManager instanceof FileTypeManagerImpl)) {
                    fileTypeManager = null;
                }
                FileTypeManagerImpl fileTypeManagerImpl = (FileTypeManagerImpl)fileTypeManager;
                if (fileTypeManagerImpl != null) {
                    fileTypeManagerImpl.drainReDetectQueue();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list2 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list2);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                if (isLightProject) {
                    Unit unit;
                    $this$serviceIfCreated$iv = project2;
                    $i$f$serviceIfCreated = false;
                    AutoPopupController autoPopupController = $this$serviceIfCreated$iv.getServiceIfCreated(AutoPopupController.class);
                    if (autoPopupController != null) {
                        autoPopupController.cancelAllRequests();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list3 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list3);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                CodeStyle.dropTemporarySettings((Project)project2);
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list4 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list4);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                TestApplicationManagerKt.checkJavaSwingTimersAreDisposed();
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list5 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list5);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                UsefulTestCase.doPostponedFormatting(project2);
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list6 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list6);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                LookupManager.hideActiveLookup(project2);
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list7 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list7, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list7);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                if (isLightProject) {
                    Unit unit;
                    $this$serviceIfCreated$iv = project2;
                    $i$f$serviceIfCreated = false;
                    StartupManagerImpl startupManagerImpl = (StartupManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(StartupManager.class);
                    if (startupManagerImpl != null) {
                        startupManagerImpl.prepareForNextTest();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list8 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list8, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list8);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                if (isLightProject) {
                    LightPlatformTestCase.tearDownSourceRoot(project2);
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list9 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list9, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list9);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                WriteCommandAction.runWriteCommandAction(project2, new Runnable(project2, app){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ Application $app$inlined;
                    {
                        this.$project$inlined = project2;
                        this.$app$inlined = application;
                    }

                    public final void run() {
                        block1: {
                            Application application = this.$app$inlined;
                            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                            Application $this$serviceIfCreated$iv = application;
                            boolean $i$f$serviceIfCreated = false;
                            FileDocumentManager fileDocumentManager = $this$serviceIfCreated$iv.getServiceIfCreated(FileDocumentManager.class);
                            if (!(fileDocumentManager instanceof FileDocumentManagerImpl)) {
                                fileDocumentManager = null;
                            }
                            FileDocumentManagerImpl fileDocumentManagerImpl = (FileDocumentManagerImpl)fileDocumentManager;
                            if (fileDocumentManagerImpl == null) break block1;
                            fileDocumentManagerImpl.dropAllUnsavedDocuments();
                        }
                    }
                });
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list10 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list10, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list10);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                Unit unit;
                boolean bl = false;
                $this$serviceIfCreated$iv = project2;
                $i$f$serviceIfCreated = false;
                EditorHistoryManager editorHistoryManager = $this$serviceIfCreated$iv.getServiceIfCreated(EditorHistoryManager.class);
                if (editorHistoryManager != null) {
                    editorHistoryManager.removeAllFiles();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list11 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list11, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list11);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl = false;
                $this$serviceIfCreated$iv = project2;
                $i$f$serviceIfCreated = false;
                PsiManager psiManager = $this$serviceIfCreated$iv.getServiceIfCreated(PsiManager.class);
                if (psiManager == null) break block117;
                if (!psiManager.isDisposed()) break block117;
                throw (Throwable)new IllegalStateException("PsiManager must be not disposed");
            }
            catch (CompoundRuntimeException e$iv) {
                List<Throwable> list12 = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue(list12, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll((Collection)list12);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            LightPlatformTestCase.clearEncodingManagerDocumentQueue();
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list13 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list13, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list13);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            LightPlatformTestCase.checkAssertions();
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list14 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list14, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list14);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            LightPlatformTestCase.clearUncommittedDocuments(project2);
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list15 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list15, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list15);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            Application application = app;
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            $this$serviceIfCreated$iv = application;
            $i$f$serviceIfCreated = false;
            HintManager hintManager = $this$serviceIfCreated$iv.getServiceIfCreated(HintManager.class);
            if (!(hintManager instanceof HintManagerImpl)) {
                hintManager = null;
            }
            HintManagerImpl hintManagerImpl = (HintManagerImpl)hintManager;
            if (hintManagerImpl != null) {
                hintManagerImpl.cleanup();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list16 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list16, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list16);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            UndoManager undoManager = UndoManager.getGlobalInstance();
            if (undoManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
            }
            ((UndoManagerImpl)undoManager).dropHistoryInTests();
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list17 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list17, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list17);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            UndoManager undoManager = UndoManager.getInstance(project2);
            if (undoManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
            }
            ((UndoManagerImpl)undoManager).dropHistoryInTests();
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list18 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list18, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list18);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            Application application = app;
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            $this$serviceIfCreated$iv = application;
            $i$f$serviceIfCreated = false;
            DocumentReferenceManager documentReferenceManager = $this$serviceIfCreated$iv.getServiceIfCreated(DocumentReferenceManager.class);
            if (!(documentReferenceManager instanceof DocumentReferenceManagerImpl)) {
                documentReferenceManager = null;
            }
            DocumentReferenceManagerImpl documentReferenceManagerImpl = (DocumentReferenceManagerImpl)documentReferenceManager;
            if (documentReferenceManagerImpl != null) {
                documentReferenceManagerImpl.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list19 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list19, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list19);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            $this$serviceIfCreated$iv = project2;
            $i$f$serviceIfCreated = false;
            TemplateDataLanguageMappings templateDataLanguageMappings = $this$serviceIfCreated$iv.getServiceIfCreated(TemplateDataLanguageMappings.class);
            if (templateDataLanguageMappings != null) {
                templateDataLanguageMappings.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list20 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list20, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list20);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            $this$serviceIfCreated$iv = project2;
            $i$f$serviceIfCreated = false;
            PsiManagerImpl psiManagerImpl = (PsiManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(PsiManager.class);
            if (psiManagerImpl != null) {
                psiManagerImpl.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list21 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list21, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list21);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            $this$serviceIfCreated$iv = project2;
            $i$f$serviceIfCreated = false;
            StructureViewFactoryImpl structureViewFactoryImpl = (StructureViewFactoryImpl)$this$serviceIfCreated$iv.getServiceIfCreated(StructureViewFactory.class);
            if (structureViewFactoryImpl != null) {
                structureViewFactoryImpl.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list22 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list22, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list22);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            TestApplicationManagerKt.waitForProjectLeakingThreads$default(project2, 0L, null, 6, null);
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list23 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list23, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list23);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            TestApplicationManagerKt.dropModuleRootCaches(project2);
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list24 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list24, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list24);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            TestApplicationManager testApplicationManager = TestApplicationManager.Companion.getInstanceIfCreated();
            if (testApplicationManager != null) {
                testApplicationManager.setDataProvider(null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list25 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list25, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list25);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            ProjectManagerEx.getInstanceEx().forceCloseProject(project2);
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list26 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list26, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list26);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list27 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list27, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list27);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            UiInterceptors.clear();
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list28 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list28, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list28);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            CompletionProgressIndicator.cleanupForNextTest();
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list29 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list29, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list29);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            int n = testCounter;
            testCounter = n + 1;
            if (n % 100 == 0) {
                GCUtil.clearBeanInfoCache();
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list30 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list30, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list30);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        ErrorKt.throwIfNotEmpty(l);
    }

    private static final void dropModuleRootCaches(Project project2) {
        WriteAction.runAndWait(new ThrowableRunnable(project2){
            final /* synthetic */ Project $project;

            public final void run() {
                ModuleManager moduleManager = ModuleManager.getInstance(this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                for (Module module : moduleManager.getModules()) {
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
                    if (moduleRootManager == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge");
                    }
                    ((ModuleRootComponentBridge)moduleRootManager).dropCaches();
                }
            }
            {
                this.$project = project2;
            }
        });
    }

    public static final void disposeApplicationAndCheckForLeaks() {
        List l = new ArrayList();
        boolean $i$f$runInEdtAndWait = false;
        EdtTestUtil.runInEdtAndWait(new ThrowableRunnable(l){
            final /* synthetic */ List $l$inlined;
            {
                this.$l$inlined = list2;
            }

            public final void run() {
                boolean bl = false;
                List $this$catchAndStoreExceptions$iv = this.$l$inlined;
                boolean $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl2 = false;
                    PlatformTestUtil.cleanupAllProjects();
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list2 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list2);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl3 = false;
                    UIUtil.dispatchAllInvocationEvents();
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list3 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list3);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl4 = false;
                    ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
                    if (scheduledExecutorService == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.concurrency.AppScheduledExecutorService");
                    }
                    Object object = ((AppScheduledExecutorService)scheduledExecutorService).statistics();
                    System.out.println(object);
                    ExecutorService executorService = ProcessIOExecutorService.INSTANCE;
                    if (executorService == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.process.ProcessIOExecutorService");
                    }
                    object = "ProcessIOExecutorService threads created: " + ((ProcessIOExecutorService)executorService).getThreadCounter();
                    System.out.println(object);
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list4 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list4);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    ApplicationImpl app;
                    Object object;
                    boolean bl5 = false;
                    Application application = ApplicationManager.getApplication();
                    if (!(application instanceof ApplicationImpl)) {
                        application = null;
                    }
                    if ((object = (app = (ApplicationImpl)application)) != null && (object = object.getMessageBus()) != null && (object = (AppLifecycleListener)object.syncPublisher(AppLifecycleListener.TOPIC)) != null) {
                        object.appWillBeClosed(false);
                    }
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list5 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list5, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list5);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl6 = false;
                    UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS);
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list6 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list6, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list6);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl7 = false;
                    try {
                        if (ApplicationManager.getApplication() != null) {
                            LeakHunter.checkNonDefaultProjectLeak();
                        }
                    }
                    catch (AssertionError e) {
                        TestApplicationManagerKt.publishHeapDump("leakedProjects");
                        throw (Throwable)((Object)e);
                    }
                    catch (Exception e) {
                        TestApplicationManagerKt.publishHeapDump("leakedProjects");
                        throw (Throwable)e;
                    }
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list7 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list7, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list7);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl8 = false;
                    TestApplicationManager testApplicationManager = TestApplicationManager.Companion.getInstanceIfCreated();
                    if (testApplicationManager != null) {
                        testApplicationManager.dispose();
                    }
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list8 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list8, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list8);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl9 = false;
                    UIUtil.dispatchAllInvocationEvents();
                }
                catch (CompoundRuntimeException e$iv) {
                    List<Throwable> list9 = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue(list9, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll((Collection)list9);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
            }
        });
        List $this$catchAndStoreExceptions$iv = l;
        boolean $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            try {
                Disposer.assertIsEmpty(true);
            }
            catch (AssertionError e) {
                TestApplicationManagerKt.publishHeapDump("disposerNonEmpty");
                throw (Throwable)((Object)e);
            }
            catch (Exception e) {
                TestApplicationManagerKt.publishHeapDump("disposerNonEmpty");
                throw (Throwable)e;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List<Throwable> list2 = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll((Collection)list2);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        ErrorKt.throwIfNotEmpty(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void checkJavaSwingTimersAreDisposed() {
        Method getTimer;
        Method sharedInstance;
        Class<?> timerQueueClass = Class.forName("javax.swing.TimerQueue");
        Method method2 = sharedInstance = timerQueueClass.getMethod("sharedInstance", new Class[0]);
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"sharedInstance");
        method2.setAccessible(true);
        Object timerQueue = sharedInstance.invoke(null, new Object[0]);
        DelayQueue delayQueue = ReflectionUtil.getField(timerQueueClass, timerQueue, DelayQueue.class, "queue");
        Object timer = delayQueue.peek();
        if (timer == null) {
            return;
        }
        long delay = timer.getDelay(TimeUnit.MILLISECONDS);
        String text2 = "(delayed for " + delay + "ms)";
        Method method3 = getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), "getTimer", new Class[0]);
        Intrinsics.checkNotNull((Object)method3);
        Object object = method3.invoke(timer, new Object[0]);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.Timer");
        }
        Timer swingTimer = (Timer)object;
        ActionListener[] actionListenerArray = swingTimer.getActionListeners();
        Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"swingTimer.actionListeners");
        text2 = "Timer (listeners: " + CollectionsKt.listOf((Object[])Arrays.copyOf(actionListenerArray, actionListenerArray.length)) + ") " + text2;
        try {
            throw (Throwable)new AssertionFailedError("Not disposed javax.swing.Timer: " + text2 + "; queue:" + timerQueue);
        }
        catch (Throwable throwable) {
            swingTimer.stop();
            throw throwable;
        }
    }

    @ApiStatus.Internal
    @JvmOverloads
    public static final void waitForProjectLeakingThreads(@NotNull Project project2, long timeout, @NotNull TimeUnit timeUnit) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            if (project2 instanceof ComponentManagerImpl) {
                ((ComponentManagerImpl)project2).stopServicePreloading();
            }
            Project $this$serviceIfCreated$iv = project2;
            boolean $i$f$serviceIfCreated = false;
            GeneratedSourceFileChangeTrackerImpl generatedSourceFileChangeTrackerImpl = (GeneratedSourceFileChangeTrackerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(GeneratedSourceFileChangeTracker.class);
            if (generatedSourceFileChangeTrackerImpl == null) break block1;
            generatedSourceFileChangeTrackerImpl.cancelAllAndWait(timeout, timeUnit);
        }
    }

    public static /* synthetic */ void waitForProjectLeakingThreads$default(Project project2, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            l = 10L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        TestApplicationManagerKt.waitForProjectLeakingThreads(project2, l, timeUnit);
    }

    @ApiStatus.Internal
    @JvmOverloads
    public static final void waitForProjectLeakingThreads(@NotNull Project project2, long timeout) {
        TestApplicationManagerKt.waitForProjectLeakingThreads$default(project2, timeout, null, 4, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    public static final void waitForProjectLeakingThreads(@NotNull Project project2) {
        TestApplicationManagerKt.waitForProjectLeakingThreads$default(project2, 0L, null, 6, null);
    }

    @NotNull
    public static final String publishHeapDump(@NotNull String fileNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)fileNamePrefix, (String)"fileNamePrefix");
        String fileName = fileNamePrefix + ".hprof.zip";
        Path dumpFile = Paths.get(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), fileName);
        try {
            Files.deleteIfExists(dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped(dumpFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dumpPath = ((Object)dumpFile.toAbsolutePath()).toString();
        String string2 = "##teamcity[publishArtifacts '" + dumpPath + "']";
        System.out.println((Object)string2);
        return dumpPath;
    }
}

