/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.SimpleApplicationBootstrapperKt;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.HeadlessDataManager;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.util.lang.Java11Shim;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u0010\u0005\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/testFramework/TestApplicationManager;", "", "()V", "dispose", "", "getData", "Lorg/jetbrains/annotations/Nullable;", "dataId", "", "setDataProvider", "provider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.platform.testFramework"})
public final class TestApplicationManager {
    private static volatile TestApplicationManager ourInstance;
    private static volatile Throwable bootstrapError;
    private static final AtomicBoolean isBootstrappingAppNow;
    @NotNull
    public static final Companion Companion;

    public final void setDataProvider(@Nullable DataProvider provider2) {
        TestApplicationManager.Companion.getDataManager().setTestDataProvider(provider2);
    }

    public final void setDataProvider(@Nullable DataProvider provider2, @Nullable Disposable parentDisposable) {
        HeadlessDataManager headlessDataManager = TestApplicationManager.Companion.getDataManager();
        Disposable disposable = parentDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        headlessDataManager.setTestDataProvider(provider2, disposable);
    }

    @Nullable
    public final Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return TestApplicationManager.Companion.getDataManager().getDataContext().getData(dataId);
    }

    public final void dispose() {
        ApplicationImpl applicationImpl = (ApplicationImpl)ApplicationManager.getApplication();
        if (applicationImpl == null) {
            return;
        }
        ApplicationImpl app = applicationImpl;
        app.invokeAndWait(new Runnable(app){
            final /* synthetic */ ApplicationImpl $app;

            public final void run() {
                this.$app.disposeContainer();
                TestApplicationManager.access$setOurInstance$cp(null);
            }
            {
                this.$app = applicationImpl;
            }
        });
    }

    private TestApplicationManager() {
    }

    static {
        Companion = new Companion(null);
        Java11Shim.INSTANCE = (Java11Shim)new StartupUtil.Java11ShimImpl();
        ExtensionNotApplicableException.useFactoryWithStacktrace();
        isBootstrappingAppNow = new AtomicBoolean();
    }

    public /* synthetic */ TestApplicationManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final TestApplicationManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final TestApplicationManager getInstanceIfCreated() {
        return Companion.getInstanceIfCreated();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/TestApplicationManager$Companion;", "", "()V", "bootstrapError", "", "dataManager", "Lcom/intellij/ide/impl/HeadlessDataManager;", "getDataManager", "()Lcom/intellij/ide/impl/HeadlessDataManager;", "isBootstrappingAppNow", "Ljava/util/concurrent/atomic/AtomicBoolean;", "ourInstance", "Lcom/intellij/testFramework/TestApplicationManager;", "createInstance", "getInstance", "getInstanceIfCreated", "intellij.platform.testFramework"})
    public static final class Companion {
        private final HeadlessDataManager getDataManager() {
            DataManager dataManager = DataManager.getInstance();
            if (dataManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.impl.HeadlessDataManager");
            }
            return (HeadlessDataManager)dataManager;
        }

        @JvmStatic
        @NotNull
        public final TestApplicationManager getInstance() {
            TestApplicationManager result2 = ourInstance;
            if (result2 == null) {
                try {
                    result2 = this.createInstance();
                }
                catch (Throwable e) {
                    bootstrapError = e;
                    isBootstrappingAppNow.set(false);
                    throw e;
                }
            }
            return result2;
        }

        @JvmStatic
        @Nullable
        public final TestApplicationManager getInstanceIfCreated() {
            return ourInstance;
        }

        private final synchronized TestApplicationManager createInstance() {
            TestApplicationManager result2 = ourInstance;
            if (result2 != null) {
                return result2;
            }
            Throwable throwable = bootstrapError;
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                throw it;
            }
            StartUpMeasurer.disable();
            if (!isBootstrappingAppNow.compareAndSet(false, true)) {
                throw (Throwable)new IllegalStateException("App bootstrap is already in process");
            }
            HeavyPlatformTestCase.doAutodetectPlatformPrefix();
            SimpleApplicationBootstrapperKt.doLoadApp((Function0<Unit>)((Function0)createInstance.2.INSTANCE));
            isBootstrappingAppNow.set(false);
            result2 = new TestApplicationManager(null);
            ourInstance = result2;
            return result2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

