/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public final class PsiTestUtil {
    @NotNull
    public static VirtualFile createTestProjectStructure(@NotNull Project project2, @Nullable Module module, String rootPath, @NotNull Collection<? super Path> filesToDelete, boolean addProjectRoots) {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(0);
        }
        if (filesToDelete == null) {
            PsiTestUtil.$$$reportNull$$$0(1);
        }
        Path dir = HeavyTestHelper.createTempDirectoryForTempDirTestFixture(null, "unitTest");
        filesToDelete.add(dir);
        VirtualFile vDir = HeavyTestHelper.createTestProjectStructure(module, rootPath, dir, addProjectRoots);
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        VirtualFile virtualFile2 = vDir;
        if (virtualFile2 == null) {
            PsiTestUtil.$$$reportNull$$$0(2);
        }
        return virtualFile2;
    }

    public static void removeAllRoots(@NotNull Module module, Sdk jdk) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(3);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> {
            model2.clear();
            if (jdk != null && ApplicationManager.getApplication().isUnitTestMode()) {
                WriteAction.runAndWait(() -> ProjectJdkTable.getInstance().addJdk(jdk, module.getProject()));
            }
            model2.setSdk(jdk);
        });
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module, @NotNull VirtualFile vDir) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(4);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(5);
        }
        return PsiTestUtil.addSourceContentToRoots(module, vDir, false);
    }

    @NotNull
    public static SourceFolder addSourceContentToRoots(@NotNull Module module, @NotNull VirtualFile vDir, boolean testSource) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(6);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(7);
        }
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel(module, model2 -> result2.set(model2.addContentEntry(vDir).addSourceFolder(vDir, testSource)));
        SourceFolder sourceFolder = (SourceFolder)result2.get();
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(8);
        }
        return sourceFolder;
    }

    @NotNull
    public static SourceFolder addResourceContentToRoots(@NotNull Module module, @NotNull VirtualFile vDir, boolean testResource) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(9);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(10);
        }
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel(module, model2 -> result2.set(model2.addContentEntry(vDir).addSourceFolder(vDir, testResource ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE)));
        SourceFolder sourceFolder = (SourceFolder)result2.get();
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(11);
        }
        return sourceFolder;
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module, @NotNull VirtualFile vDir) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(12);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(13);
        }
        return PsiTestUtil.addSourceRoot(module, vDir, false);
    }

    @NotNull
    public static SourceFolder addSourceRoot(@NotNull Module module, @NotNull VirtualFile vDir, boolean isTestSource) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(14);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(15);
        }
        return PsiTestUtil.addSourceRoot(module, vDir, isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(16);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(17);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(18);
        }
        return PsiTestUtil.addSourceRoot(module, vDir, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    @NotNull
    public static <P extends JpsElement> SourceFolder addSourceRoot(@NotNull Module module, @NotNull VirtualFile vDir, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(19);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(20);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(21);
        }
        if (properties == null) {
            PsiTestUtil.$$$reportNull$$$0(22);
        }
        Ref result2 = new Ref();
        ModuleRootModificationUtil.updateModel(module, model2 -> {
            ContentEntry entry = PsiTestUtil.findContentEntry(model2, vDir);
            if (entry == null) {
                entry = model2.addContentEntry(vDir);
            }
            result2.set(entry.addSourceFolder(vDir, rootType, properties));
        });
        SourceFolder sourceFolder = (SourceFolder)result2.get();
        if (sourceFolder == null) {
            PsiTestUtil.$$$reportNull$$$0(23);
        }
        return sourceFolder;
    }

    @Nullable
    private static ContentEntry findContentEntry(@NotNull ModuleRootModel rootModel, @NotNull VirtualFile file2) {
        if (rootModel == null) {
            PsiTestUtil.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(25);
        }
        return ContainerUtil.find(rootModel.getContentEntries(), object -> {
            VirtualFile entryRoot = object.getFile();
            return entryRoot != null && VfsUtilCore.isAncestor(entryRoot, file2, false);
        });
    }

    public static ContentEntry addContentRoot(@NotNull Module module, @NotNull VirtualFile vDir) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(26);
        }
        if (vDir == null) {
            PsiTestUtil.$$$reportNull$$$0(27);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> model2.addContentEntry(vDir));
        for (ContentEntry entry : ModuleRootManager.getInstance(module).getContentEntries()) {
            if (!Comparing.equal(entry.getFile(), vDir)) continue;
            return entry;
        }
        return null;
    }

    public static void addExcludedRoot(@NotNull Module module, @NotNull VirtualFile dir) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(28);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(29);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.findContentEntryWithAssertion(model2, dir).addExcludeFolder(dir)));
    }

    @NotNull
    private static ContentEntry findContentEntryWithAssertion(@NotNull ModifiableRootModel model2, @NotNull VirtualFile dir) {
        if (model2 == null) {
            PsiTestUtil.$$$reportNull$$$0(30);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(31);
        }
        return PsiTestUtil.assertEntryFound(model2, dir, PsiTestUtil.findContentEntry(model2, dir));
    }

    @NotNull
    private static ContentEntry assertEntryFound(@NotNull ModifiableRootModel model2, @NotNull VirtualFile dir, ContentEntry entry) {
        if (model2 == null) {
            PsiTestUtil.$$$reportNull$$$0(32);
        }
        if (dir == null) {
            PsiTestUtil.$$$reportNull$$$0(33);
        }
        if (entry == null) {
            throw new RuntimeException(dir + " is not under content roots: " + Arrays.toString(model2.getContentRoots()));
        }
        ContentEntry contentEntry = entry;
        if (contentEntry == null) {
            PsiTestUtil.$$$reportNull$$$0(34);
        }
        return contentEntry;
    }

    public static void removeContentEntry(@NotNull Module module, @NotNull VirtualFile contentRoot) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(35);
        }
        if (contentRoot == null) {
            PsiTestUtil.$$$reportNull$$$0(36);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> {
            ContentEntry entry = ContainerUtil.find(model2.getContentEntries(), object -> contentRoot.equals(object.getFile()));
            model2.removeContentEntry(PsiTestUtil.assertEntryFound(model2, contentRoot, entry));
        });
    }

    public static void removeSourceRoot(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(37);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(38);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model2, root);
            for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                if (!root.equals(sourceFolder.getFile())) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(@NotNull Module module, @NotNull VirtualFile root) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(39);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(40);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> {
            ContentEntry entry = PsiTestUtil.findContentEntryWithAssertion(model2, root);
            entry.removeExcludeFolder(root.getUrl());
        });
    }

    public static void checkErrorElements(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiTestUtil.$$$reportNull$$$0(41);
        }
        StringBuilder err = null;
        int s = 0;
        String text2 = element2.getText();
        for (PsiErrorElement error : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(element2)).filter(PsiErrorElement.class)) {
            TextRange r;
            if (err == null) {
                err = new StringBuilder();
            }
            if ((r = error.getTextRange()).getStartOffset() < s) continue;
            err.append(text2, s, r.getStartOffset()).append("<error desc=\"");
            err.append(error.getErrorDescription()).append("\">");
            err.append(error.getText()).append("</error>");
            s = r.getEndOffset();
        }
        if (err == null) {
            return;
        }
        err.append(text2, s, text2.length());
        UsefulTestCase.assertSameLines(text2, err.toString());
    }

    public static void checkFileStructure(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(42);
        }
        PsiTestUtil.compareFromAllRoots(file2, f -> DebugUtil.psiTreeToString(f, true));
    }

    private static void compareFromAllRoots(@NotNull PsiFile file2, @NotNull Function<? super PsiFile, String> fun) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(43);
        }
        if (fun == null) {
            PsiTestUtil.$$$reportNull$$$0(44);
        }
        PsiFile dummyFile = PsiTestUtil.createDummyCopy(file2);
        String psiTree = StringUtil.join(file2.getViewProvider().getAllFiles(), fun, "\n");
        String reparsedTree = StringUtil.join(dummyFile.getViewProvider().getAllFiles(), fun, "\n");
        PsiTestUtil.assertPsiTextTreeConsistency(psiTree, reparsedTree);
    }

    private static void assertPsiTextTreeConsistency(@NotNull String psiTree, @NotNull String reparsedTree) {
        if (psiTree == null) {
            PsiTestUtil.$$$reportNull$$$0(45);
        }
        if (reparsedTree == null) {
            PsiTestUtil.$$$reportNull$$$0(46);
        }
        if (!psiTree.equals(reparsedTree)) {
            String[] psiLines = StringUtil.splitByLinesDontTrim(psiTree);
            String[] reparsedLines = StringUtil.splitByLinesDontTrim(reparsedTree);
            int i = 0;
            while (true) {
                if (i >= psiLines.length || i >= reparsedLines.length || !psiLines[i].equals(reparsedLines[i])) break;
                ++i;
            }
            int n = Math.min(i, psiLines.length - 1);
            psiLines[n] = psiLines[n] + "   // in PSI structure";
            int n2 = Math.min(i, reparsedLines.length - 1);
            reparsedLines[n2] = reparsedLines[n2] + "   // re-created from text";
            psiTree = StringUtil.join(psiLines, "\n");
            reparsedTree = StringUtil.join(reparsedLines, "\n");
            Assert.assertEquals((Object)reparsedTree, (Object)psiTree);
        }
    }

    @NotNull
    private static PsiFile createDummyCopy(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(47);
        }
        LightVirtualFile copy = new LightVirtualFile(file2.getName(), file2.getText());
        copy.setOriginalFile(file2.getViewProvider().getVirtualFile());
        PsiFile dummyCopy = Objects.requireNonNull(file2.getManager().findFile(copy));
        if (dummyCopy instanceof PsiFileImpl) {
            ((PsiFileImpl)dummyCopy).setOriginalFile(file2);
        }
        PsiFile psiFile = dummyCopy;
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(48);
        }
        return psiFile;
    }

    public static void checkPsiMatchesTextIgnoringNonCode(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(49);
        }
        PsiTestUtil.compareFromAllRoots(file2, f -> DebugUtil.psiToStringIgnoringNonCode(f));
    }

    @Deprecated
    public static void disablePsiTextConsistencyChecks(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PsiTestUtil.$$$reportNull$$$0(50);
        }
        Registry.get("ide.check.structural.psi.text.consistency.in.tests").setValue(false, parentDisposable);
    }

    @NotNull
    public static LibraryBuilder newLibrary(String name2) {
        return new LibraryBuilder(name2);
    }

    public static void addLibrary(@NotNull Module module, @NotNull String libPath) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(51);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(52);
        }
        File file2 = new File(libPath);
        String libName = file2.getName();
        PsiTestUtil.addLibrary(module, libName, file2.getParent(), libName);
    }

    public static void addLibrary(@NotNull Module module, String libName, @NotNull String libPath, String ... jarArr) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(53);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(54);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(55);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> PsiTestUtil.addLibrary(model2, libName, libPath, jarArr));
    }

    public static void addLibrary(@NotNull Disposable parent, @NotNull Module module, String libName, @NotNull String libPath, String ... jarArr) {
        if (parent == null) {
            PsiTestUtil.$$$reportNull$$$0(56);
        }
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(57);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(58);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(59);
        }
        Ref ref = new Ref();
        ModuleRootModificationUtil.updateModel(module, model2 -> ref.set(PsiTestUtil.addLibrary(model2, libName, libPath, jarArr)));
        Disposer.register(parent, () -> PsiTestUtil.removeLibrary(module, (Library)ref.get()));
    }

    public static void removeLibrary(@NotNull Module module, @NotNull Library library2) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(60);
        }
        if (library2 == null) {
            PsiTestUtil.$$$reportNull$$$0(61);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> {
            LibraryOrderEntry entry = model2.findLibraryOrderEntry(library2);
            if (entry != null) {
                model2.removeOrderEntry(entry);
            }
        });
        WriteCommandAction.runWriteCommandAction(null, () -> {
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable(module.getProject());
            LibraryTable.ModifiableModel model2 = table.getModifiableModel();
            model2.removeLibrary(library2);
            model2.commit();
        });
    }

    public static void addProjectLibrary(@NotNull Module module, String libName, @NotNull List<String> classesRootPaths) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(62);
        }
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(63);
        }
        List<VirtualFile> roots2 = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(module, libName, roots2, Collections.emptyList());
    }

    @NotNull
    private static List<VirtualFile> getLibraryRoots(@NotNull List<String> classesRootPaths) {
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(64);
        }
        List<VirtualFile> list2 = ContainerUtil.map(classesRootPaths, path2 -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File((String)path2))));
        if (list2 == null) {
            PsiTestUtil.$$$reportNull$$$0(65);
        }
        return list2;
    }

    public static void addProjectLibrary(@NotNull ModifiableRootModel model2, String libName, @NotNull List<String> classesRootPaths) {
        if (model2 == null) {
            PsiTestUtil.$$$reportNull$$$0(66);
        }
        if (classesRootPaths == null) {
            PsiTestUtil.$$$reportNull$$$0(67);
        }
        List<VirtualFile> roots2 = PsiTestUtil.getLibraryRoots(classesRootPaths);
        PsiTestUtil.addProjectLibrary(model2, libName, roots2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static void addProjectLibrary(@NotNull Module module, String libName, VirtualFile ... classesRoots) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(68);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(69);
        }
        PsiTestUtil.addProjectLibrary(module, libName, Arrays.asList(classesRoots), Collections.emptyList());
    }

    @NotNull
    public static Library addProjectLibrary(@NotNull Module module, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(70);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(71);
        }
        if (sourceRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(72);
        }
        Ref result2 = Ref.create();
        ModuleRootModificationUtil.updateModel(module, model2 -> result2.set(PsiTestUtil.addProjectLibrary(model2, libName, classesRoots, sourceRoots, Collections.emptyList(), Collections.emptyList())));
        Library library2 = (Library)result2.get();
        if (library2 == null) {
            PsiTestUtil.$$$reportNull$$$0(73);
        }
        return library2;
    }

    @NotNull
    private static Library addProjectLibrary(@NotNull ModifiableRootModel model2, String libName, @NotNull List<? extends VirtualFile> classesRoots, @NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> javaDocs, @NotNull List<? extends VirtualFile> externalAnnotationsRoots) {
        if (model2 == null) {
            PsiTestUtil.$$$reportNull$$$0(74);
        }
        if (classesRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(75);
        }
        if (sourceRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(76);
        }
        if (javaDocs == null) {
            PsiTestUtil.$$$reportNull$$$0(77);
        }
        if (externalAnnotationsRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(78);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(model2.getProject());
        Library library2 = WriteAction.computeAndWait(() -> {
            Library library2 = libraryTable.createLibrary(libName);
            Library.ModifiableModel libraryModel = library2.getModifiableModel();
            try {
                for (VirtualFile root : classesRoots) {
                    libraryModel.addRoot(root, OrderRootType.CLASSES);
                }
                for (VirtualFile root : sourceRoots) {
                    libraryModel.addRoot(root, OrderRootType.SOURCES);
                }
                for (VirtualFile root : javaDocs) {
                    libraryModel.addRoot(root, JavadocOrderRootType.getInstance());
                }
                for (VirtualFile root : externalAnnotationsRoots) {
                    libraryModel.addRoot(root, AnnotationOrderRootType.getInstance());
                }
                libraryModel.commit();
            }
            catch (Throwable t) {
                libraryModel.dispose();
                throw t;
            }
            model2.addLibraryEntry(library2);
            OrderEntry[] orderEntries = model2.getOrderEntries();
            OrderEntry last2 = orderEntries[orderEntries.length - 1];
            System.arraycopy(orderEntries, 0, orderEntries, 1, orderEntries.length - 1);
            orderEntries[0] = last2;
            model2.rearrangeOrderEntries(orderEntries);
            return library2;
        });
        if (library2 == null) {
            PsiTestUtil.$$$reportNull$$$0(79);
        }
        return library2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Library addLibrary(@NotNull ModifiableRootModel model2, String libName, @NotNull String libPath, String ... jarArr) {
        if (model2 == null) {
            PsiTestUtil.$$$reportNull$$$0(80);
        }
        if (libPath == null) {
            PsiTestUtil.$$$reportNull$$$0(81);
        }
        if (jarArr == null) {
            PsiTestUtil.$$$reportNull$$$0(82);
        }
        ArrayList<VirtualFile> classesRoots = new ArrayList<VirtualFile>();
        for (String string2 : jarArr) {
            void var8_9;
            String path2;
            if (!libPath.endsWith("/") && !string2.startsWith("/")) {
                String string3 = "/" + string2;
            }
            VirtualFile root = (path2 = libPath + (String)var8_9).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(path2 + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
            assert (root != null) : "Library root folder not found: " + path2 + "!/";
            classesRoots.add(root);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(model2.getProject());
        if (libraryTable.getLibraryByName((String)libName) != null) {
            for (int index = 0; index < 100000; ++index) {
                String candidate = (String)libName + "-" + index;
                if (libraryTable.getLibraryByName(candidate) != null) continue;
                libName = candidate;
                break;
            }
        }
        return PsiTestUtil.addProjectLibrary(model2, (String)libName, classesRoots, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static void addLibrary(@NotNull Module module, String libName, @NotNull String libDir, String @NotNull [] classRoots, String @NotNull [] sourceRoots) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(83);
        }
        if (libDir == null) {
            PsiTestUtil.$$$reportNull$$$0(84);
        }
        if (classRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(85);
        }
        if (sourceRoots == null) {
            PsiTestUtil.$$$reportNull$$$0(86);
        }
        String proto = (classRoots.length > 0 ? classRoots[0] : sourceRoots[0]).endsWith(".jar!/") ? "jar" : "file";
        String parentUrl = VirtualFileManager.constructUrl(proto, libDir);
        ArrayList<String> classesUrls = new ArrayList<String>();
        for (String classRoot : classRoots) {
            classesUrls.add(parentUrl + classRoot);
        }
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (String sourceRoot : sourceRoots) {
            sourceUrls.add(parentUrl + sourceRoot);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesUrls, sourceUrls);
    }

    @NotNull
    public static Module addModule(@NotNull Project project2, @NotNull ModuleType type, @NotNull String name2, @NotNull VirtualFile root) {
        if (project2 == null) {
            PsiTestUtil.$$$reportNull$$$0(87);
        }
        if (type == null) {
            PsiTestUtil.$$$reportNull$$$0(88);
        }
        if (name2 == null) {
            PsiTestUtil.$$$reportNull$$$0(89);
        }
        if (root == null) {
            PsiTestUtil.$$$reportNull$$$0(90);
        }
        Module module = WriteCommandAction.writeCommandAction(project2).compute(() -> {
            String moduleName;
            ModifiableModuleModel moduleModel = ModuleManager.getInstance(project2).getModifiableModel();
            try {
                moduleName = moduleModel.newModule(root.toNioPath().resolve(name2 + ".iml"), type.getId()).getName();
                moduleModel.commit();
            }
            catch (Throwable t) {
                moduleModel.dispose();
                throw t;
            }
            Module dep = ModuleManager.getInstance(project2).findModuleByName(moduleName);
            assert (dep != null) : moduleName;
            ModifiableRootModel model2 = ModuleRootManager.getInstance(dep).getModifiableModel();
            try {
                model2.addContentEntry(root).addSourceFolder(root, false);
                model2.commit();
            }
            catch (Throwable t) {
                model2.dispose();
                throw t;
            }
            return dep;
        });
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(91);
        }
        return module;
    }

    public static void setCompilerOutputPath(@NotNull Module module, @NotNull String url, boolean forTests) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(92);
        }
        if (url == null) {
            PsiTestUtil.$$$reportNull$$$0(93);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> {
            CompilerModuleExtension extension2 = model2.getModuleExtension(CompilerModuleExtension.class);
            extension2.inheritCompilerOutputPath(false);
            if (forTests) {
                extension2.setCompilerOutputPathForTests(url);
            } else {
                extension2.setCompilerOutputPath(url);
            }
        });
    }

    public static void setExcludeCompileOutput(@NotNull Module module, boolean exclude) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(94);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> model2.getModuleExtension(CompilerModuleExtension.class).setExcludeOutput(exclude));
    }

    public static void setJavadocUrls(@NotNull Module module, String ... urls) {
        if (module == null) {
            PsiTestUtil.$$$reportNull$$$0(95);
        }
        if (urls == null) {
            PsiTestUtil.$$$reportNull$$$0(96);
        }
        ModuleRootModificationUtil.updateModel(module, model2 -> model2.getModuleExtension(JavaModuleExternalPaths.class).setJavadocUrls(urls));
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addJdkAnnotations(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(97);
        }
        String path2 = FileUtil.toSystemIndependentName(PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path2);
        return PsiTestUtil.addRootsToJdk(sdk2, AnnotationOrderRootType.getInstance(), root);
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addRootsToJdk(@NotNull Sdk sdk2, @NotNull OrderRootType rootType, VirtualFile ... roots2) {
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(98);
        }
        if (rootType == null) {
            PsiTestUtil.$$$reportNull$$$0(99);
        }
        if (roots2 == null) {
            PsiTestUtil.$$$reportNull$$$0(100);
        }
        return PsiTestUtil.modifyJdkRoots(sdk2, sdkModificator -> {
            for (VirtualFile root : roots2) {
                sdkModificator.setName(sdkModificator.getName() + "+" + root.getPath());
                sdkModificator.addRoot(root, rootType);
            }
        });
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk modifyJdkRoots(@NotNull Sdk sdk2, Consumer<? super SdkModificator> modifier) {
        Sdk clone;
        if (sdk2 == null) {
            PsiTestUtil.$$$reportNull$$$0(101);
        }
        try {
            clone = (Sdk)sdk2.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = clone.getSdkModificator();
        modifier.accept(sdkModificator);
        sdkModificator.commitChanges();
        Sdk sdk3 = clone;
        if (sdk3 == null) {
            PsiTestUtil.$$$reportNull$$$0(102);
        }
        return sdk3;
    }

    public static void checkStubsMatchText(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTestUtil.$$$reportNull$$$0(103);
        }
        try {
            StubTextInconsistencyException.checkStubTextConsistency(file2);
        }
        catch (StubTextInconsistencyException e) {
            PsiTestUtil.compareStubTexts(e);
        }
    }

    public static void compareStubTexts(@NotNull StubTextInconsistencyException e) {
        if (e == null) {
            PsiTestUtil.$$$reportNull$$$0(104);
        }
        PsiTestUtil.assertPsiTextTreeConsistency(e.getStubsFromPsi(), e.getStubsFromText());
        throw e;
    }

    public static void checkPsiStructureWithCommit(@NotNull PsiFile psiFile, @NotNull Consumer<? super PsiFile> checker) {
        if (psiFile == null) {
            PsiTestUtil.$$$reportNull$$$0(105);
        }
        if (checker == null) {
            PsiTestUtil.$$$reportNull$$$0(106);
        }
        checker.accept(psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(psiFile.getProject());
        if (document != null && manager.isUncommited(document)) {
            manager.commitDocument(document);
            checker.accept(manager.getPsiFile(document));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 23: 
            case 34: 
            case 48: 
            case 65: 
            case 73: 
            case 79: 
            case 91: 
            case 102: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 23: 
            case 34: 
            case 48: 
            case 65: 
            case 73: 
            case 79: 
            case 91: 
            case 102: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 23: 
            case 34: 
            case 48: 
            case 65: 
            case 73: 
            case 79: 
            case 91: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 51: 
            case 53: 
            case 57: 
            case 60: 
            case 62: 
            case 68: 
            case 70: 
            case 83: 
            case 92: 
            case 94: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 18: 
            case 21: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 30: 
            case 32: 
            case 66: 
            case 74: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 38: 
            case 40: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTree";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparsedTree";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 52: 
            case 54: 
            case 58: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libPath";
                break;
            }
            case 55: 
            case 59: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarArr";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 63: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRootPaths";
                break;
            }
            case 69: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 72: 
            case 76: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocs";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalAnnotationsRoots";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRoots";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 97: 
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProjectStructure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceContentToRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addResourceContentToRoots";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceRoot";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "assertEntryFound";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyCopy";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 73: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "addProjectLibrary";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "addModule";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyJdkRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestProjectStructure";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 23: 
            case 34: 
            case 48: 
            case 65: 
            case 73: 
            case 79: 
            case 91: 
            case 102: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentToRoots";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addResourceContentToRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntry";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addContentRoot";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntryWithAssertion";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "assertEntryFound";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeContentEntry";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceRoot";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkErrorElements";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkFileStructure";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "compareFromAllRoots";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "assertPsiTextTreeConsistency";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createDummyCopy";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiMatchesTextIgnoringNonCode";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "disablePsiTextConsistencyChecks";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addProjectLibrary";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "setCompilerOutputPath";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "setExcludeCompileOutput";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "setJavadocUrls";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "addJdkAnnotations";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToJdk";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "modifyJdkRoots";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "checkStubsMatchText";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "compareStubTexts";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiStructureWithCommit";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 23: 
            case 34: 
            case 48: 
            case 65: 
            case 73: 
            case 79: 
            case 91: 
            case 102: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class LibraryBuilder {
        private final String myName;
        private final List<VirtualFile> myClassesRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> mySourceRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myJavaDocRoots = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myExternalAnnotationsRoots = new ArrayList<VirtualFile>();

        private LibraryBuilder(String name2) {
            this.myName = name2;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(0);
            }
            this.myClassesRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(1);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder classesRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(2);
            }
            this.myClassesRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(3);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(4);
            }
            this.mySourceRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(5);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder sourceRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(6);
            }
            this.mySourceRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(7);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull VirtualFile root) {
            if (root == null) {
                LibraryBuilder.$$$reportNull$$$0(8);
            }
            this.myJavaDocRoots.add(root);
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(9);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder javaDocRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(10);
            }
            this.myJavaDocRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(11);
            }
            return libraryBuilder;
        }

        @NotNull
        public LibraryBuilder externalAnnotationsRoot(@NotNull String rootPath) {
            if (rootPath == null) {
                LibraryBuilder.$$$reportNull$$$0(12);
            }
            this.myExternalAnnotationsRoots.add(VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot(new File(rootPath))));
            LibraryBuilder libraryBuilder = this;
            if (libraryBuilder == null) {
                LibraryBuilder.$$$reportNull$$$0(13);
            }
            return libraryBuilder;
        }

        @NotNull
        public Library addTo(@NotNull ModifiableRootModel model2) {
            if (model2 == null) {
                LibraryBuilder.$$$reportNull$$$0(14);
            }
            Library library2 = PsiTestUtil.addProjectLibrary(model2, this.myName, this.myClassesRoots, this.mySourceRoots, this.myJavaDocRoots, this.myExternalAnnotationsRoots);
            if (library2 == null) {
                LibraryBuilder.$$$reportNull$$$0(15);
            }
            return library2;
        }

        @NotNull
        public Library addTo(@NotNull Module module) {
            if (module == null) {
                LibraryBuilder.$$$reportNull$$$0(16);
            }
            Ref result2 = Ref.create();
            ModuleRootModificationUtil.updateModel(module, model2 -> result2.set(this.addTo((ModifiableRootModel)model2)));
            Library library2 = (Library)result2.get();
            if (library2 == null) {
                LibraryBuilder.$$$reportNull$$$0(17);
            }
            return library2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/PsiTestUtil$LibraryBuilder";
                    break;
                }
                case 2: 
                case 6: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/PsiTestUtil$LibraryBuilder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classesRoot";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sourceRoot";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "javaDocRoot";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "externalAnnotationsRoot";
                    break;
                }
                case 15: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addTo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "classesRoot";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "sourceRoot";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "javaDocRoot";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "externalAnnotationsRoot";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addTo";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

