/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.StorageLockContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PerformanceTestInfo {
    private final ThrowableComputable<Integer, ?> test;
    private final int expectedMs;
    private final int expectedInputSize;
    private ThrowableRunnable<?> setup;
    private int usedReferenceCpuCores;
    private int maxRetries;
    private final String what;
    private boolean adjustForIO;
    private boolean adjustForCPU;
    private boolean useLegacyScaling;
    private long lastJitUsage;
    private long lastJitStamp;

    PerformanceTestInfo(@NotNull ThrowableComputable<Integer, ?> test, int expectedMs, int expectedInputSize, @NotNull String what) {
        if (test == null) {
            PerformanceTestInfo.$$$reportNull$$$0(0);
        }
        if (what == null) {
            PerformanceTestInfo.$$$reportNull$$$0(1);
        }
        this.usedReferenceCpuCores = 1;
        this.maxRetries = 4;
        this.adjustForCPU = true;
        this.lastJitStamp = -1L;
        this.test = test;
        this.expectedMs = expectedMs;
        this.expectedInputSize = expectedInputSize;
        assert (expectedMs > 0) : "Expected must be > 0. Was: " + expectedMs;
        assert (expectedInputSize > 0) : "Expected input size must be > 0. Was: " + expectedInputSize;
        this.what = what;
    }

    @Contract(pure=true)
    public PerformanceTestInfo setup(@NotNull ThrowableRunnable<?> setup) {
        if (setup == null) {
            PerformanceTestInfo.$$$reportNull$$$0(2);
        }
        assert (this.setup == null);
        this.setup = setup;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesAllCPUCores() {
        return this.usesMultipleCPUCores(8);
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesMultipleCPUCores(int maxCores) {
        assert (this.adjustForCPU) : "This test configured to be io-bound, it cannot use all cores";
        this.usedReferenceCpuCores = maxCores;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo ioBound() {
        this.adjustForIO = true;
        this.adjustForCPU = false;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo attempts(int attempts) {
        this.maxRetries = attempts;
        return this;
    }

    @Deprecated
    @Contract(pure=true)
    public PerformanceTestInfo useLegacyScaling() {
        this.useLegacyScaling = true;
        return this;
    }

    public void assertTiming() {
        if (PlatformTestUtil.COVERAGE_ENABLED_BUILD) {
            return;
        }
        Timings.getStatistics();
        this.updateJitUsage();
        if (this.maxRetries == 1) {
            System.gc();
        }
        int initialMaxRetries = this.maxRetries;
        for (int attempt = 1; attempt <= this.maxRetries; ++attempt) {
            CpuUsageData data2;
            AtomicInteger actualInputSize;
            try {
                if (this.setup != null) {
                    this.setup.run();
                }
                PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                actualInputSize = new AtomicInteger(this.expectedInputSize);
                data2 = CpuUsageData.measureCpuUsage(() -> actualInputSize.set(this.test.compute()));
            }
            catch (Throwable throwable) {
                ExceptionUtil.rethrowUnchecked(throwable);
                throw new RuntimeException(throwable);
            }
            int expectedOnMyMachine = this.getExpectedTimeOnThisMachine(actualInputSize.get());
            IterationResult iterationResult = data2.getIterationResult(expectedOnMyMachine);
            boolean testPassed = iterationResult == IterationResult.ACCEPTABLE || iterationResult == IterationResult.BORDERLINE;
            String logMessage = this.formatMessage(data2, expectedOnMyMachine, actualInputSize.get(), iterationResult, initialMaxRetries);
            if (testPassed) {
                TeamCityLogger.info((String)logMessage);
                System.out.println("\nSUCCESS: " + logMessage);
                return;
            }
            TeamCityLogger.warning((String)logMessage, null);
            if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                System.out.println("\nWARNING: " + logMessage);
            }
            JitUsageResult jitUsage = this.updateJitUsage();
            if (attempt == this.maxRetries) {
                throw new AssertionFailedError(logMessage);
            }
            if ((iterationResult == IterationResult.DISTRACTED || jitUsage == JitUsageResult.UNCLEAR) && attempt < initialMaxRetries + 30 && this.maxRetries != 1) {
                ++this.maxRetries;
            }
            String s = "  " + (this.maxRetries - attempt) + " " + StringUtil.pluralize("attempt", this.maxRetries - attempt) + " remain" + (String)(jitUsage == JitUsageResult.UNCLEAR ? " (waiting for JITc; its usage was " + jitUsage + " in this iteration)" : "");
            TeamCityLogger.warning((String)s, null);
            if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                System.out.println(s);
            }
            System.gc();
            StorageLockContext.forceDirectMemoryCache();
        }
    }

    @NotNull
    private String formatMessage(@NotNull CpuUsageData data2, int expectedOnMyMachine, int actualInputSize, @NotNull IterationResult iterationResult, int initialMaxRetries) {
        if (data2 == null) {
            PerformanceTestInfo.$$$reportNull$$$0(3);
        }
        if (iterationResult == null) {
            PerformanceTestInfo.$$$reportNull$$$0(4);
        }
        long duration = data2.durationMs;
        int percentage = (int)(100.0 * (double)(duration - (long)expectedOnMyMachine) / (double)expectedOnMyMachine);
        String colorCode = iterationResult == IterationResult.ACCEPTABLE ? "32;1m" : (iterationResult == IterationResult.BORDERLINE ? "33;1m" : "31;1m");
        String string2 = this.what + " took \u001b[" + colorCode + Math.abs(percentage) + "% " + (percentage > 0 ? "more" : "less") + " time\u001b[0m than expected" + (iterationResult == IterationResult.DISTRACTED && initialMaxRetries != 1 ? " (but JIT compilation took too long, will retry anyway)" : "") + "\n  Expected: " + expectedOnMyMachine + "ms (" + StringUtil.formatDuration(expectedOnMyMachine) + ")\n  Actual:   " + duration + "ms (" + StringUtil.formatDuration(duration) + ")" + (String)(this.expectedInputSize != actualInputSize ? "\n  (Expected time was adjusted accordingly to input size: expected " + this.expectedInputSize + ", actual " + actualInputSize + ".)" : "") + "\n  Timings:  " + Timings.getStatistics() + "\n  Threads:  " + data2.getThreadStats() + "\n  GC stats: " + data2.getGcStats() + "\n  Process:  " + data2.getProcessCpuStats();
        if (string2 == null) {
            PerformanceTestInfo.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private JitUsageResult updateJitUsage() {
        long timeNow = System.nanoTime();
        long jitNow = CpuUsageData.getTotalCompilationMillis();
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(timeNow - this.lastJitStamp);
        if (this.lastJitStamp >= 0L) {
            if (elapsedMillis >= 3000L) {
                if (jitNow - this.lastJitUsage <= elapsedMillis / 10L) {
                    return JitUsageResult.DEFINITELY_LOW;
                }
            } else {
                return JitUsageResult.UNCLEAR;
            }
        }
        this.lastJitStamp = timeNow;
        this.lastJitUsage = jitNow;
        return JitUsageResult.UNCLEAR;
    }

    private int getExpectedTimeOnThisMachine(int actualInputSize) {
        int expectedOnMyMachine = (int)((long)this.expectedMs * (long)actualInputSize / (long)this.expectedInputSize);
        if (this.adjustForCPU) {
            int coreCountUsedHere = this.usedReferenceCpuCores < 8 ? Math.min(JobSchedulerImpl.getJobPoolParallelism(), this.usedReferenceCpuCores) : JobSchedulerImpl.getJobPoolParallelism();
            expectedOnMyMachine *= this.usedReferenceCpuCores;
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.CPU_TIMING, 200L, this.useLegacyScaling);
            expectedOnMyMachine /= coreCountUsedHere;
        }
        if (this.adjustForIO) {
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.IO_TIMING, 100L, this.useLegacyScaling);
        }
        return expectedOnMyMachine;
    }

    private static int adjust(int expectedOnMyMachine, long thisTiming, long referenceTiming, boolean useLegacyScaling) {
        if (useLegacyScaling) {
            double speed = 1.0 * (double)thisTiming / (double)referenceTiming;
            double delta = speed < 1.0 ? 0.9 + Math.pow(speed - 0.7, 2.0) : 0.45 + Math.pow(speed - 0.25, 2.0);
            expectedOnMyMachine = (int)((double)expectedOnMyMachine * delta);
            return expectedOnMyMachine;
        }
        return (int)((long)expectedOnMyMachine * thisTiming / referenceTiming);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterationResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PerformanceTestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PerformanceTestInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatMessage";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static enum IterationResult {
        ACCEPTABLE,
        BORDERLINE,
        SLOW,
        DISTRACTED;

    }

    private static enum JitUsageResult {
        DEFINITELY_LOW,
        UNCLEAR;

    }
}

