/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStructureTestFixture
implements Disposable {
    private final CodeInsightTestFixture myFixture;
    private FileStructurePopup myPopup;
    private PsiFile myFile;

    public FileStructureTestFixture(@NotNull CodeInsightTestFixture fixture) {
        if (fixture == null) {
            FileStructureTestFixture.$$$reportNull$$$0(0);
        }
        this.myFixture = fixture;
    }

    @Nullable
    public FilteringTreeStructure.FilteringNode update() {
        FileStructurePopup popup2 = this.getPopup();
        UIUtil.dispatchAllInvocationEvents();
        PlatformTestUtil.waitForPromise(popup2.rebuildAndUpdate());
        TreePath path2 = PlatformTestUtil.waitForPromise(popup2.select(popup2.getCurrentElement(this.myFile)));
        return (FilteringTreeStructure.FilteringNode)TreeUtil.getLastUserObject(FilteringTreeStructure.FilteringNode.class, (TreePath)path2);
    }

    public Tree getTree() {
        return this.getPopup().getTree();
    }

    public TreeSpeedSearch getSpeedSearch() {
        return this.getPopup().getSpeedSearch();
    }

    public FilteringTreeStructure.FilteringNode getRootNode() {
        return (FilteringTreeStructure.FilteringNode)TreeUtil.getUserObject(FilteringTreeStructure.FilteringNode.class, (Object)this.getTree().getModel().getRoot());
    }

    @NotNull
    public FileStructurePopup getPopup() {
        if (this.myPopup == null || this.myFile != this.myFixture.getFile()) {
            if (this.myPopup != null) {
                Disposer.dispose(this.myPopup);
                this.myPopup = null;
            }
            this.myFile = this.myFixture.getFile();
            this.myPopup = ViewStructureAction.createPopup(this.myFixture.getProject(), (FileEditor)TextEditorProvider.getInstance().getTextEditor(this.myFixture.getEditor()));
            assert (this.myPopup != null);
            Disposer.register(this, this.myPopup);
            this.myPopup.createCenterPanel();
        }
        FileStructurePopup fileStructurePopup = this.myPopup;
        if (fileStructurePopup == null) {
            FileStructureTestFixture.$$$reportNull$$$0(1);
        }
        return fileStructurePopup;
    }

    @Override
    public void dispose() {
        this.myPopup = null;
        this.myFile = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/FileStructureTestFixture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/FileStructureTestFixture";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

