/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.BundleBase;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceHandler;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SlicePanel;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceToolwindowSettings;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="SliceManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class SliceManager
implements PersistentStateComponent<StoredSettingsBean> {
    private final Project myProject;
    private ContentManager myBackContentManager;
    private ContentManager myForthContentManager;
    @NotNull
    private final StoredSettingsBean myStoredSettings;
    @NonNls
    private static final String BACK_TOOLWINDOW_ID = "Analyze Dataflow to";
    @NonNls
    private static final String FORTH_TOOLWINDOW_ID = "Analyze Dataflow from";

    public static SliceManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            SliceManager.$$$reportNull$$$0(0);
        }
        return project2.getService(SliceManager.class);
    }

    public SliceManager(@NotNull Project project2) {
        if (project2 == null) {
            SliceManager.$$$reportNull$$$0(1);
        }
        this.myStoredSettings = new StoredSettingsBean();
        this.myProject = project2;
    }

    private ContentManager getContentManager(boolean dataFlowToThis) {
        if (dataFlowToThis) {
            if (this.myBackContentManager == null) {
                ToolWindow backToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(RegisterToolWindowTask.closable((String)BACK_TOOLWINDOW_ID, LangBundle.messagePointer("toolwindow.name.dataflow.to.here", new Object[0]), (Icon)AllIcons.Toolwindows.ToolWindowAnalyzeDataflow, (ToolWindowAnchor)ToolWindowAnchor.BOTTOM));
                this.myBackContentManager = backToolWindow.getContentManager();
                ContentManagerWatcher.watchContentManager((ToolWindow)backToolWindow, (ContentManager)this.myBackContentManager);
            }
            return this.myBackContentManager;
        }
        if (this.myForthContentManager == null) {
            ToolWindow forthToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(RegisterToolWindowTask.closable((String)FORTH_TOOLWINDOW_ID, LangBundle.messagePointer("toolwindow.name.dataflow.from.here", new Object[0]), (Icon)AllIcons.Toolwindows.ToolWindowAnalyzeDataflow, (ToolWindowAnchor)ToolWindowAnchor.BOTTOM));
            this.myForthContentManager = forthToolWindow.getContentManager();
            ContentManagerWatcher.watchContentManager((ToolWindow)forthToolWindow, (ContentManager)this.myForthContentManager);
        }
        return this.myForthContentManager;
    }

    public void slice(@NotNull PsiElement element2, boolean dataFlowToThis, @NotNull SliceHandler handler) {
        if (element2 == null) {
            SliceManager.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            SliceManager.$$$reportNull$$$0(3);
        }
        String dialogTitle = SliceManager.getElementDescription(dataFlowToThis ? LangBundle.message("tab.title.analyze.dataflow.to.here", new Object[0]) : LangBundle.message("tab.title.analyze.dataflow.from", new Object[0]), element2, null);
        SliceAnalysisParams params = handler.askForParams(element2, this.myStoredSettings, StringUtil.unescapeXmlEntities(dialogTitle = this.filterStyle(dialogTitle)));
        if (params == null) {
            return;
        }
        this.createToolWindow(element2, params);
    }

    @Contract(pure=true)
    private String filterStyle(String dialogTitle) {
        return Pattern.compile("(<style>.*</style>)|<[^<>]*>", 32).matcher(dialogTitle).replaceAll("");
    }

    public void createToolWindow(@NotNull PsiElement element2, @NotNull SliceAnalysisParams params) {
        if (element2 == null) {
            SliceManager.$$$reportNull$$$0(4);
        }
        if (params == null) {
            SliceManager.$$$reportNull$$$0(5);
        }
        SliceRootNode rootNode = new SliceRootNode(this.myProject, new DuplicateMap(), LanguageSlicing.getProvider(element2).createRootUsage(element2, params));
        this.createToolWindow(params.dataFlowToThis, rootNode, false, SliceManager.getElementDescription(null, element2, null));
    }

    public void createToolWindow(boolean dataFlowToThis, @NotNull SliceRootNode rootNode, boolean splitByLeafExpressions, @NotNull @NlsContexts.TabTitle String displayName) {
        if (rootNode == null) {
            SliceManager.$$$reportNull$$$0(6);
        }
        if (displayName == null) {
            SliceManager.$$$reportNull$$$0(7);
        }
        final SliceToolwindowSettings sliceToolwindowSettings = SliceToolwindowSettings.getInstance(this.myProject);
        final ContentManager contentManager = this.getContentManager(dataFlowToThis);
        final Content[] myContent = new Content[1];
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(dataFlowToThis ? BACK_TOOLWINDOW_ID : FORTH_TOOLWINDOW_ID);
        SlicePanel slicePanel = new SlicePanel(this.myProject, dataFlowToThis, rootNode, splitByLeafExpressions, toolWindow){

            @Override
            protected void close() {
                super.close();
                contentManager.removeContent(myContent[0], true);
            }

            @Override
            public boolean isAutoScroll() {
                return sliceToolwindowSettings.isAutoScroll();
            }

            @Override
            public void setAutoScroll(boolean autoScroll) {
                sliceToolwindowSettings.setAutoScroll(autoScroll);
            }

            @Override
            public boolean isPreview() {
                return sliceToolwindowSettings.isPreview();
            }

            @Override
            public void setPreview(boolean preview2) {
                sliceToolwindowSettings.setPreview(preview2);
            }
        };
        myContent[0] = contentManager.getFactory().createContent((JComponent)slicePanel, displayName, true);
        contentManager.addContent(myContent[0]);
        contentManager.setSelectedContent(myContent[0]);
        toolWindow.activate(null);
    }

    @NlsContexts.TabTitle
    public static String getElementDescription(@NlsContexts.TabTitle String prefix, PsiElement element2, @NlsContexts.TabTitle String suffix) {
        SliceLanguageSupportProvider provider2 = LanguageSlicing.getProvider(element2);
        if (provider2 != null) {
            element2 = provider2.getElementForDescription(element2);
        }
        String desc = ElementDescriptionUtil.getElementDescription(element2, RefactoringDescriptionLocation.WITHOUT_PARENT);
        String firstPartOfDescription = StringUtil.first(desc, 100, true);
        return "<html><body>" + (prefix == null ? firstPartOfDescription : BundleBase.format(prefix, firstPartOfDescription)) + (suffix == null ? "" : suffix) + "</body></html>";
    }

    @Override
    public StoredSettingsBean getState() {
        return this.myStoredSettings;
    }

    @Override
    public void loadState(@NotNull StoredSettingsBean state) {
        if (state == null) {
            SliceManager.$$$reportNull$$$0(8);
        }
        this.myStoredSettings.analysisUIOptions.loadState(state.analysisUIOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/slicer/SliceManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "slice";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindow";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class StoredSettingsBean {
        boolean showDereferences = true;
        AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();

        StoredSettingsBean() {
        }
    }
}

