/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.semantic.SemElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SemKey<T extends SemElement> {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final String myDebugName;
    private final SemKey<? super T> @NotNull [] mySupers;
    private final List<SemKey<?>> myInheritors;
    private final int myUniqueId;

    @SafeVarargs
    private SemKey(String debugName, SemKey<? super T> ... supers) {
        if (supers == null) {
            SemKey.$$$reportNull$$$0(0);
        }
        this.myInheritors = ContainerUtil.createEmptyCOWList();
        this.myDebugName = debugName;
        this.mySupers = supers;
        this.myUniqueId = counter.getAndIncrement();
        this.myInheritors.add(this);
        this.registerInheritor(this);
    }

    private void registerInheritor(SemKey<?> eachParent) {
        for (SemKey<? super T> superKey : eachParent.mySupers) {
            superKey.myInheritors.add(this);
            this.registerInheritor(superKey);
        }
    }

    public SemKey<? super T> @NotNull [] getSupers() {
        if (this.mySupers == null) {
            SemKey.$$$reportNull$$$0(1);
        }
        return this.mySupers;
    }

    public List<SemKey<?>> getInheritors() {
        return this.myInheritors;
    }

    public boolean isKindOf(SemKey<?> another) {
        if (another == this) {
            return true;
        }
        for (SemKey<T> semKey : this.mySupers) {
            if (!semKey.isKindOf(another)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.myDebugName;
    }

    @SafeVarargs
    @NotNull
    public static <T extends SemElement> SemKey<T> createKey(String debugName, SemKey<? super T> ... supers) {
        if (supers == null) {
            SemKey.$$$reportNull$$$0(2);
        }
        return new SemKey<T>(debugName, supers);
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    @SafeVarargs
    @NotNull
    public final <K extends T> SemKey<K> subKey(@NonNls String debugName, SemKey<? super K> ... otherSupers) {
        if (otherSupers == null) {
            SemKey.$$$reportNull$$$0(3);
        }
        if (otherSupers.length == 0) {
            return new SemKey<T>(debugName, this);
        }
        return new SemKey<T>(debugName, ArrayUtil.append(otherSupers, this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/semantic/SemKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/semantic/SemKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "subKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

