/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictsDialog
extends DialogWrapper
implements ConflictsDialogBase {
    private static final int SHOW_CONFLICTS_EXIT_CODE = 4;
    private static final int MAX_CONFLICTS_SHOWN = 20;
    @NonNls
    private static final String EXPAND_LINK = "expand";
    protected final String[] myConflictDescriptions;
    protected MultiMap<PsiElement, String> myElementConflictDescription;
    private final Project myProject;
    private Runnable myDoRefactoringRunnable;
    private final boolean myCanShowConflictsInView;
    private @NlsContexts.Command String myCommandName;

    public ConflictsDialog(@NotNull Project project2, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflictDescriptions) {
        if (project2 == null) {
            ConflictsDialog.$$$reportNull$$$0(0);
        }
        if (conflictDescriptions == null) {
            ConflictsDialog.$$$reportNull$$$0(1);
        }
        this(project2, conflictDescriptions, null, true, true);
    }

    public ConflictsDialog(@NotNull Project project2, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable) {
        if (project2 == null) {
            ConflictsDialog.$$$reportNull$$$0(2);
        }
        if (conflictDescriptions == null) {
            ConflictsDialog.$$$reportNull$$$0(3);
        }
        this(project2, conflictDescriptions, doRefactoringRunnable, true, true);
    }

    public ConflictsDialog(@NotNull Project project2, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable, boolean alwaysShowOkButton, boolean canShowConflictsInView) {
        if (project2 == null) {
            ConflictsDialog.$$$reportNull$$$0(4);
        }
        if (conflictDescriptions == null) {
            ConflictsDialog.$$$reportNull$$$0(5);
        }
        super(project2, true);
        this.myProject = project2;
        this.myDoRefactoringRunnable = doRefactoringRunnable;
        this.myCanShowConflictsInView = canShowConflictsInView;
        LinkedHashSet<String> conflicts = new LinkedHashSet<String>(conflictDescriptions.values());
        this.myConflictDescriptions = ArrayUtilRt.toStringArray(conflicts);
        this.myElementConflictDescription = conflictDescriptions;
        this.setTitle(RefactoringBundle.message((String)"problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message((String)"continue.button"));
        this.setOKActionEnabled(alwaysShowOkButton || this.getDoRefactoringRunnable(null) != null);
        this.init();
    }

    @Deprecated(forRemoval=true)
    public ConflictsDialog(Project project2, String ... conflictDescriptions) {
        super(project2, true);
        this.myProject = project2;
        this.myConflictDescriptions = conflictDescriptions;
        this.myCanShowConflictsInView = true;
        this.setTitle(RefactoringBundle.message((String)"problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message((String)"continue.button"));
        this.init();
    }

    protected Action @NotNull [] createActions() {
        boolean showUsagesButton;
        Action okAction = this.getOKAction();
        boolean bl = showUsagesButton = this.myElementConflictDescription != null && this.myCanShowConflictsInView;
        if (showUsagesButton || !okAction.isEnabled()) {
            okAction.putValue("DefaultAction", null);
        }
        if (!showUsagesButton) {
            Action[] actionArray = new Action[]{okAction, new CancelAction()};
            if (actionArray == null) {
                ConflictsDialog.$$$reportNull$$$0(6);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{okAction, new MyShowConflictsInUsageViewAction(), new CancelAction()};
        if (actionArray == null) {
            ConflictsDialog.$$$reportNull$$$0(7);
        }
        return actionArray;
    }

    public boolean isShowConflicts() {
        return this.getExitCode() == 4;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(0, 2));
        panel2.add((Component)new JLabel(RefactoringBundle.message((String)"the.following.problems.were.found")), "North");
        HtmlBuilder buf = new HtmlBuilder();
        for (int i = 0; i < Math.min(this.myConflictDescriptions.length, 20); ++i) {
            buf.appendRaw(this.myConflictDescriptions[i]).br().br();
        }
        if (this.myConflictDescriptions.length > 20) {
            buf.appendLink(EXPAND_LINK, RefactoringBundle.message((String)"show.more.conflicts.link"));
        }
        JEditorPane messagePane = new JEditorPane();
        messagePane.setEditorKit(HTMLEditorKitBuilder.simple());
        messagePane.setText(buf.toString());
        messagePane.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)messagePane, (int)22, (int)30);
        scrollPane.setPreferredSize(JBUI.size(500, 400));
        messagePane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && EXPAND_LINK.equals(e.getDescription())) {
                messagePane.setText(StringUtil.join(this.myConflictDescriptions, "<br><br>"));
            }
        });
        panel2.add((Component)scrollPane, "Center");
        if (this.getOKAction().isEnabled()) {
            panel2.add((Component)new JLabel(RefactoringBundle.message((String)"do.you.wish.to.ignore.them.and.continue")), "South");
        }
        return panel2;
    }

    public void setCommandName(@NlsContexts.Command String commandName2) {
        this.myCommandName = commandName2;
    }

    protected Runnable getDoRefactoringRunnable(@Nullable UsageView usageView) {
        return this.myDoRefactoringRunnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictDescriptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/ui/ConflictsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/ui/ConflictsDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyShowConflictsInUsageViewAction
    extends AbstractAction {
        MyShowConflictsInUsageViewAction() {
            super(RefactoringBundle.message((String)"action.show.conflicts.in.view.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UsageViewPresentation presentation2 = new UsageViewPresentation();
            String codeUsagesString = RefactoringBundle.message((String)"conflicts.tab.name");
            presentation2.setCodeUsagesString(codeUsagesString);
            presentation2.setTabName(codeUsagesString);
            presentation2.setTabText(codeUsagesString);
            presentation2.setShowCancelButton(true);
            ArrayList<Object> usages = new ArrayList<Object>(ConflictsDialog.this.myElementConflictDescription.values().size());
            for (PsiElement element2 : ConflictsDialog.this.myElementConflictDescription.keySet()) {
                if (element2 == null) {
                    usages.add(new DescriptionOnlyUsage());
                    continue;
                }
                ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector(element2);
                ReadWriteAccessDetector.Access access = detector != null ? detector.getExpressionAccess(element2) : null;
                for (String conflictDescription : ConflictsDialog.this.myElementConflictDescription.get(element2)) {
                    final UsagePresentation usagePresentation = new DescriptionOnlyUsage(conflictDescription).getPresentation();
                    Object usage2 = access != null ? new ReadWriteAccessUsageInfo2UsageAdapter(new UsageInfo(element2), access){

                        @NotNull
                        public UsagePresentation getPresentation() {
                            UsagePresentation usagePresentation2 = usagePresentation;
                            if (usagePresentation2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return usagePresentation2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$1", "getPresentation"));
                        }
                    } : new UsageInfo2UsageAdapter(new UsageInfo(element2)){

                        @NotNull
                        public UsagePresentation getPresentation() {
                            UsagePresentation usagePresentation2 = usagePresentation;
                            if (usagePresentation2 == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return usagePresentation2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$2", "getPresentation"));
                        }
                    };
                    usages.add(usage2);
                }
            }
            UsageView usageView = UsageViewManager.getInstance((Project)ConflictsDialog.this.myProject).showUsages(UsageTarget.EMPTY_ARRAY, usages.toArray(Usage.EMPTY_ARRAY), presentation2);
            Runnable doRefactoringRunnable = ConflictsDialog.this.getDoRefactoringRunnable(usageView);
            if (doRefactoringRunnable != null) {
                usageView.addPerformOperationAction(doRefactoringRunnable, ConflictsDialog.this.myCommandName != null ? ConflictsDialog.this.myCommandName : RefactoringBundle.message((String)"retry.command"), LangBundle.message("conflicts.dialog.message.unable.to.perform.refactoring.changes.in.code.after.usages.have.been.found", new Object[0]), RefactoringBundle.message((String)"usageView.doAction"));
            }
            ConflictsDialog.this.close(4);
        }

        private class DescriptionOnlyUsage
        implements Usage {
            private final @NlsContexts.Tooltip String myConflictDescription;

            DescriptionOnlyUsage(String conflictDescription) {
                if (conflictDescription == null) {
                    DescriptionOnlyUsage.$$$reportNull$$$0(0);
                }
                this.myConflictDescription = StringUtil.unescapeXmlEntities(conflictDescription).replaceAll("<code>", "").replaceAll("</code>", "").replaceAll("<b>", "").replaceAll("</b>", "");
            }

            DescriptionOnlyUsage() {
                this.myConflictDescription = this.getEscapedDescription(StringUtil.join(new LinkedHashSet<String>(ConflictsDialog.this.myElementConflictDescription.get(null)), "\n"));
            }

            @Contract(pure=true)
            private String getEscapedDescription(String conflictsMessage) {
                return Pattern.compile("<[^<>]*>").matcher(conflictsMessage).replaceAll("");
            }

            @NotNull
            public UsagePresentation getPresentation() {
                return new UsagePresentation(){

                    public TextChunk @NotNull [] getText() {
                        TextChunk[] textChunkArray = new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), DescriptionOnlyUsage.this.myConflictDescription)};
                        if (textChunkArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return textChunkArray;
                    }

                    @Nullable
                    public Icon getIcon() {
                        return null;
                    }

                    public String getTooltipText() {
                        return DescriptionOnlyUsage.this.myConflictDescription;
                    }

                    @NotNull
                    public String getPlainText() {
                        String string2 = DescriptionOnlyUsage.this.myConflictDescription;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$DescriptionOnlyUsage$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getText";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getPlainText";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }

            public boolean canNavigateToSource() {
                return false;
            }

            public boolean canNavigate() {
                return false;
            }

            public void navigate(boolean requestFocus) {
            }

            public FileEditorLocation getLocation() {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean isValid() {
                return true;
            }

            public void selectInEditor() {
            }

            public void highlightInEditor() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictDescription", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$DescriptionOnlyUsage", "<init>"));
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            super(RefactoringBundle.message((String)"cancel.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictsDialog.this.doCancelAction();
        }
    }
}

