/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(0);
        }
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element2 == null || !SafeDeleteProcessor.validElement(element2)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{SafeDeleteHandler.getRefactoringName()}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)SafeDeleteHandler.getRefactoringName(), (String)"refactoring.safeDelete");
            return;
        }
        this.invoke(project2, new PsiElement[]{element2}, dataContext);
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project2 == null) {
            SafeDeleteHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            SafeDeleteHandler.$$$reportNull$$$0(2);
        }
        SafeDeleteHandler.invoke(project2, elements, (Module)PlatformCoreDataKeys.MODULE.getData(dataContext), true, null, null);
    }

    public static void invoke(Project project2, PsiElement[] elements, boolean checkDelegates) {
        SafeDeleteHandler.invoke(project2, elements, checkDelegates, null);
    }

    public static void invoke(Project project2, PsiElement[] elements, boolean checkDelegates, @Nullable Runnable successRunnable) {
        SafeDeleteHandler.invoke(project2, elements, null, checkDelegates, successRunnable, null);
    }

    public static void invoke(Project project2, PsiElement[] elements, @Nullable Module module, boolean checkDelegates, @Nullable Runnable successRunnable) {
        SafeDeleteHandler.invoke(project2, elements, module, checkDelegates, successRunnable, null);
    }

    public static void invoke(Project project2, PsiElement[] elements, @Nullable Module module, boolean checkDelegates, @Nullable Runnable successRunnable, @Nullable Runnable afterRefactoring) {
        SafeDeleteHandler.invoke(project2, elements, module, checkDelegates, successRunnable, afterRefactoring, false);
    }

    public static void invoke(final Project project2, PsiElement[] elements, @Nullable Module module, boolean checkDelegates, final @Nullable Runnable successRunnable, final @Nullable Runnable afterRefactoring, boolean silent) {
        for (PsiElement psiElement : elements) {
            if (SafeDeleteProcessor.validElement(psiElement)) continue;
            return;
        }
        PsiElement[] temptoDelete = PsiTreeUtil.filterAncestors(elements);
        Set<PsiElement> elementsSet = ContainerUtil.set(temptoDelete);
        LinkedHashSet<? extends PsiElement> fullElementsSet = new LinkedHashSet<PsiElement>();
        if (checkDelegates) {
            for (PsiElement element3 : temptoDelete) {
                boolean found2 = false;
                for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                    Collection<? extends PsiElement> addElements;
                    if (!delegate2.handlesElement(element3)) continue;
                    found2 = true;
                    Collection<? extends PsiElement> collection = addElements = delegate2 instanceof SafeDeleteProcessorDelegateBase ? ((SafeDeleteProcessorDelegateBase)delegate2).getElementsToSearch(element3, module, elementsSet) : delegate2.getElementsToSearch(element3, elementsSet);
                    if (addElements == null) {
                        return;
                    }
                    fullElementsSet.addAll(addElements);
                    break;
                }
                if (found2) continue;
                fullElementsSet.add(element3);
            }
        } else {
            ContainerUtil.addAll(fullElementsSet, temptoDelete);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, fullElementsSet, (boolean)true)) {
            return;
        }
        final PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(fullElementsSet);
        if (ApplicationManager.getApplication().isUnitTestMode() || silent) {
            RefactoringSettings settings = RefactoringSettings.getInstance();
            SafeDeleteProcessor processor = SafeDeleteProcessor.createInstance(project2, null, psiElementArray, settings.SAFE_DELETE_SEARCH_IN_COMMENTS, settings.SAFE_DELETE_SEARCH_IN_NON_JAVA, true);
            if (afterRefactoring != null) {
                processor.setAfterRefactoringCallback(afterRefactoring);
            }
            processor.run();
            if (successRunnable != null) {
                successRunnable.run();
            }
        } else {
            SafeDeleteDialog.Callback callback = new SafeDeleteDialog.Callback(){

                @Override
                public void run(SafeDeleteDialog dialog) {
                    SafeDeleteProcessor processor = SafeDeleteProcessor.createInstance(project2, () -> {
                        if (successRunnable != null) {
                            successRunnable.run();
                        }
                        dialog.close(1);
                    }, psiElementArray, dialog.isSearchInComments(), dialog.isSearchForTextOccurences(), true);
                    if (afterRefactoring != null) {
                        processor.setAfterRefactoringCallback(afterRefactoring);
                    }
                    processor.run();
                }
            };
            SafeDeleteDialog dialog = new SafeDeleteDialog(project2, psiElementArray, callback);
            dialog.show();
        }
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"safe.delete.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/safeDelete/SafeDeleteHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

