/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.template.TemplateResultListener;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.api.PsiRenameUsage;
import com.intellij.refactoring.rename.inplace.UtilKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u0015H\u0000\u00a8\u0006\u0017"}, d2={"deleteInplaceTemplateSegments", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "templateSegmentRanges", "", "Lcom/intellij/openapi/util/TextRange;", "injectedToHost", "injectedFile", "Lcom/intellij/psi/PsiFile;", "injectedRange", "usageRangeInHost", "hostFile", "usage", "Lcom/intellij/refactoring/rename/api/PsiRenameUsage;", "addTemplateResultListener", "", "Lcom/intellij/codeInsight/template/impl/TemplateState;", "resultConsumer", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/template/TemplateResultListener$TemplateResult;", "intellij.platform.lang.impl"})
public final class UtilKt {
    @Nullable
    public static final TextRange usageRangeInHost(@NotNull PsiFile hostFile, @NotNull PsiRenameUsage usage2) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)usage2, (String)"usage");
        if (Intrinsics.areEqual((Object)usage2.getFile(), (Object)hostFile)) {
            textRange = usage2.getRange();
        } else {
            Project project2 = hostFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"hostFile.project");
            textRange = UtilKt.injectedToHost(project2, usage2.getFile(), usage2.getRange());
        }
        return textRange;
    }

    private static final TextRange injectedToHost(Project project2, PsiFile injectedFile, TextRange injectedRange) {
        Document document = PsiDocumentManager.getInstance(project2).getDocument(injectedFile);
        if (!(document instanceof DocumentWindow)) {
            document = null;
        }
        DocumentWindow documentWindow = (DocumentWindow)document;
        if (documentWindow == null) {
            return null;
        }
        DocumentWindow injectedDocument = documentWindow;
        TextRange textRange = injectedDocument.getHostRange(injectedDocument.injectedToHost(injectedRange.getStartOffset()));
        if (textRange == null) {
            return null;
        }
        TextRange startOffsetHostRange = textRange;
        TextRange textRange2 = injectedDocument.getHostRange(injectedDocument.injectedToHost(injectedRange.getEndOffset()));
        if (textRange2 == null) {
            return null;
        }
        TextRange endOffsetHostRange = textRange2;
        return Intrinsics.areEqual((Object)startOffsetHostRange, (Object)endOffsetHostRange) ? injectedDocument.injectedToHost(injectedRange) : null;
    }

    public static final void addTemplateResultListener(@NotNull TemplateState $this$addTemplateResultListener, @NotNull Function1<? super TemplateResultListener.TemplateResult, Unit> resultConsumer) {
        Intrinsics.checkNotNullParameter((Object)$this$addTemplateResultListener, (String)"$this$addTemplateResultListener");
        Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
        $this$addTemplateResultListener.addTemplateStateListener(new TemplateResultListener(resultConsumer));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Runnable deleteInplaceTemplateSegments(@NotNull Project project2, @NotNull Document document, @NotNull List<? extends TextRange> templateSegmentRanges) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(templateSegmentRanges, (String)"templateSegmentRanges");
        String string2 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String hostDocumentContent = string2;
        Iterable $this$map$iv = templateSegmentRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String content2;
            RangeMarker marker;
            void range;
            RangeMarker rangeMarker;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RangeMarker it = rangeMarker = document.createRangeMarker((TextRange)range);
            boolean bl2 = false;
            RangeMarker rangeMarker2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"it");
            rangeMarker2.setGreedyToRight(true);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMark\u2026reedyToRight = true\n    }");
            Intrinsics.checkNotNullExpressionValue((Object)range.substring(hostDocumentContent), (String)"range.substring(hostDocumentContent)");
            Pair pair = new Pair((Object)marker, (Object)content2);
            collection.add(pair);
        }
        List stateBefore = (List)destination$iv$iv;
        DocumentUtil.executeInBulk(document, new Runnable(templateSegmentRanges, document){
            final /* synthetic */ List $templateSegmentRanges;
            final /* synthetic */ Document $document;

            public final void run() {
                for (TextRange range : CollectionsKt.asReversed((List)this.$templateSegmentRanges)) {
                    this.$document.deleteString(range.getStartOffset(), range.getEndOffset());
                }
            }
            {
                this.$templateSegmentRanges = list2;
                this.$document = document;
            }
        });
        return new Runnable(project2, document, stateBefore){
            final /* synthetic */ Project $project;
            final /* synthetic */ Document $document;
            final /* synthetic */ List $stateBefore;

            public final void run() {
                WriteCommandAction.writeCommandAction(this.$project).run(new ThrowableRunnable(this){
                    final /* synthetic */ deleteInplaceTemplateSegments.2 this$0;

                    public final void run() {
                        DocumentUtil.executeInBulk(this.this$0.$document, new Runnable(this){
                            final /* synthetic */ deleteInplaceTemplateSegments.1 this$0;

                            /*
                             * WARNING - void declaration
                             */
                            public final void run() {
                                for (Pair pair : this.this$0.this$0.$stateBefore) {
                                    void marker;
                                    RangeMarker rangeMarker = (RangeMarker)pair.component1();
                                    String content2 = (String)pair.component2();
                                    this.this$0.this$0.$document.replaceString(marker.getStartOffset(), marker.getEndOffset(), content2);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        PsiDocumentManager.getInstance(this.this$0.$project).commitDocument(this.this$0.$document);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project2;
                this.$document = document;
                this.$stateBefore = list2;
            }
        };
    }
}

