/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.api.ReplaceTextTargetContext;
import com.intellij.refactoring.rename.impl.RenameOptions;
import com.intellij.refactoring.rename.impl.TextOptions;
import com.intellij.refactoring.rename.impl.TextOptionsService;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0011"}, d2={"emptyTextOptions", "Lcom/intellij/refactoring/rename/impl/TextOptions;", "isEmpty", "", "(Lcom/intellij/refactoring/rename/impl/TextOptions;)Z", "getTextOptions", "target", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "renameOptions", "Lcom/intellij/refactoring/rename/impl/RenameOptions;", "project", "Lcom/intellij/openapi/project/Project;", "setTextOptions", "", "textOptions", "textOptionsService", "Lcom/intellij/refactoring/rename/impl/TextOptionsService;", "intellij.platform.lang.impl"})
public final class OptionsKt {
    private static final TextOptions emptyTextOptions = new TextOptions(null, null);

    public static final boolean isEmpty(@NotNull TextOptions $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"$this$isEmpty");
        return Intrinsics.areEqual((Object)$this$isEmpty, (Object)emptyTextOptions);
    }

    @NotNull
    public static final RenameOptions renameOptions(@NotNull Project project2, @NotNull RenameTarget target2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        TextOptions textOptions = OptionsKt.getTextOptions(target2);
        SearchScope searchScope2 = target2.getMaximalSearchScope();
        if (searchScope2 == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
            searchScope2 = globalSearchScope;
        }
        return new RenameOptions(textOptions, searchScope2);
    }

    @NotNull
    public static final TextOptions getTextOptions(@NotNull RenameTarget target2) {
        Object object;
        Object object2;
        boolean canRenameTextOccurrences;
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        boolean canRenameCommentAndStringOccurrences = !target2.textTargets(ReplaceTextTargetContext.IN_COMMENTS_AND_STRINGS).isEmpty();
        boolean bl = canRenameTextOccurrences = !target2.textTargets(ReplaceTextTargetContext.IN_PLAIN_TEXT).isEmpty();
        if (!canRenameCommentAndStringOccurrences && !canRenameTextOccurrences) {
            return emptyTextOptions;
        }
        TextOptions textOptions = OptionsKt.textOptionsService().getOptions().get(target2.getClass().getName());
        return new TextOptions(!canRenameCommentAndStringOccurrences ? null : Boolean.valueOf((object2 = textOptions) != null && (object2 = ((TextOptions)object2).getCommentStringOccurrences()) != null ? (Boolean)object2 : true), !canRenameTextOccurrences ? null : Boolean.valueOf((object = textOptions) != null && (object = ((TextOptions)object).getTextOccurrences()) != null ? (Boolean)object : true));
    }

    public static final void setTextOptions(@NotNull RenameTarget target2, @NotNull TextOptions textOptions) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)textOptions, (String)"textOptions");
        Map<String, TextOptions> options = OptionsKt.textOptionsService().getOptions();
        if (OptionsKt.isEmpty(textOptions)) {
            options.remove(target2.getClass().getName());
        } else {
            String string2 = target2.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"target.javaClass.name");
            options.put(string2, textOptions);
        }
    }

    private static final TextOptionsService textOptionsService() {
        boolean $i$f$service = false;
        Class<TextOptionsService> serviceClass$iv = TextOptionsService.class;
        TextOptionsService textOptionsService = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (textOptionsService == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return textOptionsService;
    }
}

