/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.LangBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.model.BranchableSyntheticPsiElement;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameScopeType;
import com.intellij.refactoring.rename.RenameUsagesCollector;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RelatedUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(RenameProcessor.class);
    protected final LinkedHashMap<PsiElement, String> myAllRenames;
    @NotNull
    private PsiElement myPrimaryElement;
    private String myNewName;
    private boolean mySearchInComments;
    private boolean mySearchTextOccurrences;
    protected boolean myForceShowPreview;
    private @NlsContexts.Command String myCommandName;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final List<AutomaticRenamerFactory> myRenamerFactories;
    private final List<AutomaticRenamer> myRenamers;
    private final List<UnresolvableCollisionUsageInfo> mySkippedUsages;

    public RenameProcessor(@NotNull Project project2, @NotNull PsiElement element2, @NotNull String newName2, boolean isSearchInComments, boolean isSearchTextOccurrences) {
        if (project2 == null) {
            RenameProcessor.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            RenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName2 == null) {
            RenameProcessor.$$$reportNull$$$0(2);
        }
        this(project2, element2, newName2, GlobalSearchScope.projectScope(project2), isSearchInComments, isSearchTextOccurrences);
    }

    public RenameProcessor(@NotNull Project project2, @NotNull PsiElement element2, @NotNull String newName2, @NotNull SearchScope refactoringScope, boolean isSearchInComments, boolean isSearchTextOccurrences) {
        if (project2 == null) {
            RenameProcessor.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            RenameProcessor.$$$reportNull$$$0(4);
        }
        if (newName2 == null) {
            RenameProcessor.$$$reportNull$$$0(5);
        }
        if (refactoringScope == null) {
            RenameProcessor.$$$reportNull$$$0(6);
        }
        super(project2, refactoringScope, null);
        this.myAllRenames = new LinkedHashMap();
        this.myNewName = null;
        this.myNonCodeUsages = new NonCodeUsageInfo[0];
        this.myRenamerFactories = new ArrayList<AutomaticRenamerFactory>();
        this.myRenamers = new ArrayList<AutomaticRenamer>();
        this.mySkippedUsages = new ArrayList<UnresolvableCollisionUsageInfo>();
        this.myPrimaryElement = element2;
        RenameUtil.assertNonCompileElement((PsiElement)element2);
        this.mySearchInComments = isSearchInComments;
        this.mySearchTextOccurrences = isSearchTextOccurrences;
        this.setNewName(newName2);
        this.logScopeStatistics(RenameUsagesCollector.started);
    }

    public Set<PsiElement> getElements() {
        return Collections.unmodifiableSet(this.myAllRenames.keySet());
    }

    public String getNewName(PsiElement element2) {
        return this.myAllRenames.get(element2);
    }

    public void addRenamerFactory(AutomaticRenamerFactory factory2) {
        if (!this.myRenamerFactories.contains(factory2)) {
            this.myRenamerFactories.add(factory2);
        }
    }

    public void removeRenamerFactory(AutomaticRenamerFactory factory2) {
        this.myRenamerFactories.remove(factory2);
    }

    public void doRun() {
        if (!this.myPrimaryElement.isValid()) {
            return;
        }
        this.prepareRenaming(this.myPrimaryElement, this.myNewName, this.myAllRenames);
        super.doRun();
    }

    public void prepareRenaming(@NotNull PsiElement element2, String newName2, LinkedHashMap<PsiElement, String> allRenames) {
        if (element2 == null) {
            RenameProcessor.$$$reportNull$$$0(7);
        }
        List<RenamePsiElementProcessor> processors = RenamePsiElementProcessor.allForElement(element2);
        this.myForceShowPreview = false;
        for (RenamePsiElementProcessor processor : processors) {
            processor.prepareRenaming(element2, newName2, allRenames);
            this.myForceShowPreview |= processor.forcesShowPreview();
        }
    }

    @Nullable
    private String getHelpID() {
        return RenamePsiElementProcessor.forElement(this.myPrimaryElement).getHelpID(this.myPrimaryElement);
    }

    public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        int[] nArray;
        if (refUsages == null) {
            RenameProcessor.$$$reportNull$$$0(8);
        }
        UsageInfo[] usagesIn = refUsages.get();
        MultiMap conflicts = new MultiMap();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, conflicts);
        RenamePsiElementProcessor.forElement(this.myPrimaryElement).findExistingNameConflicts(this.myPrimaryElement, this.myNewName, conflicts, this.myAllRenames);
        if (!conflicts.isEmpty()) {
            RefactoringEventData conflictData = new RefactoringEventData();
            conflictData.putUserData(RefactoringEventData.CONFLICTS_KEY, conflicts.values());
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected("refactoring.rename", conflictData);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                    throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
                }
                return true;
            }
            ConflictsDialogBase conflictsDialog = this.prepareConflictsDialog(conflicts, refUsages.get());
            if (!conflictsDialog.showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        ArrayList<UsageInfo> variableUsages = new ArrayList<UsageInfo>();
        if (!this.myRenamers.isEmpty()) {
            if (!this.findRenamedVariables(variableUsages)) {
                return false;
            }
            LinkedHashMap<PsiElement, String> renames = new LinkedHashMap<PsiElement, String>();
            for (AutomaticRenamer renamer : this.myRenamers) {
                List variables = renamer.getElements();
                for (PsiNamedElement variable : variables) {
                    String newName2 = renamer.getNewName(variable);
                    if (newName2 == null) continue;
                    this.addElement(variable, newName2);
                    this.prepareRenaming(variable, newName2, renames);
                }
            }
            if (!renames.isEmpty()) {
                for (PsiElement element2 : renames.keySet()) {
                    RenameUtil.assertNonCompileElement((PsiElement)element2);
                }
                this.myAllRenames.putAll(renames);
                Runnable runnable = () -> {
                    for (Map.Entry entry : renames.entrySet()) {
                        UsageInfo[] usages = ReadAction.compute(() -> RenameUtil.findUsages((PsiElement)((PsiElement)entry.getKey()), (String)((String)entry.getValue()), (SearchScope)this.myRefactoringScope, (boolean)this.mySearchInComments, (boolean)this.mySearchTextOccurrences, this.myAllRenames));
                        Collections.addAll(variableUsages, usages);
                    }
                };
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) {
                    return false;
                }
            }
        }
        if (this.myAllRenames.size() > 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = null;
        }
        int[] choice = nArray;
        try {
            Iterator<Map.Entry<PsiElement, String>> iterator = this.myAllRenames.entrySet().iterator();
            while (iterator.hasNext()) {
                PsiFile file2;
                PsiDirectory containingDirectory;
                Map.Entry<PsiElement, String> entry = iterator.next();
                if (entry.getKey() instanceof PsiFile && CopyFilesOrDirectoriesHandler.checkFileExist(containingDirectory = (file2 = (PsiFile)entry.getKey()).getContainingDirectory(), choice, file2, entry.getValue(), RefactoringBundle.message((String)"command.name.rename"))) {
                    iterator.remove();
                    continue;
                }
                RenameUtil.checkRename((PsiElement)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"rename.title"), (String)e.getMessage(), (String)this.getHelpID(), (Project)this.myProject);
            return false;
        }
        LinkedHashSet<UsageInfo> usagesSet = ContainerUtil.newLinkedHashSet(usagesIn);
        usagesSet.addAll(variableUsages);
        List conflictUsages = RenameUtil.removeConflictUsages(usagesSet);
        if (conflictUsages != null) {
            this.mySkippedUsages.addAll(conflictUsages);
        }
        refUsages.set(usagesSet.toArray(UsageInfo.EMPTY_ARRAY));
        this.prepareSuccessful();
        return PsiElementRenameHandler.canRename((Project)this.myProject, null, (PsiElement)this.myPrimaryElement);
    }

    private boolean findRenamedVariables(List<UsageInfo> variableUsages) {
        Iterator<AutomaticRenamer> iterator = this.myRenamers.iterator();
        while (iterator.hasNext()) {
            AutomaticRenamer automaticVariableRenamer = iterator.next();
            if (!automaticVariableRenamer.hasAnythingToRename() || this.showAutomaticRenamingDialog(automaticVariableRenamer)) continue;
            iterator.remove();
        }
        Runnable runnable = () -> ApplicationManager.getApplication().runReadAction(() -> {
            for (AutomaticRenamer renamer : this.myRenamers) {
                renamer.findUsages(variableUsages, this.mySearchInComments, this.mySearchTextOccurrences, this.mySkippedUsages, this.myAllRenames);
            }
        });
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject);
    }

    protected boolean showAutomaticRenamingDialog(AutomaticRenamer automaticVariableRenamer) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiNamedElement element2 : automaticVariableRenamer.getElements()) {
                automaticVariableRenamer.setRename(element2, automaticVariableRenamer.getNewName(element2));
            }
            return true;
        }
        AutomaticRenamingDialog dialog = new AutomaticRenamingDialog(this.myProject, automaticVariableRenamer);
        return dialog.showAndGet();
    }

    public void addElement(@NotNull PsiElement element2, @NotNull String newName2) {
        if (element2 == null) {
            RenameProcessor.$$$reportNull$$$0(9);
        }
        if (newName2 == null) {
            RenameProcessor.$$$reportNull$$$0(10);
        }
        RenameUtil.assertNonCompileElement((PsiElement)element2);
        this.myAllRenames.put(element2, newName2);
    }

    private void setNewName(@NotNull String newName2) {
        if (newName2 == null) {
            RenameProcessor.$$$reportNull$$$0(11);
        }
        this.myNewName = newName2;
        this.myAllRenames.put(this.myPrimaryElement, newName2);
        this.myCommandName = RefactoringBundle.message((String)"renaming.0.1.to.2", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)this.myPrimaryElement), DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPrimaryElement), newName2});
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(12);
        }
        return new RenameViewDescriptor(this.myAllRenames);
    }

    public UsageInfo @NotNull [] findUsages() {
        this.myRenamers.clear();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (PsiElement element2 : new ArrayList<PsiElement>(this.myAllRenames.keySet())) {
            if (element2 == null) {
                LOG.error("primary: " + this.myPrimaryElement + "; renamers: " + this.myRenamers);
                continue;
            }
            String newName2 = this.myAllRenames.get(element2);
            UsageInfo[] usages = RenameUtil.findUsages((PsiElement)element2, (String)newName2, (SearchScope)this.myRefactoringScope, (boolean)this.mySearchInComments, (boolean)this.mySearchTextOccurrences, this.myAllRenames);
            List<UsageInfo> usagesList = Arrays.asList(usages);
            result2.addAll(usagesList);
            for (AutomaticRenamerFactory factory2 : this.myRenamerFactories) {
                if (!factory2.isApplicable(element2)) continue;
                this.myRenamers.add(factory2.createRenamer(element2, newName2, usagesList));
            }
            for (AutomaticRenamerFactory factory2 : AutomaticRenamerFactory.EP_NAME.getExtensionList()) {
                if (factory2.getOptionName() != null || !factory2.isApplicable(element2)) continue;
                this.myRenamers.add(factory2.createRenamer(element2, newName2, usagesList));
            }
        }
        UsageInfo[] usageInfos = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if ((usageInfos = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos)) == null) {
            RenameProcessor.$$$reportNull$$$0(13);
        }
        return usageInfos;
    }

    public boolean hasNonCodeUsages() {
        for (PsiElement element2 : new ArrayList<PsiElement>(this.myAllRenames.keySet())) {
            String newName2;
            if (!RenameUtil.hasNonCodeUsages((PsiElement)element2, (String)(newName2 = this.myAllRenames.get(element2)), (SearchScope)this.myRefactoringScope, (boolean)this.mySearchInComments, (boolean)this.mySearchTextOccurrences)) continue;
            return true;
        }
        return false;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            RenameProcessor.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(elements.length > 0);
        this.myPrimaryElement = elements[0];
        Iterator<String> newNames = this.myAllRenames.values().iterator();
        LinkedHashMap<PsiElement, String> newAllRenames = new LinkedHashMap<PsiElement, String>();
        for (PsiElement resolved : elements) {
            newAllRenames.put(resolved, newNames.next());
        }
        this.myAllRenames.clear();
        this.myAllRenames.putAll(newAllRenames);
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(15);
        }
        return this.myForceShowPreview || super.isPreviewUsages(usages) || UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)this.myProject);
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.rename";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.myPrimaryElement);
        return data2;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(16);
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.myPrimaryElement);
        return data2;
    }

    public void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(17);
        }
        this.doPerformRefactoring(usages, null);
    }

    protected boolean canPerformRefactoringInBranch() {
        return true;
    }

    protected void performRefactoringInBranch(UsageInfo @NotNull [] usages, @NotNull ModelBranch branch) {
        if (branch == null) {
            RenameProcessor.$$$reportNull$$$0(18);
        }
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(19);
        }
        Class<?> syncDefinition = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), "performRefactoring", UsageInfo[].class);
        Class<?> asyncDefinition = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), "performRefactoringInBranch", UsageInfo[].class, ModelBranch.class);
        if (asyncDefinition != RenameProcessor.class && syncDefinition != asyncDefinition) {
            throw new UnsupportedOperationException("performRefactoringInBranch should be implemented in " + syncDefinition);
        }
        this.doPerformRefactoring(usages, branch);
    }

    private void doPerformRefactoring(UsageInfo @NotNull [] usages, final @Nullable ModelBranch branch) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(20);
        }
        this.logScopeStatistics(RenameUsagesCollector.executed);
        ArrayList<Runnable> postRenameCallbacks = new ArrayList<Runnable>();
        IdentityHashMap<PsiElement, PsiElement> elementsToChange = new IdentityHashMap<PsiElement, PsiElement>();
        for (PsiElement element2 : this.myAllRenames.keySet()) {
            elementsToChange.put(element2, branch != null ? branch.obtainPsiCopy(element2) : element2);
        }
        final MultiMap renameEvents = MultiMap.createLinked();
        List<UsageInfo> branchedUsages = branch == null ? Arrays.asList(usages) : ContainerUtil.mapNotNull(usages, info -> RenameProcessor.shouldSkip(info) ? null : ((MoveRenameUsageInfo)info).obtainBranchCopy(branch));
        MultiMap<PsiElement, UsageInfo> classified = RenameProcessor.classifyUsages(elementsToChange.values(), branchedUsages);
        NonCodeUsageInfo[] nonCodeUsages = ContainerUtil.filterIsInstance(branchedUsages, NonCodeUsageInfo.class).toArray(new NonCodeUsageInfo[0]);
        for (PsiElement element3 : this.myAllRenames.keySet()) {
            PsiElement toChange = (PsiElement)elementsToChange.get(element3);
            if (!element3.isValid()) {
                LOG.error(new PsiInvalidElementAccessException(element3));
                continue;
            }
            if (!toChange.isValid()) {
                LOG.error(new PsiInvalidElementAccessException(toChange));
                continue;
            }
            String newName2 = this.myAllRenames.get(element3);
            final RefactoringElementListener elementListener = this.getTransaction().getElementListener(element3);
            RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement(element3);
            Runnable postRenameCallback = renamePsiElementProcessor.getPostRenameCallback(element3, newName2, elementListener);
            Collection<UsageInfo> infos = classified.get(toChange);
            try {
                RenameProcessor.nowOrAfterMerge(branch, () -> RenameUtil.registerUndoableRename((PsiElement)element3, (RefactoringElementListener)elementListener));
                renamePsiElementProcessor.renameElement(toChange, newName2, infos.toArray(UsageInfo.EMPTY_ARRAY), new RefactoringElementListener(){

                    @Override
                    public void elementMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void elementRenamed(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (!newElement.isValid()) {
                            return;
                        }
                        if (branch != null) assert (branch == ModelBranch.getPsiBranch(newElement));
                        renameEvents.putValue(elementListener, SmartPointerManager.createPointer(newElement));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "newElement";
                        objectArray2[1] = "com/intellij/refactoring/rename/RenameProcessor$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementMoved";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage((IncorrectOperationException)e, (PsiElement)element3, (Project)this.myProject);
                return;
            }
            if (postRenameCallback == null) continue;
            postRenameCallbacks.add(postRenameCallback);
        }
        if (branch != null) {
            RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])nonCodeUsages);
        } else {
            this.myNonCodeUsages = nonCodeUsages;
        }
        RenameProcessor.nowOrAfterMerge(branch, () -> this.afterRename(postRenameCallbacks, renameEvents, branch));
    }

    private static void nowOrAfterMerge(@Nullable ModelBranch branch, Runnable runnable) {
        if (branch == null) {
            runnable.run();
        } else {
            branch.runAfterMerge(runnable);
        }
    }

    private void afterRename(List<Runnable> postRenameCallbacks, MultiMap<RefactoringElementListener, SmartPsiElementPointer<PsiElement>> renameEvents, @Nullable ModelBranch branch) {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        for (Map.Entry<RefactoringElementListener, Collection<SmartPsiElementPointer<PsiElement>>> entry : renameEvents.entrySet()) {
            for (SmartPsiElementPointer<PsiElement> pointer : entry.getValue()) {
                PsiElement element2 = pointer.getElement();
                if (element2 instanceof BranchableSyntheticPsiElement) continue;
                if (branch != null && element2 != null) {
                    element2 = branch.findOriginalPsi(element2);
                }
                if (element2 == null) continue;
                entry.getKey().elementRenamed(element2);
            }
        }
        for (Runnable runnable : postRenameCallbacks) {
            runnable.run();
        }
        if (!(this.mySkippedUsages.isEmpty() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
                if (ideFrame != null) {
                    StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                    String message2 = LangBundle.message("popup.content.unable.to.rename.certain.usages", new Object[0]);
                    HyperlinkListener listener2 = e -> {
                        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                            return;
                        }
                        String skipped = StringUtil.join(this.mySkippedUsages, unresolvableCollisionUsageInfo -> unresolvableCollisionUsageInfo.getDescription(), "<br>");
                        Messages.showMessageDialog((String)RefactoringBundle.message((String)"rename.not.all.usages.message", (Object[])new Object[]{skipped}), (String)RefactoringBundle.message((String)"rename.not.all.usages.title"), null);
                    };
                    statusBar.notifyProgressByBalloon(MessageType.WARNING, message2, null, listener2);
                }
            }, ModalityState.NON_MODAL);
        }
    }

    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])this.myNonCodeUsages);
    }

    @NotNull
    protected String getCommandName() {
        String string2 = this.myCommandName;
        if (string2 == null) {
            RenameProcessor.$$$reportNull$$$0(21);
        }
        return string2;
    }

    public static MultiMap<PsiElement, UsageInfo> classifyUsages(Collection<? extends PsiElement> elements, Collection<UsageInfo> usages) {
        MultiMap<PsiElement, UsageInfo> result2 = new MultiMap<PsiElement, UsageInfo>();
        for (UsageInfo usage2 : usages) {
            PsiElement indirect;
            LOG.assertTrue(usage2 instanceof MoveRenameUsageInfo);
            if (RenameProcessor.shouldSkip(usage2)) continue;
            MoveRenameUsageInfo usageInfo = (MoveRenameUsageInfo)usage2;
            if (usage2 instanceof RelatedUsageInfo) {
                PsiElement relatedElement = ((RelatedUsageInfo)usage2).getRelatedElement();
                if (!elements.contains(relatedElement)) continue;
                result2.putValue(relatedElement, usage2);
                continue;
            }
            PsiElement referenced = usageInfo.getReferencedElement();
            if (elements.contains(referenced)) {
                result2.putValue(referenced, usage2);
                continue;
            }
            if (referenced == null || !elements.contains(indirect = referenced.getNavigationElement())) continue;
            result2.putValue(indirect, usage2);
        }
        return result2;
    }

    private static boolean shouldSkip(UsageInfo usage2) {
        return usage2.getReference() instanceof LightElement;
    }

    public Collection<String> getNewNames() {
        return this.myAllRenames.values();
    }

    public void setSearchInComments(boolean value) {
        this.mySearchInComments = value;
    }

    public void setSearchTextOccurrences(boolean searchTextOccurrences) {
        this.mySearchTextOccurrences = searchTextOccurrences;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchTextOccurrences() {
        return this.mySearchTextOccurrences;
    }

    public void setCommandName(@NlsContexts.Command String commandName2) {
        this.myCommandName = commandName2;
    }

    private void logScopeStatistics(VarargEventId eventId) {
        Class<?> renameProcessor = ((Object)((Object)RenamePsiElementProcessor.forElement(this.myPrimaryElement))).getClass();
        eventId.log(this.myProject, new EventPair[]{RenameUsagesCollector.scopeType.with((Object)this.getStatisticsCompatibleScopeName()), RenameUsagesCollector.searchInComments.with((Object)this.isSearchInComments()), RenameUsagesCollector.searchInTextOccurrences.with((Object)this.isSearchTextOccurrences()), RenameUsagesCollector.renameProcessor.with(renameProcessor), EventFields.Language.with((Object)this.myPrimaryElement.getLanguage())});
    }

    private RenameScopeType getStatisticsCompatibleScopeName() {
        String displayName = this.myRefactoringScope.getDisplayName();
        if (displayName.equals(ProjectScope.getProjectFilesScopeName())) {
            return RenameScopeType.Project;
        }
        if (displayName.equals(GlobalSearchScopesCore.getProjectTestFilesScopeName())) {
            return RenameScopeType.Tests;
        }
        if (displayName.equals(GlobalSearchScopesCore.getProjectProductionFilesScopeName())) {
            return RenameScopeType.Production;
        }
        if (this.myRefactoringScope instanceof LocalSearchScope) {
            return RenameScopeType.CurrentFile;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(this.myPrimaryElement);
        if (module != null && this.myRefactoringScope.equals(module.getModuleScope())) {
            return RenameScopeType.Module;
        }
        if (!PluginInfoDetectorKt.getPluginInfo(this.myRefactoringScope.getClass()).isSafeToReport()) {
            return RenameScopeType.ThirdParty;
        }
        return RenameScopeType.Unknown;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setNewName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 13: 
            case 21: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoringInBranch";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doPerformRefactoring";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

