/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RenameHandlerRegistry {
    public static final Key<Boolean> SELECT_ALL = Key.create("rename.selectAll");
    private final PsiElementRenameHandler myDefaultElementRenameHandler;
    private Function<? super Collection<? extends RenameHandler>, ? extends RenameHandler> myRenameHandlerSelectorInTests = ContainerUtil::getFirstItem;

    public static RenameHandlerRegistry getInstance() {
        return ApplicationManager.getApplication().getService(RenameHandlerRegistry.class);
    }

    protected RenameHandlerRegistry() {
        this.myDefaultElementRenameHandler = new PsiElementRenameHandler();
    }

    public boolean hasAvailableHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameHandlerRegistry.$$$reportNull$$$0(0);
        }
        for (RenameHandler renameHandler : RenameHandler.EP_NAME.getExtensionList()) {
            if (!renameHandler.isAvailableOnDataContext(dataContext)) continue;
            return true;
        }
        return this.myDefaultElementRenameHandler.isAvailableOnDataContext(dataContext);
    }

    @Nullable
    public RenameHandler getRenameHandler(@NotNull DataContext dataContext) {
        List<? extends RenameHandler> availableHandlers;
        if (dataContext == null) {
            RenameHandlerRegistry.$$$reportNull$$$0(1);
        }
        if ((availableHandlers = this.getRenameHandlers(dataContext)).isEmpty()) {
            return null;
        }
        if (availableHandlers.size() == 1) {
            return availableHandlers.get(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myRenameHandlerSelectorInTests.apply(availableHandlers);
        }
        Map<String, List<RenameHandler>> title2Handlers = availableHandlers.stream().collect(Collectors.groupingBy(it -> RenameHandlerRegistry.getHandlerTitle(it)));
        String[] strings2 = ArrayUtilRt.toStringArray(title2Handlers.keySet());
        HandlersChooser chooser2 = new HandlersChooser((Project)CommonDataKeys.PROJECT.getData(dataContext), strings2);
        if (chooser2.showAndGet()) {
            return ContainerUtil.getLastItem(title2Handlers.get(chooser2.getSelection()));
        }
        throw new ProcessCanceledException();
    }

    @NotNull
    public @NotNull List<? extends @NotNull RenameHandler> getRenameHandlers(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameHandlerRegistry.$$$reportNull$$$0(2);
        }
        AccessToken ignore = ProhibitAWTEvents.start((String)"getRenameHandlers");
        List<? extends RenameHandler> list2 = this.doGetRenameHandlers(dataContext);
        List<? extends RenameHandler> list3 = list2;
        if (list3 == null) {
            RenameHandlerRegistry.$$$reportNull$$$0(3);
        }
        return list3;
        finally {
            if (ignore != null) {
                ignore.close();
            }
        }
    }

    @NotNull
    private @NotNull List<? extends @NotNull RenameHandler> doGetRenameHandlers(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameHandlerRegistry.$$$reportNull$$$0(4);
        }
        TreeMap<String, RenameHandler> availableHandlers = new TreeMap<String, RenameHandler>();
        for (RenameHandler renameHandler : RenameHandler.EP_NAME.getExtensionList()) {
            if (!renameHandler.isRenaming(dataContext)) continue;
            availableHandlers.put(RenameHandlerRegistry.getHandlerTitle(renameHandler), renameHandler);
        }
        if (availableHandlers.size() == 1) {
            return new SmartList(availableHandlers.values());
        }
        Iterator iterator = availableHandlers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof MemberInplaceRenameHandler)) continue;
            iterator.remove();
            break;
        }
        if (availableHandlers.isEmpty() && this.myDefaultElementRenameHandler.isRenaming(dataContext)) {
            List<PsiElementRenameHandler> list2 = Collections.singletonList(this.myDefaultElementRenameHandler);
            if (list2 == null) {
                RenameHandlerRegistry.$$$reportNull$$$0(5);
            }
            return list2;
        }
        return new SmartList(availableHandlers.values());
    }

    @TestOnly
    public void setRenameHandlerSelectorInTests(Function<? super Collection<? extends RenameHandler>, ? extends RenameHandler> selector, Disposable parentDisposable) {
        this.myRenameHandlerSelectorInTests = selector;
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                RenameHandlerRegistry.this.myRenameHandlerSelectorInTests = ContainerUtil::getFirstItem;
            }
        });
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static String getHandlerTitle(RenameHandler renameHandler) {
        if (renameHandler instanceof TitledHandler) {
            return StringUtil.capitalize(StringUtil.toLowerCase(((TitledHandler)renameHandler).getActionTitle()));
        }
        @NlsSafe String handlerToString = renameHandler.toString();
        return handlerToString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameHandlerRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameHandlerRegistry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenameHandlers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetRenameHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasAvailableHandler";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRenameHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRenameHandlers";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetRenameHandlers";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HandlersChooser
    extends DialogWrapper {
        private final @NlsContexts.RadioButton String[] myRenamers;
        private String mySelection;
        private final JRadioButton[] myRButtons;

        protected HandlersChooser(Project project2, @NlsContexts.RadioButton String[] renamers) {
            super(project2);
            this.myRenamers = renamers;
            this.myRButtons = new JRadioButton[this.myRenamers.length];
            this.mySelection = renamers[0];
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.init();
        }

        protected JComponent createNorthPanel() {
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new BoxLayout(radioPanel, 1));
            JLabel descriptionLabel = new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
            descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            radioPanel.add(descriptionLabel);
            ButtonGroup bg = new ButtonGroup();
            boolean selected = true;
            int rIdx = 0;
            for (final String renamer : this.myRenamers) {
                final JRadioButton rb = new JRadioButton(renamer, selected);
                this.myRButtons[rIdx++] = rb;
                ItemListener listener2 = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (rb.isSelected()) {
                            mySelection = renamer;
                        }
                    }
                };
                rb.addItemListener(listener2);
                selected = false;
                bg.add(rb);
                radioPanel.add(rb);
            }
            new RadioUpDownListener(this.myRButtons);
            return radioPanel;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRButtons[0];
        }

        public String getSelection() {
            return this.mySelection;
        }

        protected JComponent createCenterPanel() {
            return null;
        }
    }
}

