/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesHandler
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(MoveFilesOrDirectoriesHandler.class);

    @Override
    public boolean canMove(PsiElement[] elements, PsiElement targetContainer, @Nullable PsiReference reference2) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element2 : elements) {
            if (element2 instanceof PsiFile) {
                PsiFile file2 = (PsiFile)element2;
                String name2 = file2.getName();
                if (names.contains(name2)) {
                    return false;
                }
                names.add(name2);
                continue;
            }
            if (element2 instanceof PsiDirectory) continue;
            return false;
        }
        return super.canMove(elements, targetContainer, reference2);
    }

    @Override
    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return MoveFilesOrDirectoriesHandler.isValidTarget(targetElement);
    }

    public static boolean isValidTarget(PsiElement psiElement) {
        if (psiElement == null) {
            return true;
        }
        if (!(psiElement instanceof PsiDirectory) && !(psiElement instanceof PsiDirectoryContainer)) {
            return false;
        }
        if (psiElement.getManager().isInProject(psiElement)) {
            return true;
        }
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(psiElement);
        return ScratchUtil.isScratch(virtualFile2) || virtualFile2 != null && ProjectRootManager.getInstance(psiElement.getProject()).getFileIndex().isExcluded(virtualFile2);
    }

    public void doMove(PsiElement[] elements, PsiElement targetContainer) {
        Project project2 = targetContainer != null ? targetContainer.getProject() : elements[0].getProject();
        this.doMove(project2, elements, targetContainer, null);
    }

    @Override
    public PsiElement @Nullable [] adjustForMove(Project project2, PsiElement[] sourceElements, PsiElement targetElement) {
        return PsiTreeUtil.filterAncestors(sourceElements);
    }

    @Override
    public void doMove(Project project2, PsiElement[] elements, PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (!LOG.assertTrue(targetContainer == null || targetContainer instanceof PsiDirectory || targetContainer instanceof PsiDirectoryContainer, "container: " + targetContainer + "; elements: " + Arrays.toString(elements) + "; working handler: " + this.toString())) {
            return;
        }
        PsiElement[] adjustedElements = this.adjustForMove(project2, elements, targetContainer);
        if (adjustedElements != null) {
            MoveFilesOrDirectoriesUtil.doMove(project2, adjustedElements, new PsiElement[]{targetContainer}, callback);
        }
    }

    @Override
    public boolean tryToMove(PsiElement element2, Project project2, DataContext dataContext, PsiReference reference2, Editor editor2) {
        if (element2 instanceof PsiFile && ((PsiFile)element2).getVirtualFile() != null || element2 instanceof PsiDirectory) {
            this.doMove(project2, new PsiElement[]{element2}, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
            return true;
        }
        if (element2 instanceof PsiPlainText) {
            PsiFile file2 = element2.getContainingFile();
            if (file2 != null) {
                this.doMove(project2, new PsiElement[]{file2}, null, null);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveFilesOrDirectoriesHandler.$$$reportNull$$$0(0);
        }
        int fileCount = 0;
        int directoryCount = 0;
        for (PsiElement element2 : elements) {
            if (element2 instanceof PsiFile) {
                ++fileCount;
                continue;
            }
            if (!(element2 instanceof PsiDirectory)) continue;
            ++directoryCount;
        }
        if (directoryCount == 0) {
            return fileCount == 1 ? RefactoringBundle.message((String)"move.file") : RefactoringBundle.message((String)"move.files");
        }
        if (fileCount == 0) {
            return directoryCount == 1 ? RefactoringBundle.message((String)"move.directory") : RefactoringBundle.message((String)"move.directories.with.dialog");
        }
        return RefactoringBundle.message((String)"move.files.and.directories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesHandler", "getActionName"));
    }
}

