/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public abstract class MoveFilesOrDirectoriesDialog
extends RefactoringDialog {
    private static final String MOVE_FILE = "MoveFile";
    private static final String RECENT_KEYS = "MoveFile.RECENT_KEYS";
    private static final String MOVE_FILES_OPEN_IN_EDITOR = "MoveFile.OpenInEditor";
    private JLabel myNameLabel;
    private TextFieldWithHistoryWithBrowseButton myTargetDirectoryField;
    private JCheckBox myCbSearchForReferences;
    private boolean isDumb;

    public MoveFilesOrDirectoriesDialog(@NotNull Project project2, PsiElement @NotNull [] psiElements, PsiDirectory initialTargetDirectory) {
        if (project2 == null) {
            MoveFilesOrDirectoriesDialog.$$$reportNull$$$0(0);
        }
        if (psiElements == null) {
            MoveFilesOrDirectoriesDialog.$$$reportNull$$$0(1);
        }
        super(project2, true, true);
        this.setTitle(RefactoringBundle.message((String)"move.title"));
        this.init();
        if (psiElements.length == 1) {
            PsiFileSystemItem element2 = (PsiFileSystemItem)psiElements[0];
            String path2 = CopyFilesOrDirectoriesDialog.shortenPath(element2.getVirtualFile());
            String string2 = RefactoringBundle.message((String)(element2 instanceof PsiFile ? "move.file.0" : "move.directory.0"), (Object[])new Object[]{path2});
            this.myNameLabel.setText(string2);
        } else {
            boolean isFile = true;
            boolean isDirectory = true;
            for (PsiElement psiElement : psiElements) {
                isFile &= psiElement instanceof PsiFile;
                isDirectory &= psiElement instanceof PsiDirectory;
            }
            this.myNameLabel.setText(isFile ? RefactoringBundle.message((String)"move.specified.files") : (isDirectory ? RefactoringBundle.message((String)"move.specified.directories") : RefactoringBundle.message((String)"move.specified.elements")));
        }
        String initialTargetPath = initialTargetDirectory == null ? "" : initialTargetDirectory.getVirtualFile().getPresentableUrl();
        ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setText(initialTargetPath);
        int lastDirectoryIdx = initialTargetPath.lastIndexOf(File.separator);
        int n = initialTargetPath.length();
        if (lastDirectoryIdx > 0 && lastDirectoryIdx + 1 < n) {
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getTextEditor().select(lastDirectoryIdx + 1, n);
        }
        this.validateButtons();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetDirectoryField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        this.myNameLabel = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        this.myTargetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
        List recentEntries = RecentsManager.getInstance((Project)this.myProject).getRecentEntries(RECENT_KEYS);
        if (recentEntries != null) {
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setHistory(recentEntries);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"the.file.will.be.moved.to.this.directory"), this.myProject, descriptor, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        JTextField textField = ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getTextEditor();
        FileChooserFactory.getInstance().installFileCompletion(textField, descriptor, true, this.getDisposable());
        textField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MoveFilesOrDirectoriesDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesDialog$1", "textChanged"));
            }
        });
        this.myTargetDirectoryField.setTextFieldPreferredWidth(70);
        Disposer.register(this.getDisposable(), (Disposable)this.myTargetDirectoryField);
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        this.isDumb = DumbService.isDumb(this.myProject);
        this.myCbSearchForReferences = new NonFocusableCheckBox(this.isDumb ? RefactoringBundle.message((String)"search.for.references.dumb.mode") : RefactoringBundle.message((String)"search.for.references"));
        this.myCbSearchForReferences.setSelected(!this.isDumb && RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE);
        this.myCbSearchForReferences.setEnabled(!this.isDumb);
        return FormBuilder.createFormBuilder().addComponent((JComponent)this.myNameLabel).addLabeledComponent(RefactoringBundle.message((String)"move.files.to.directory.label"), (JComponent)this.myTargetDirectoryField, 12).addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText})).addComponentToRightColumn((JComponent)this.myCbSearchForReferences, 12).getPanel();
    }

    @Override
    @NotNull
    protected String getRefactoringId() {
        return MOVE_FILE;
    }

    protected String getHelpId() {
        return "refactoring.moveFile";
    }

    public static boolean isOpenInEditorProperty() {
        return !ApplicationManager.getApplication().isUnitTestMode() && PropertiesComponent.getInstance().getBoolean(MOVE_FILES_OPEN_IN_EDITOR, false);
    }

    @Override
    protected boolean isOpenInEditorEnabledByDefault() {
        return false;
    }

    @Override
    protected boolean hasPreviewButton() {
        return false;
    }

    @Override
    protected boolean areButtonsValid() {
        return ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText().length() > 0;
    }

    @Override
    protected void doAction() {
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_KEYS, ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText());
        if (!this.isDumb) {
            RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE = this.myCbSearchForReferences.isSelected();
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            PsiDirectory targetDirectory;
            String directoryName = ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText().replace(File.separatorChar, '/');
            PsiDirectory directory = DirectoryUtil.findLongestExistingDirectory(PsiManager.getInstance(this.myProject), directoryName);
            PsiDirectory psiDirectory = targetDirectory = directory == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, Collections.singletonList(directory), (boolean)false) ? null : ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    return DirectoryUtil.mkdirs(PsiManager.getInstance(this.myProject), directoryName);
                }
                catch (IncorrectOperationException ignored) {
                    return null;
                }
            });
            if (targetDirectory == null) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)this.getHelpId(), (Project)this.myProject);
            } else {
                this.performMove(targetDirectory);
            }
        }, RefactoringBundle.message((String)"move.title"), null);
    }

    protected abstract void performMove(@NotNull PsiDirectory var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

