/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryUsageInfo;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class MoveDirectoryWithClassesHelper {
    private static final ExtensionPointName<MoveDirectoryWithClassesHelper> EP_NAME = ExtensionPointName.create("com.intellij.refactoring.moveDirectoryWithClassesHelper");

    public abstract void findUsages(Collection<PsiFile> var1, PsiDirectory[] var2, Collection<UsageInfo> var3, boolean var4, boolean var5, Project var6);

    public void findUsages(Map<VirtualFile, MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper> filesToMove, PsiDirectory[] directoriesToMove, Collection<UsageInfo> result2, boolean searchInComments, boolean searchInNonJavaFiles, Project project2) {
        Set<PsiFile> psiFiles = filesToMove.keySet().stream().map(PsiManager.getInstance(project2)::findFile).filter(Objects::nonNull).collect(Collectors.toSet());
        this.findUsages(psiFiles, directoriesToMove, result2, searchInComments, searchInNonJavaFiles, project2);
    }

    public abstract boolean move(PsiFile var1, PsiDirectory var2, Map<PsiElement, PsiElement> var3, List<PsiFile> var4, RefactoringElementListener var5);

    public abstract void postProcessUsages(UsageInfo[] var1, Function<? super PsiDirectory, ? extends PsiDirectory> var2);

    public abstract void beforeMove(PsiFile var1);

    public abstract void afterMove(PsiElement var1);

    public void preprocessUsages(Project project2, Set<PsiFile> files2, UsageInfo[] infos, PsiDirectory targetDirectory, MultiMap<PsiElement, String> conflicts) {
    }

    public static List<MoveDirectoryWithClassesHelper> findAll() {
        return EP_NAME.getExtensionList();
    }

    public static class Default
    extends MoveDirectoryWithClassesHelper {
        @Override
        public void findUsages(Collection<PsiFile> filesToMove, PsiDirectory[] directoriesToMove, Collection<UsageInfo> result2, boolean searchInComments, boolean searchInNonJavaFiles, Project project2) {
            for (PsiFile file2 : filesToMove) {
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)file2)) {
                    result2.add(new MoveDirectoryUsageInfo(reference2, file2));
                }
            }
            for (PsiDirectory psiDirectory : directoriesToMove) {
                for (PsiReference reference3 : ReferencesSearch.search((PsiElement)psiDirectory)) {
                    result2.add(new MoveDirectoryUsageInfo(reference3, (PsiFileSystemItem)psiDirectory));
                }
            }
        }

        @Override
        public void postProcessUsages(UsageInfo[] usages, Function<? super PsiDirectory, ? extends PsiDirectory> newDirMapper) {
            for (UsageInfo usage2 : usages) {
                PsiReference reference2;
                if (!(usage2 instanceof MoveDirectoryUsageInfo) || (reference2 = usage2.getReference()) == null) continue;
                PsiFileSystemItem file2 = ((MoveDirectoryUsageInfo)usage2).getTargetFileItem();
                if (file2 instanceof PsiDirectory) {
                    file2 = newDirMapper.fun((PsiDirectory)file2);
                }
                reference2.bindToElement(file2);
            }
        }

        @Override
        public boolean move(PsiFile psiFile, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewElementsMapping, List<PsiFile> movedFiles, RefactoringElementListener listener2) {
            if (moveDestination.equals(psiFile.getContainingDirectory())) {
                return false;
            }
            MoveFileHandler.forElement(psiFile).prepareMovedFile(psiFile, moveDestination, oldToNewElementsMapping);
            PsiFile moving = moveDestination.findFile(psiFile.getName());
            if (moving == null) {
                MoveFilesOrDirectoriesUtil.doMoveFile(psiFile, moveDestination);
            }
            moving = moveDestination.findFile(psiFile.getName());
            movedFiles.add(moving);
            listener2.elementMoved(psiFile);
            return true;
        }

        @Override
        public void beforeMove(PsiFile psiFile) {
        }

        @Override
        public void afterMove(PsiElement newElement) {
        }
    }
}

