/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public class ExtractIncludeDialog
extends DialogWrapper {
    private final PsiDirectory myCurrentDirectory;
    protected final String myExtension;
    protected TextFieldWithBrowseButton myTargetDirectoryField;
    private JTextField myNameField;
    protected JLabel myTargetDirLabel;
    private PsiDirectory myTargetDirectory;

    public ExtractIncludeDialog(PsiDirectory currentDirectory, String extension2) {
        super(true);
        this.myCurrentDirectory = currentDirectory;
        this.myExtension = extension2;
        this.setTitle(ExtractIncludeDialog.getRefactoringName());
        this.init();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getTargetFileName() {
        String name2 = this.myNameField.getText().trim();
        return name2.contains(".") ? name2 : name2 + "." + this.myExtension;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new VerticalFlowLayout());
        JLabel nameLabel = new JLabel();
        panel2.add(nameLabel);
        this.myNameField = new JTextField();
        nameLabel.setLabelFor(this.myNameField);
        this.myNameField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExtractIncludeDialog.this.validateOKButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/lang/ExtractIncludeDialog$1", "textChanged"));
            }
        });
        panel2.add(this.myNameField);
        nameLabel.setText(this.getNameLabel());
        this.myTargetDirLabel = new JLabel();
        panel2.add(this.myTargetDirLabel);
        this.myTargetDirectoryField = new TextFieldWithBrowseButton();
        this.myTargetDirectoryField.setText(this.myCurrentDirectory.getVirtualFile().getPresentableUrl());
        this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"select.target.directory.description"), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myTargetDirLabel.setText(RefactoringBundle.message((String)"extract.to.directory"));
        panel2.add((Component)this.myTargetDirectoryField);
        this.myTargetDirectoryField.getTextField().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExtractIncludeDialog.this.validateOKButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/lang/ExtractIncludeDialog$2", "textChanged"));
            }
        });
        this.validateOKButton();
        return panel2;
    }

    @NlsContexts.Label
    protected String getNameLabel() {
        return RefactoringBundle.message((String)"name.for.extracted.include.file", (Object[])new Object[]{this.myExtension});
    }

    private void validateOKButton() {
        String fileName = this.myNameField.getText().trim();
        this.setOKActionEnabled(this.myTargetDirectoryField.getText().trim().length() > 0 && fileName.length() > 0 && fileName.indexOf(File.separatorChar) < 0 && !StringUtil.containsAnyChar(fileName, "*?><\":;|") && fileName.indexOf(".") != 0);
    }

    private static boolean isFileExist(@NotNull String directory, @NotNull String fileName) {
        if (directory == null) {
            ExtractIncludeDialog.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            ExtractIncludeDialog.$$$reportNull$$$0(1);
        }
        return LocalFileSystem.getInstance().findFileByIoFile(new File(directory, fileName)) != null;
    }

    protected void doOKAction() {
        String targetFileName;
        Project project2 = this.myCurrentDirectory.getProject();
        String directoryName = this.myTargetDirectoryField.getText().replace(File.separatorChar, '/');
        if (ExtractIncludeDialog.isFileExist(directoryName, targetFileName = this.getTargetFileName())) {
            Messages.showErrorDialog((Project)project2, (String)RefactoringBundle.message((String)"file.already.exist", (Object[])new Object[]{targetFileName}), (String)RefactoringBundle.message((String)"file.already.exist.title"));
            return;
        }
        FileType type = FileTypeChooser.getKnownFileTypeOrAssociate((String)targetFileName);
        if (type == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            Runnable action2 = () -> {
                try {
                    PsiDirectory targetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance(project2), directoryName);
                    assert (targetDirectory != null) : directoryName;
                    targetDirectory.checkCreateFile(targetFileName);
                    String webPath = PsiFileSystemItemUtil.findRelativePath(this.myCurrentDirectory, targetDirectory);
                    this.myTargetDirectory = webPath == null ? null : targetDirectory;
                }
                catch (IncorrectOperationException e) {
                    CommonRefactoringUtil.showErrorMessage((String)ExtractIncludeDialog.getRefactoringName(), (String)e.getMessage(), null, (Project)project2);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, RefactoringBundle.message((String)"create.directory"), null);
        if (this.myTargetDirectory == null) {
            return;
        }
        super.doOKAction();
    }

    protected String getHelpId() {
        return "refactoring.extractInclude";
    }

    protected void hideTargetDirectory() {
        this.myTargetDirectoryField.setVisible(false);
        this.myTargetDirLabel.setVisible(false);
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"extractIncludeFile.name");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileName";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/lang/ExtractIncludeDialog";
        objectArray[2] = "isFileExist";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

