/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.lang.LanguageDependentMembersRefactoringSupport;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MemberDependenciesStorage<T extends NavigatablePsiElement, C extends PsiElement> {
    protected final C myClass;
    private C mySuperClass;
    private final Map<T, Set<T>> myDependencyGraph;

    public MemberDependenciesStorage(C aClass, C superClass) {
        this.myClass = aClass;
        this.mySuperClass = superClass;
        this.myDependencyGraph = new HashMap<T, Set<T>>();
    }

    public void setSuperClass(C superClass) {
        this.mySuperClass = superClass;
    }

    @Nullable
    protected Set<T> getMemberDependencies(T member) {
        Set<T> result2 = this.myDependencyGraph.get(member);
        if (result2 == null) {
            DependentMembersCollectorBase<T, C> collector2 = this.getCollector(member);
            if (collector2 != null) {
                collector2.collect(member);
                result2 = collector2.getCollection();
            }
            this.myDependencyGraph.put(member, result2);
        }
        return result2;
    }

    private DependentMembersCollectorBase<T, C> getCollector(T member) {
        ClassMembersRefactoringSupport factory2 = (ClassMembersRefactoringSupport)LanguageDependentMembersRefactoringSupport.INSTANCE.forLanguage(member.getLanguage());
        return factory2 != null ? factory2.createDependentMembersCollector(this.myClass, this.mySuperClass) : null;
    }
}

