/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class MemberNodeBase<M extends PsiElement>
extends CheckedTreeNode {
    protected final M myMethod;
    protected final Set<M> myCalled;
    protected final Project myProject;
    protected final Runnable myCancelCallback;
    private boolean myOldChecked;

    protected abstract MemberNodeBase<M> createNode(M var1, HashSet<M> var2);

    protected abstract List<M> computeCallers();

    protected abstract void customizeRendererText(ColoredTreeCellRenderer var1);

    protected Condition<M> getFilter() {
        return Conditions.alwaysTrue();
    }

    protected MemberNodeBase(M method2, Set<M> called, Project project2, Runnable cancelCallback) {
        super(method2);
        this.myMethod = method2;
        this.myCalled = called;
        this.myProject = project2;
        this.myCancelCallback = cancelCallback;
        this.isChecked = false;
    }

    private void buildChildren() {
        if (this.children == null) {
            List<M> callers = this.findCallers();
            this.children = new Vector(callers.size());
            for (PsiElement caller : callers) {
                HashSet<M> called = new HashSet<M>(this.myCalled);
                called.add(this.getMember());
                MemberNodeBase<PsiElement> child = this.createNode(caller, called);
                this.children.add(child);
                child.parent = this;
            }
        }
    }

    @Override
    public TreeNode getChildAt(int index) {
        this.buildChildren();
        return super.getChildAt(index);
    }

    @Override
    public int getChildCount() {
        this.buildChildren();
        return super.getChildCount();
    }

    @Override
    public boolean isLeaf() {
        if (this.children == null) {
            return false;
        }
        return super.isLeaf();
    }

    @Override
    public int getIndex(TreeNode aChild) {
        this.buildChildren();
        return super.getIndex(aChild);
    }

    private List<M> findCallers() {
        if (this.getMember() == null) {
            return Collections.emptyList();
        }
        Ref callers = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> callers.set(ContainerUtil.filter(this.computeCallers(), this.getFilter()))), RefactoringBundle.message((String)"caller.chooser.looking.for.callers"), true, this.myProject)) {
            this.myCancelCallback.run();
            return Collections.emptyList();
        }
        return (List)callers.get();
    }

    public void customizeRenderer(ColoredTreeCellRenderer renderer) {
        if (this.getMember() == null) {
            return;
        }
        int flags = 3;
        renderer.setIcon(ReadAction.compute(() -> this.getMember().getIcon(3)));
        this.customizeRendererText(renderer);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.myOldChecked = this.isChecked();
            this.setChecked(false);
        } else {
            this.setChecked(this.myOldChecked);
        }
    }

    public M getMember() {
        return this.myMethod;
    }

    public PsiElement getElementToSearch() {
        return this.getMember();
    }
}

