/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.RefactoringBundle;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum SkipOverwriteChoice {
    OVERWRITE("copy.overwrite.button"),
    SKIP("copy.skip.button"),
    OVERWRITE_ALL("copy.overwrite.for.all.button"),
    SKIP_ALL("copy.skip.for.all.button");

    private final String myKey;

    private SkipOverwriteChoice(String key) {
        this.myKey = key;
    }

    private static String[] getOptions(boolean full) {
        if (full) {
            return (String[])Arrays.stream(SkipOverwriteChoice.values()).map(choice -> SkipOverwriteChoice.getMessage(choice)).toArray(String[]::new);
        }
        return new String[]{SkipOverwriteChoice.getMessage(OVERWRITE), SkipOverwriteChoice.getMessage(SKIP)};
    }

    @NotNull
    @Nls
    private static String getMessage(SkipOverwriteChoice choice) {
        String string2 = RefactoringBundle.message((String)choice.myKey);
        if (string2 == null) {
            SkipOverwriteChoice.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    public static SkipOverwriteChoice askUser(@NotNull PsiDirectory targetDirectory, @NotNull @NlsSafe String fileName, @NlsContexts.Command String title, boolean includeAllCases) {
        if (targetDirectory == null) {
            SkipOverwriteChoice.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            SkipOverwriteChoice.$$$reportNull$$$0(2);
        }
        String message2 = RefactoringBundle.message((String)"dialog.message.file.already.exists.in.directory", (Object[])new Object[]{fileName, targetDirectory.getVirtualFile().getPresentableUrl()});
        int selection = Messages.showDialog((Project)targetDirectory.getProject(), (String)message2, (String)title, (String[])SkipOverwriteChoice.getOptions(includeAllCases), (int)0, (Icon)Messages.getQuestionIcon());
        if (selection < 0) {
            SkipOverwriteChoice skipOverwriteChoice = SKIP;
            if (skipOverwriteChoice == null) {
                SkipOverwriteChoice.$$$reportNull$$$0(3);
            }
            return skipOverwriteChoice;
        }
        SkipOverwriteChoice skipOverwriteChoice = SkipOverwriteChoice.values()[selection];
        if (skipOverwriteChoice == null) {
            SkipOverwriteChoice.$$$reportNull$$$0(4);
        }
        return skipOverwriteChoice;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/SkipOverwriteChoice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/SkipOverwriteChoice";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "askUser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "askUser";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

