/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.PsiIntroduceTarget;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntroduceTargetChooser {
    private IntroduceTargetChooser() {
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor2, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback, @NotNull Function<? super T, String> renderer) {
        if (editor2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(0);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(3);
        }
        IntroduceTargetChooser.showChooser(editor2, expressions, callback, renderer, RefactoringBundle.message((String)"introduce.target.chooser.expressions.title"));
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor2, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title) {
        if (editor2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(4);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(6);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(7);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(8);
        }
        IntroduceTargetChooser.showChooser(editor2, expressions, callback, renderer, title, ScopeHighlighter.NATURAL_RANGER);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor2, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        if (editor2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(9);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(11);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(12);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(13);
        }
        if (ranger == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(14);
        }
        IntroduceTargetChooser.showChooser(editor2, expressions, callback, renderer, title, -1, ranger);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor2, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title, int selection, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        if (editor2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(15);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(16);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(17);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(18);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(19);
        }
        if (ranger == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(20);
        }
        List<MyIntroduceTarget> targets2 = ContainerUtil.map(expressions, t -> new MyIntroduceTarget<PsiElement>((PsiElement)t, (NotNullFunction<PsiElement, TextRange>)ranger, renderer));
        IntroduceTargetChooser.showIntroduceTargetChooser(editor2, targets2, target2 -> callback.pass((Object)target2.getPlace()), title, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor2, @NotNull List<T> expressions, @NotNull Consumer<? super T> callback, @NotNull @NlsContexts.PopupTitle String title, int selection) {
        if (editor2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(21);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(22);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(23);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(24);
        }
        IntroduceTargetChooser.showIntroduceTargetChooser(editor2, expressions, Pass.create(callback), title, null, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor2, @NotNull List<T> expressions, @NotNull Pass<? super T> callback, @NotNull @NlsContexts.PopupTitle String title, @Nullable JComponent southComponent, int selection) {
        if (editor2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(25);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(26);
        }
        if (callback == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(27);
        }
        if (title == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(28);
        }
        final AtomicReference<ScopeHighlighter> highlighter = new AtomicReference<ScopeHighlighter>(new ScopeHighlighter(editor2));
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(expressions).setSelectionMode(0).setSelectedValue((Object)((IntroduceTarget)expressions.get(selection > -1 ? selection : 0)), true).setAccessibleName(title).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemSelectedCallback(expr -> {
            ScopeHighlighter h = (ScopeHighlighter)highlighter.get();
            if (h == null) {
                return;
            }
            h.dropHighlight();
            if (expr != null && expr.isValid()) {
                TextRange range = expr.getTextRange();
                h.highlight(Pair.create(range, Collections.singletonList(range)));
            }
        }).setItemChosenCallback(expr -> {
            if (expr.isValid()) {
                callback.pass(expr);
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((ScopeHighlighter)highlighter.getAndSet(null)).dropHighlight();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/IntroduceTargetChooser$2", "onClosed"));
            }
        }).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                IntroduceTarget expr = (IntroduceTarget)value;
                if (expr.isValid()) {
                    String text2;
                    int firstNewLinePos = (text2 = expr.render()).indexOf(10);
                    Object trimmedText = text2.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text2.length()));
                    if (((String)trimmedText).length() != text2.length()) {
                        trimmedText = (String)trimmedText + " ...";
                    }
                    this.setText((String)trimmedText);
                } else {
                    this.setForeground(JBColor.RED);
                    this.setText(IdeBundle.message((String)"invalid.node.text", (Object[])new Object[0]));
                }
                return rendererComponent;
            }
        });
        if (southComponent != null && builder2 instanceof PopupChooserBuilder) {
            ((PopupChooserBuilder)builder2).setSouthComponent(southComponent);
        }
        JBPopup popup2 = builder2.createPopup();
        popup2.showInBestPositionFor(editor2);
        Project project2 = editor2.getProject();
        if (project2 != null && !popup2.isDisposed()) {
            NavigationUtil.hidePopupIfDumbModeStarts(popup2, project2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 17: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranger";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/IntroduceTargetChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showChooser";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "showIntroduceTargetChooser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyIntroduceTarget<T extends PsiElement>
    extends PsiIntroduceTarget<T> {
        private final NotNullFunction<? super PsiElement, ? extends TextRange> myRanger;
        private final Function<? super T, String> myRenderer;

        MyIntroduceTarget(@NotNull T psi, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger, @NotNull Function<? super T, String> renderer) {
            if (psi == null) {
                MyIntroduceTarget.$$$reportNull$$$0(0);
            }
            if (ranger == null) {
                MyIntroduceTarget.$$$reportNull$$$0(1);
            }
            if (renderer == null) {
                MyIntroduceTarget.$$$reportNull$$$0(2);
            }
            super(psi);
            this.myRanger = ranger;
            this.myRenderer = renderer;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myRanger.fun((PsiElement)this.getPlace());
            if (textRange == null) {
                MyIntroduceTarget.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @Override
        @NotNull
        public String render() {
            String string2 = this.myRenderer.fun(this.getPlace());
            if (string2 == null) {
                MyIntroduceTarget.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public String toString() {
            return this.isValid() ? this.render() : "invalid";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranger";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "render";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

