/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StubTreeLoaderImpl
extends StubTreeLoader {
    private static final Logger LOG = Logger.getInstance(StubTreeLoaderImpl.class);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 3, true);
    private static final byte IS_BINARY_MASK = 1;
    private static final byte BYTE_AND_CHAR_LENGTHS_ARE_THE_SAME_MASK = 2;
    private static volatile boolean ourStubReloadingProhibited;

    StubTreeLoaderImpl() {
    }

    @Override
    @Nullable
    public ObjectStubTree<?> readOrBuild(@NotNull Project project2, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        ObjectStubTree<?> fromIndices;
        if (project2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(1);
        }
        if ((fromIndices = this.readFromVFile(project2, vFile)) != null) {
            return fromIndices;
        }
        return this.build(project2, vFile, psiFile);
    }

    @Override
    @Nullable
    public ObjectStubTree<?> build(@Nullable Project project2, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(2);
        }
        try {
            byte[] content2 = vFile.contentsToByteArray();
            return vFile.computeWithPreloadedContentHint(content2, () -> {
                ObjectStubTree tree;
                Stub element2;
                FileContentImpl fc = (FileContentImpl)FileContentImpl.createByContent(vFile, content2);
                if (project2 != null) {
                    LOG.assertTrue(!project2.isDefault());
                    fc.setProject(project2);
                }
                if (psiFile != null && !vFile.getFileType().isBinary()) {
                    fc.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, psiFile.getViewProvider().getContents());
                }
                if ((element2 = RecursionManager.doPreventingRecursion(vFile, false, () -> StubTreeBuilder.buildStubTree(fc))) instanceof PsiFileStub) {
                    tree = new StubTree((PsiFileStub)element2);
                } else {
                    ObjectStubTree objectStubTree = tree = element2 instanceof ObjectStubBase ? new ObjectStubTree((ObjectStubBase)element2, true) : null;
                }
                if (tree != null) {
                    tree.setDebugInfo("created from file content");
                    return tree;
                }
                return null;
            });
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e);
            } else {
                LOG.info("Can't load file content for stub building: " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    @Nullable
    public ObjectStubTree<?> readFromVFile(@NotNull Project project2, @NotNull VirtualFile vFile) {
        if (project2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(3);
        }
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(4);
        }
        if (DumbService.getInstance(project2).isDumb() && (!FileBasedIndex.isIndexAccessDuringDumbModeEnabled() || FileBasedIndex.getInstance().getCurrentDumbModeAccessType() != DumbModeAccessType.RELIABLE_DATA_ONLY) || NoAccessDuringPsiEvents.isInsideEventProcessing()) {
            return null;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (!(fileBasedIndex instanceof FileBasedIndexImpl)) {
            return null;
        }
        boolean wasIndexedAlready = ((FileBasedIndexImpl)fileBasedIndex).isFileUpToDate(vFile);
        Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
        boolean saved = document == null || !FileDocumentManager.getInstance().isDocumentUnsaved(document);
        SerializedStubTree stubTree = (SerializedStubTree)FileBasedIndex.getInstance().getSingleEntryIndexData(StubUpdatingIndex.INDEX_ID, vFile, project2);
        if (stubTree != null) {
            Stub stub;
            if (vFile instanceof VirtualFileWithId && !this.checkLengthMatch(project2, vFile, wasIndexedAlready, document, saved)) {
                return null;
            }
            try {
                stub = stubTree.getStub();
            }
            catch (SerializerNotFoundException e) {
                return StubTreeLoaderImpl.processError(vFile, "No stub serializer: " + vFile.getPresentableUrl() + ": " + e.getMessage(), e);
            }
            if (stub == SerializedStubTree.NO_STUB) {
                return null;
            }
            ObjectStubTree tree = stub instanceof PsiFileStub ? new StubTree((PsiFileStub)stub) : new ObjectStubTree((ObjectStubBase)stub, true);
            tree.setDebugInfo("created from index");
            StubTreeLoaderImpl.checkDeserializationCreatesNoPsi(tree);
            return tree;
        }
        return null;
    }

    private boolean checkLengthMatch(Project project2, VirtualFile vFile, boolean wasIndexedAlready, Document document, boolean saved) {
        PsiFile cachedPsi = PsiManagerEx.getInstanceEx(project2).getFileManager().getCachedPsiFile(vFile);
        IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(vFile);
        if (indexingStampInfo != null && !indexingStampInfo.contentLengthMatches(vFile.getLength(), StubTreeLoaderImpl.getCurrentTextContentLength(project2, vFile, document, cachedPsi))) {
            this.diagnoseLengthMismatch(vFile, wasIndexedAlready, document, saved, cachedPsi);
            return false;
        }
        return true;
    }

    private void diagnoseLengthMismatch(@NotNull VirtualFile vFile, boolean wasIndexedAlready, @Nullable Document document, boolean saved, @Nullable PsiFile cachedPsi) {
        Path nioPath;
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(5);
        }
        String message2 = "Outdated stub in index: " + vFile + " " + this.getIndexingStampInfo(vFile) + ", doc=" + document + ", docSaved=" + saved + ", wasIndexedAlready=" + wasIndexedAlready + ", queried at " + vFile.getTimeStamp();
        message2 = message2 + "\ndoc length=" + (document == null ? -1 : document.getTextLength()) + "\nfile length=" + vFile.getLength();
        if (cachedPsi != null) {
            message2 = message2 + "\ncached PSI " + cachedPsi.getClass();
            if (cachedPsi instanceof PsiFileImpl && ((PsiFileImpl)cachedPsi).isContentsLoaded()) {
                message2 = message2 + "\nPSI length=" + cachedPsi.getTextLength();
            }
            List<Project> projects = ContainerUtil.findAll(ProjectManager.getInstance().getOpenProjects(), p -> PsiManagerEx.getInstanceEx(p).getFileManager().findCachedViewProvider(vFile) != null);
            message2 = message2 + "\nprojects with file: " + (Serializable)(LOG.isDebugEnabled() ? projects.toString() : Integer.valueOf(projects.size()));
        }
        if ((nioPath = vFile.getFileSystem().getNioPath(vFile)) != null) {
            message2 = message2 + StubTreeLoaderImpl.getPhysicalFileReport(nioPath);
        }
        StubTreeLoaderImpl.processError(vFile, message2, new Exception());
    }

    private static String getPhysicalFileReport(@NotNull Path file2) {
        if (file2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(6);
        }
        String message2 = "\nphysical file " + (Files.exists(file2, new LinkOption[0]) ? "exists" : "doesn't exist") + "; length = ";
        try {
            message2 = message2 + Files.size(file2);
        }
        catch (IOException e) {
            message2 = message2 + e.getMessage();
        }
        return message2;
    }

    private static void checkDeserializationCreatesNoPsi(ObjectStubTree<?> tree) {
        if (ourStubReloadingProhibited || !(tree instanceof StubTree)) {
            return;
        }
        for (PsiFileStub root : ((PsiFileStubImpl)tree.getRoot()).getStubRoots()) {
            if (!(root instanceof StubBase)) continue;
            StubList stubList = ((StubBase)((Object)root)).myStubList;
            for (int i = 0; i < stubList.size(); ++i) {
                PsiElement cachedPsi;
                StubBase<?> each = stubList.getCachedStub(i);
                PsiElement psiElement = cachedPsi = each == null ? null : (PsiElement)each.getCachedPsi();
                if (cachedPsi == null) continue;
                ourStubReloadingProhibited = true;
                throw new AssertionError((Object)("Stub deserialization shouldn't create PSI: " + cachedPsi + "; " + each));
            }
        }
    }

    private static int getCurrentTextContentLength(Project project2, VirtualFile vFile, Document document, PsiFile psiFile) {
        if (vFile.getFileType().isBinary()) {
            return -1;
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            return psiFile.getTextLength();
        }
        if (document != null) {
            return PsiDocumentManager.getInstance(project2).getLastCommittedText(document).length();
        }
        return -1;
    }

    private static ObjectStubTree<?> processError(VirtualFile vFile, String message2, @Nullable Exception e) {
        LOG.error(message2, e);
        AppUIExecutor.onWriteThread(ModalityState.NON_MODAL).later().submit(() -> {
            Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
            if (doc != null) {
                FileDocumentManager.getInstance().saveDocument(doc);
            }
            FileBasedIndex.getInstance().requestReindex(vFile);
        });
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile2) {
        FileBasedIndex.getInstance().requestReindex(virtualFile2);
    }

    @Override
    public boolean canHaveStub(VirtualFile file2) {
        return StubUpdatingIndex.canHaveStub((VirtualFile)file2);
    }

    @Override
    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(7);
        }
        int count2 = 0;
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (PsiManagerEx.getInstanceEx(project2).getFileManager().findCachedViewProvider(virtualFile2) == null) continue;
            ++count2;
        }
        return count2 > 1;
    }

    @Override
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(8);
        }
        return StubTreeLoaderImpl.readSavedIndexingStampInfo(file2);
    }

    @Override
    protected boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(9);
        }
        return ((FileBasedIndexImpl)FileBasedIndex.getInstance()).isTooLarge(file2);
    }

    static void saveIndexingStampInfo(@Nullable IndexingStampInfo indexingStampInfo, int fileId) {
        try (AttributeOutputStream stream = FSRecords.writeAttribute((int)fileId, (FileAttribute)INDEXED_STAMP);){
            if (indexingStampInfo == null) {
                return;
            }
            DataInputOutputUtil.writeTIME(stream, indexingStampInfo.indexingFileStamp);
            DataInputOutputUtil.writeLONG(stream, indexingStampInfo.indexingByteLength);
            boolean lengthsAreTheSame = (long)indexingStampInfo.indexingCharLength == indexingStampInfo.indexingByteLength;
            byte flags = 0;
            flags = BitUtil.set(flags, (byte)1, indexingStampInfo.isBinary);
            flags = BitUtil.set(flags, (byte)2, lengthsAreTheSame);
            stream.writeByte(flags);
            if (!lengthsAreTheSame && !indexingStampInfo.isBinary) {
                DataInputOutputUtil.writeINT(stream, indexingStampInfo.indexingCharLength);
            }
        }
        catch (IOException e) {
            StubUpdatingIndex.LOG.error(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo readSavedIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(10);
        }
        try (AttributeInputStream stream = INDEXED_STAMP.readFileAttribute(file2);){
            if (stream == null || stream.available() <= 0) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME(stream);
            long byteLength = DataInputOutputUtil.readLONG(stream);
            byte flags = stream.readByte();
            boolean isBinary = BitUtil.isSet(flags, (byte)1);
            boolean readOnlyOneLength = BitUtil.isSet(flags, (byte)2);
            int charLength = isBinary ? -1 : (readOnlyOneLength ? (int)byteLength : DataInputOutputUtil.readINT(stream));
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, byteLength, charLength, isBinary);
            return indexingStampInfo;
        }
        catch (IOException e) {
            StubUpdatingIndex.LOG.error(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/StubTreeLoaderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readOrBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromVFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "diagnoseLengthMismatch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPhysicalFileReport";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPsiInManyProjects";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexingStampInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isTooLarge";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "readSavedIndexingStampInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

