/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.memory.InMemoryIndexStorage;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class StubIndexImpl
extends StubIndexEx {
    static final Logger LOG = Logger.getInstance(StubIndexImpl.class);
    private final AtomicBoolean myForcedClean = new AtomicBoolean();
    private volatile CompletableFuture<AsyncState> myStateFuture;
    private volatile AsyncState myState;
    private volatile boolean myInitialized;

    public StubIndexImpl() {
        StubIndexExtension.EP_NAME.addExtensionPointListener(new ExtensionPointListener<StubIndexExtension<?, ?>>(){

            @Override
            public void extensionRemoved(@NotNull StubIndexExtension<?, ?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ID.unloadId(extension2.getKey());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/stubs/StubIndexImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private AsyncState getAsyncState() {
        AsyncState state = this.myState;
        if (state == null) {
            if (this.myStateFuture == null) {
                ((FileBasedIndexImpl)FileBasedIndex.getInstance()).waitUntilIndicesAreInitialized();
            }
            if (ProgressManager.getInstance().isInNonCancelableSection()) {
                try {
                    state = (AsyncState)Futures.getUnchecked(this.myStateFuture);
                }
                catch (Exception e) {
                    FileBasedIndexImpl.LOG.error(e);
                }
            } else {
                state = (AsyncState)ProgressIndicatorUtils.awaitWithCheckCanceled(this.myStateFuture);
            }
            this.myState = state;
        }
        return state;
    }

    @ApiStatus.Internal
    @TestOnly
    public void waitUntilStubIndexedInitialized() {
        this.getAsyncState();
    }

    public void initializationFailed(@NotNull Throwable error) {
        if (error == null) {
            StubIndexImpl.$$$reportNull$$$0(0);
        }
        this.myStateFuture = new CompletableFuture();
        this.myStateFuture.completeExceptionally(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K> void registerIndexer(@NotNull StubIndexExtension<K, ?> extension2, boolean forceClean, @NotNull AsyncState state, @NotNull IndexVersionRegistrationSink registrationResultSink) throws IOException {
        if (extension2 == null) {
            StubIndexImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(2);
        }
        if (registrationResultSink == null) {
            StubIndexImpl.$$$reportNull$$$0(3);
        }
        StubIndexKey indexKey = extension2.getKey();
        int version = extension2.getVersion();
        FileBasedIndexExtension wrappedExtension = StubIndexImpl.wrapStubIndexExtension(extension2);
        Path indexRootDir = IndexInfrastructure.getIndexRootDir((ID)indexKey);
        IndexVersion.IndexVersionDiff versionDiff = forceClean ? new IndexVersion.IndexVersionDiff.InitialBuild(version) : IndexVersion.versionDiffers(indexKey, version);
        registrationResultSink.setIndexVersionDiff(indexKey, versionDiff);
        if (versionDiff != IndexVersion.IndexVersionDiff.UP_TO_DATE) {
            FileUtil.deleteWithRenamingIfExists(indexRootDir);
            IndexVersion.rewriteVersion(indexKey, version);
            try {
                for (FileBasedIndexInfrastructureExtension ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    ex.onStubIndexVersionChanged(indexKey);
                }
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        UpdatableIndex stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        ReadWriteLock lock = stubUpdatingIndex.getLock();
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                UpdatableIndex index = TransientFileContentIndex.createIndex(wrappedExtension, new StubIndexStorageLayout(wrappedExtension, indexKey), lock);
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    UpdatableIndex intermediateIndex = infrastructureExtension.combineIndex(wrappedExtension, index);
                    if (intermediateIndex == null) continue;
                    index = intermediateIndex;
                }
                AsyncState asyncState = state;
                synchronized (asyncState) {
                    state.myIndices.put(indexKey, index);
                    break;
                }
            }
            catch (IOException e) {
                registrationResultSink.setIndexVersionDiff(indexKey, new IndexVersion.IndexVersionDiff.CorruptedRebuild(version));
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexEx.getCauseToRebuildIndex((RuntimeException)e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version, indexRootDir, e);
            }
        }
    }

    private static <K> void onExceptionInstantiatingIndex(@NotNull StubIndexKey<K, ?> indexKey, int version, @NotNull Path indexRootDir, @NotNull Exception e) throws IOException {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(4);
        }
        if (indexRootDir == null) {
            StubIndexImpl.$$$reportNull$$$0(5);
        }
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(6);
        }
        LOG.info(e);
        FileUtil.deleteWithRenaming(indexRootDir.toFile());
        IndexVersion.rewriteVersion(indexKey, version);
    }

    public long getIndexModificationStamp(@NotNull StubIndexKey<?, ?> indexId, @NotNull Project project2) {
        UpdatableIndex<?, Void, FileContent, ?> index;
        if (indexId == null) {
            StubIndexImpl.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            StubIndexImpl.$$$reportNull$$$0(8);
        }
        if ((index = this.getAsyncState().myIndices.get(indexId)) != null) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, GlobalSearchScope.allScope(project2));
            return index.getModificationStamp();
        }
        return -1L;
    }

    public void flush() throws StorageException {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex<?, Void, FileContent, ?> index : this.getAsyncState().myIndices.values()) {
            index.flush();
        }
    }

    @ApiStatus.Internal
    protected <Key> UpdatableIndex<Key, Void, FileContent, ?> getIndex(@NotNull StubIndexKey<Key, ?> indexKey) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(9);
        }
        return this.getAsyncState().myIndices.get(indexKey);
    }

    public void forceRebuild(@NotNull Throwable e) {
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(10);
        }
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    void initializeStubIndexes() {
        assert (!this.myInitialized);
        if (this.myStateFuture == null) {
            FileBasedIndex.getInstance();
            this.myStateFuture = new CompletableFuture();
            Future<AsyncState> future2 = IndexDataInitializer.submitGenesisTask(new StubIndexInitialization());
            if (!IndexDataInitializer.ourDoAsyncIndicesInitialization) {
                try {
                    future2.get();
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            }
        }
    }

    public void dispose() {
        try {
            for (UpdatableIndex<?, Void, FileContent, ?> index : this.getAsyncState().myIndices.values()) {
                index.dispose();
            }
        }
        finally {
            this.clearState();
        }
    }

    protected void clearState() {
        super.clearState();
        this.myStateFuture = null;
        this.myState = null;
        this.myInitialized = false;
        LOG.info("StubIndexExtension-s were unloaded");
    }

    void setDataBufferingEnabled(boolean enabled) {
        AsyncState state = ProgressManager.getInstance().computeInNonCancelableSection(this::getAsyncState);
        for (UpdatableIndex<?, Void, FileContent, ?> index : state.myIndices.values()) {
            index.setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupMemoryStorage() {
        UpdatableIndex stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        stubUpdatingIndex.getLock().writeLock().lock();
        try {
            for (UpdatableIndex<?, Void, FileContent, ?> index : this.getAsyncState().myIndices.values()) {
                index.cleanupMemoryStorage();
            }
        }
        finally {
            stubUpdatingIndex.getLock().writeLock().unlock();
        }
    }

    void clearAllIndices() {
        if (!this.myInitialized) {
            this.myForcedClean.set(true);
            return;
        }
        for (UpdatableIndex<?, Void, FileContent, ?> index : this.getAsyncState().myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error(e);
                throw new RuntimeException(e);
            }
        }
    }

    <K> void removeTransientDataForFile(@NotNull StubIndexKey<K, ?> key, int inputId, Map<K, StubIdList> keys2) {
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(11);
        }
        UpdatableIndex<K, Void, FileContent, ?> index = this.getIndex(key);
        index.removeTransientDataForKeys(inputId, new MapInputDataDiffBuilder<K, StubIdList>(inputId, keys2));
    }

    @NotNull
    public Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            StubIndexImpl.$$$reportNull$$$0(12);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationResultSink";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRootDir";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initializationFailed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onExceptionInstantiatingIndex";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forceRebuild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForFile";
                break;
            }
            case 12: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class StubIndexInitialization
    extends IndexDataInitializer<AsyncState> {
        private final AsyncState state = new AsyncState();
        private final IndexVersionRegistrationSink indicesRegistrationSink = new IndexVersionRegistrationSink();

        private StubIndexInitialization() {
        }

        @Override
        @NotNull
        protected AsyncState finish() {
            this.indicesRegistrationSink.logChangedAndFullyBuiltIndices(LOG, "Following stub indices will be updated:", "Following stub indices will be built:");
            if (this.indicesRegistrationSink.hasChangedIndexes()) {
                Throwable e = new Throwable(this.indicesRegistrationSink.changedIndices());
                AppUIExecutor.onWriteThread(ModalityState.NON_MODAL).later().submit(() -> StubIndexImpl.this.forceRebuild(e));
            }
            StubIndexImpl.this.myInitialized = true;
            StubIndexImpl.this.myStateFuture.complete(this.state);
            AsyncState asyncState = this.state;
            if (asyncState == null) {
                StubIndexInitialization.$$$reportNull$$$0(0);
            }
            return asyncState;
        }

        @Override
        @NotNull
        protected Collection<ThrowableRunnable<?>> prepareTasks() {
            StubIndexExtension extension2;
            Iterator extensionsIterator = IndexInfrastructure.hasIndices() ? StubIndexExtension.EP_NAME.getIterable().iterator() : Collections.emptyIterator();
            boolean forceClean = Boolean.TRUE.booleanValue() == StubIndexImpl.this.myForcedClean.getAndSet(false);
            ArrayList tasks = new ArrayList();
            while (extensionsIterator.hasNext() && (extension2 = (StubIndexExtension)extensionsIterator.next()) != null) {
                extension2.getKey();
                tasks.add(() -> StubIndexImpl.registerIndexer(extension2, forceClean, this.state, this.indicesRegistrationSink));
            }
            ArrayList arrayList = tasks;
            if (arrayList == null) {
                StubIndexInitialization.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getInitializationFinishedMessage(AsyncState initializationResult) {
            String string2 = "Initialized stub indexes: " + initializationResult.myIndices.keySet() + ".";
            if (string2 == null) {
                StubIndexInitialization.$$$reportNull$$$0(2);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/stubs/StubIndexImpl$StubIndexInitialization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finish";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareTasks";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitializationFinishedMessage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class StubIndexStorageLayout<K>
    implements VfsAwareIndexStorageLayout<K, Void> {
        private final FileBasedIndexExtension<K, Void> myWrappedExtension;
        private final StubIndexKey<K, ?> myIndexKey;

        private StubIndexStorageLayout(FileBasedIndexExtension<K, Void> wrappedExtension, StubIndexKey<K, ?> indexKey) {
            this.myWrappedExtension = wrappedExtension;
            this.myIndexKey = indexKey;
        }

        @NotNull
        public IndexStorage<K, Void> openIndexStorage() throws IOException {
            if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
                return new InMemoryIndexStorage(this.myWrappedExtension.getKeyDescriptor());
            }
            Path storageFile = IndexInfrastructure.getStorageFile(this.myIndexKey);
            try {
                return new VfsAwareMapIndexStorage(storageFile, this.myWrappedExtension.getKeyDescriptor(), this.myWrappedExtension.getValueExternalizer(), this.myWrappedExtension.getCacheSize(), this.myWrappedExtension.keyIsUniqueForIndexedFile(), this.myWrappedExtension.traceKeyHashToVirtualFileMapping(), this.myWrappedExtension.enableWal());
            }
            catch (IOException e) {
                IOUtil.deleteAllFilesStartingWith(storageFile);
                throw e;
            }
        }

        public void clearIndexData() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class AsyncState {
        private final Map<StubIndexKey<?, ?>, UpdatableIndex<?, Void, FileContent, ?>> myIndices = CollectionFactory.createSmallMemoryFootprintMap();

        private AsyncState() {
        }
    }
}

