/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedScopesHolder
implements PersistentStateComponent<Element> {
    private NamedScope[] myScopes;
    @NonNls
    private static final String SCOPE_TAG = "scope";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String PATTERN_ATT = "pattern";
    protected final Project myProject;
    private VirtualFile myProjectBaseDir;
    private final List<ScopeListener> myScopeListeners;

    public NamedScopesHolder(@NotNull Project project2) {
        if (project2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(0);
        }
        this.myScopes = NamedScope.EMPTY_ARRAY;
        this.myScopeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
    }

    @NotNull
    public abstract String getDisplayName();

    public abstract Icon getIcon();

    public VirtualFile getProjectBaseDir() {
        if (this.myProjectBaseDir == null) {
            this.myProjectBaseDir = this.myProject.getBaseDir();
        }
        return this.myProjectBaseDir;
    }

    public void addScopeListener(@NotNull ScopeListener scopeListener, @NotNull Disposable parentDisposable) {
        if (scopeListener == null) {
            NamedScopesHolder.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            NamedScopesHolder.$$$reportNull$$$0(2);
        }
        this.myScopeListeners.add(scopeListener);
        Disposer.register(parentDisposable, () -> this.myScopeListeners.remove(scopeListener));
    }

    public void fireScopeListeners() {
        for (ScopeListener listener2 : this.myScopeListeners) {
            listener2.scopesChanged();
        }
    }

    public NamedScope @NotNull [] getScopes() {
        List<NamedScope> list2 = this.getPredefinedScopes();
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>(list2.size() + this.myScopes.length);
        scopes.addAll(list2);
        Collections.addAll(scopes, this.myScopes);
        NamedScope[] namedScopeArray = scopes.toArray(NamedScope.EMPTY_ARRAY);
        if (namedScopeArray == null) {
            NamedScopesHolder.$$$reportNull$$$0(3);
        }
        return namedScopeArray;
    }

    public NamedScope @NotNull [] getEditableScopes() {
        if (this.myScopes == null) {
            NamedScopesHolder.$$$reportNull$$$0(4);
        }
        return this.myScopes;
    }

    public void removeAllSets() {
        this.myScopes = NamedScope.EMPTY_ARRAY;
        this.fireScopeListeners();
    }

    public void setScopes(NamedScope @NotNull [] scopes) {
        if (scopes == null) {
            NamedScopesHolder.$$$reportNull$$$0(5);
        }
        if (ArrayUtil.contains(null, scopes)) {
            throw new IllegalArgumentException("Must not pass null scopes, got: " + Arrays.toString(scopes));
        }
        this.myScopes = (NamedScope[])scopes.clone();
        this.fireScopeListeners();
    }

    public void addScope(@NotNull NamedScope scope) {
        if (scope == null) {
            NamedScopesHolder.$$$reportNull$$$0(6);
        }
        this.myScopes = ArrayUtil.append(this.myScopes, scope);
        this.fireScopeListeners();
    }

    @Nullable
    public static NamedScope getScope(@NotNull Project project2, @NonNls String scopeName) {
        if (project2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(7);
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project2)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    public static NamedScopesHolder @NotNull [] getAllNamedScopeHolders(@NotNull Project project2) {
        if (project2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(8);
        }
        NamedScopesHolder[] namedScopesHolderArray = new NamedScopesHolder[]{NamedScopeManager.getInstance(project2), DependencyValidationManager.getInstance(project2)};
        if (namedScopesHolderArray == null) {
            NamedScopesHolder.$$$reportNull$$$0(9);
        }
        return namedScopesHolderArray;
    }

    @Contract(value="_,_,!null -> !null")
    public static NamedScopesHolder getHolder(Project project2, String scopeId, NamedScopesHolder defaultHolder) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project2)) {
            NamedScope scope = holder.getScope(scopeId);
            if (scope == null) continue;
            return holder;
        }
        return defaultHolder;
    }

    @NotNull
    private static Element writeScope(@NotNull NamedScope scope) {
        if (scope == null) {
            NamedScopesHolder.$$$reportNull$$$0(10);
        }
        Element setElement = new Element(SCOPE_TAG);
        setElement.setAttribute(NAME_ATT, scope.getScopeId());
        PackageSet packageSet = scope.getValue();
        setElement.setAttribute(PATTERN_ATT, packageSet != null ? packageSet.getText() : "");
        Element element2 = setElement;
        if (element2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(11);
        }
        return element2;
    }

    @NotNull
    private NamedScope readScope(@NotNull Element setElement) {
        PackageSet set2;
        if (setElement == null) {
            NamedScopesHolder.$$$reportNull$$$0(12);
        }
        String name2 = setElement.getAttributeValue(NAME_ATT);
        String attributeValue = setElement.getAttributeValue(PATTERN_ATT);
        try {
            set2 = PackageSetFactory.getInstance().compile(attributeValue);
        }
        catch (ParsingException e) {
            set2 = new InvalidPackageSet(attributeValue);
        }
        return this.createScope(name2, set2);
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            NamedScopesHolder.$$$reportNull$$$0(13);
        }
        List<Element> sets = state.getChildren(SCOPE_TAG);
        NamedScope[] scopes = new NamedScope[sets.size()];
        for (int i = 0; i < sets.size(); ++i) {
            Element set2 = sets.get(i);
            scopes[i] = this.readScope(set2);
        }
        this.myScopes = scopes;
        this.fireScopeListeners();
    }

    @Override
    @NotNull
    public Element getState() {
        Element element2 = new Element("state");
        for (NamedScope myScope : this.myScopes) {
            element2.addContent(NamedScopesHolder.writeScope(myScope));
        }
        Element element3 = element2;
        if (element3 == null) {
            NamedScopesHolder.$$$reportNull$$$0(14);
        }
        return element3;
    }

    @Nullable
    public NamedScope getScope(@Nullable @NonNls String scopeId) {
        if (scopeId == null) {
            return null;
        }
        for (NamedScope scope : this.myScopes) {
            if (!scopeId.equals(scope.getScopeId())) continue;
            return scope;
        }
        return this.getPredefinedScope(scopeId);
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        List<NamedScope> list2 = Collections.emptyList();
        if (list2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @Nullable
    public NamedScope getPredefinedScope(@NotNull String name2) {
        if (name2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(16);
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(17);
        }
        return project2;
    }

    @NotNull
    public final NamedScope createScope(@NotNull String name2, @Nullable PackageSet value) {
        if (name2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(18);
        }
        return new NamedScope(name2, () -> name2, this.getIcon(), value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/NamedScopesHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCOPE_TAG;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATT;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/NamedScopesHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableScopes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNamedScopeHolders";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedScopes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addScopeListener";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setScopes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllNamedScopeHolders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ScopeListener {
        public void scopesChanged();
    }
}

