/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAwareVirtualFile;
import com.intellij.psi.search.ProjectScope;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(@NotNull Project project2, @NotNull FileIndexFacade fileIndex) {
        if (project2 == null) {
            ProjectScopeImpl.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            ProjectScopeImpl.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myFileIndex = fileIndex;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectScopeImpl.$$$reportNull$$$0(2);
        }
        if (file2 instanceof ProjectAwareVirtualFile) {
            return ((ProjectAwareVirtualFile)((Object)file2)).isInProject(Objects.requireNonNull(this.getProject()));
        }
        return this.myFileIndex.isInProjectScope(file2);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            ProjectScopeImpl.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string2 = ProjectScope.getProjectFilesScopeName();
        if (string2 == null) {
            ProjectScopeImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Collection<UnloadedModuleDescription> collection = this.myFileIndex.getUnloadedModuleDescriptions();
        if (collection == null) {
            ProjectScopeImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(6);
        }
        if (scope == this || !scope.isSearchInLibraries()) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                ProjectScopeImpl.$$$reportNull$$$0(7);
            }
            return projectScopeImpl;
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(9);
        }
        if (scope == this) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                ProjectScopeImpl.$$$reportNull$$$0(10);
            }
            return projectScopeImpl;
        }
        if (!scope.isSearchInLibraries()) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                ProjectScopeImpl.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/ProjectScopeImpl";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/ProjectScopeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

