/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.OpenFilesScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.EditorSelectionLocalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class PredefinedSearchScopeProviderImpl
extends PredefinedSearchScopeProvider {
    private static final Logger LOG = Logger.getInstance(PredefinedSearchScopeProviderImpl.class);

    @NotNull
    @Nls
    public static String getRecentlyViewedFilesScopeName() {
        String string2 = IdeBundle.message((String)"scope.recent.files", (Object[])new Object[0]);
        if (string2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    @Nls
    public static String getRecentlyChangedFilesScopeName() {
        String string2 = IdeBundle.message((String)"scope.recent.modified.files", (Object[])new Object[0]);
        if (string2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    @Nls
    public static String getCurrentFileScopeName() {
        String string2 = IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]);
        if (string2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public List<SearchScope> getPredefinedScopes(@NotNull Project project2, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean currentSelection, boolean usageView, boolean showEmptyScopes) {
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(3);
        }
        ScopeCollectionContext context2 = ScopeCollectionContext.collectContext(project2, dataContext, suggestSearchInLibs, prevSearchFiles, usageView, showEmptyScopes);
        Collection<SearchScope> result2 = context2.result;
        result2.addAll(context2.collectRestScopes(project2, currentSelection, usageView, showEmptyScopes));
        return new ArrayList<SearchScope>(result2);
    }

    @Override
    public Promise<List<SearchScope>> getPredefinedScopesAsync(@NotNull Project project2, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean currentSelection, boolean usageView, boolean showEmptyScopes) {
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(4);
        }
        ScopeCollectionContext context2 = ScopeCollectionContext.collectContext(project2, dataContext, suggestSearchInLibs, prevSearchFiles, usageView, showEmptyScopes);
        AsyncPromise promise = new AsyncPromise();
        ReadAction.nonBlocking(() -> context2.collectRestScopes(project2, currentSelection, usageView, showEmptyScopes)).expireWith(project2).finishOnUiThread(ModalityState.any(), backgroundResult -> {
            Collection<SearchScope> result2 = context2.result;
            result2.addAll((Collection<SearchScope>)backgroundResult);
            promise.setResult(new ArrayList<SearchScope>(result2));
        }).submit(AppExecutorUtil.getAppExecutorService());
        return promise;
    }

    private static Collection<SearchScope> getScopesFromUsageView(@NotNull Project project2, boolean prevSearchFiles) {
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(5);
        }
        LinkedHashSet<SearchScope> scopes = new LinkedHashSet<SearchScope>();
        UsageView selectedUsageView = UsageViewManager.getInstance((Project)project2).getSelectedUsageView();
        if (selectedUsageView != null && !selectedUsageView.isSearchInProgress()) {
            final HashSet usages = new HashSet(selectedUsageView.getUsages());
            usages.removeAll(selectedUsageView.getExcludedUsages());
            if (prevSearchFiles) {
                Set<VirtualFile> files2 = PredefinedSearchScopeProviderImpl.collectFiles(usages, true);
                if (!files2.isEmpty()) {
                    GlobalSearchScope prev = new GlobalSearchScope(project2){
                        private Set<VirtualFile> myFiles;

                        @Override
                        @NotNull
                        public String getDisplayName() {
                            String string2 = IdeBundle.message((String)"scope.files.in.previous.search.result", (Object[])new Object[0]);
                            if (string2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string2;
                        }

                        @Override
                        public synchronized boolean contains(@NotNull VirtualFile file2) {
                            if (file2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (this.myFiles == null) {
                                this.myFiles = PredefinedSearchScopeProviderImpl.collectFiles(usages, false);
                            }
                            return this.myFiles.contains(file2);
                        }

                        @Override
                        public boolean isSearchInModuleContent(@NotNull Module aModule) {
                            if (aModule == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return true;
                        }

                        @Override
                        public boolean isSearchInLibraries() {
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string2;
                            switch (n) {
                                default: {
                                    string2 = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 2;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    n2 = 3;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$1";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "file";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "aModule";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getDisplayName";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "contains";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "isSearchInModuleContent";
                                    break;
                                }
                            }
                            String string3 = String.format(string2, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalStateException(string3);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    runtimeException = new IllegalArgumentException(string3);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    };
                    scopes.add(prev);
                }
            } else {
                ArrayList<PsiElement> results = new ArrayList<PsiElement>(usages.size());
                for (Usage usage2 : usages) {
                    PsiElement element2;
                    if (!(usage2 instanceof PsiElementUsage) || (element2 = ((PsiElementUsage)usage2).getElement()) == null || !element2.isValid() || element2.getContainingFile() == null) continue;
                    results.add(element2);
                }
                if (!results.isEmpty()) {
                    scopes.add(new LocalSearchScope(PsiUtilCore.toPsiElementArray(results), IdeBundle.message((String)"scope.previous.search.results", (Object[])new Object[0])));
                }
            }
        }
        return scopes;
    }

    private static PsiFile fillFromDataContext(@Nullable DataContext dataContext, Collection<SearchScope> result2, PsiFile psiFile) {
        PsiFile currentFile = psiFile;
        if (dataContext != null) {
            PsiElement dataContextElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (dataContextElement == null) {
                dataContextElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            if (dataContextElement == null && psiFile != null) {
                dataContextElement = psiFile;
            }
            if (dataContextElement != null) {
                if (!PlatformUtils.isCidr() && !PlatformUtils.isRider()) {
                    Module module = ModuleUtilCore.findModuleForPsiElement(dataContextElement);
                    if (module == null) {
                        module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
                    }
                    if (module != null && !ModuleType.isInternal((Module)module)) {
                        result2.add(module.getModuleScope());
                    }
                }
                if (currentFile == null) {
                    currentFile = dataContextElement.getContainingFile();
                }
            }
        }
        return currentFile;
    }

    private static void addHierarchyScope(@NotNull Project project2, Collection<? super SearchScope> result2) {
        HierarchyBrowserBase hierarchyBrowserBase;
        PsiElement[] elements;
        ToolWindow toolWindow;
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(6);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow("Hierarchy")) == null) {
            return;
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Content content2 = contentManager.getSelectedContent();
        if (content2 == null) {
            return;
        }
        String name2 = content2.getDisplayName();
        JComponent component2 = content2.getComponent();
        if (component2 instanceof DumbUnawareHider) {
            component2 = ((DumbUnawareHider)component2).getContent();
        }
        if ((elements = (hierarchyBrowserBase = (HierarchyBrowserBase)((Object)component2)).getAvailableElements()).length > 0) {
            result2.add(new LocalSearchScope(elements, LangBundle.message("predefined.search.scope.hearchy.scope.display.name", name2)));
        }
    }

    @NotNull
    public static SearchScope recentFilesScope(@NotNull Project project2, boolean changedOnly) {
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(7);
        }
        String name2 = changedOnly ? PredefinedSearchScopeProviderImpl.getRecentlyChangedFilesScopeName() : PredefinedSearchScopeProviderImpl.getRecentlyViewedFilesScopeName();
        List<VirtualFile[]> files2 = changedOnly ? IdeDocumentHistory.getInstance((Project)project2).getChangedFiles() : JBIterable.from(EditorHistoryManager.getInstance((Project)project2).getFileList()).append(FileEditorManager.getInstance(project2).getOpenFiles()).unique().toList();
        SearchScope searchScope2 = files2.isEmpty() ? LocalSearchScope.EMPTY : GlobalSearchScope.filesScope(project2, files2, name2);
        if (searchScope2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(8);
        }
        return searchScope2;
    }

    @Nullable
    public static SearchScope getSelectedFilesScope(@NotNull Project project2, @Nullable DataContext dataContext, @Nullable PsiFile currentFile) {
        VirtualFile[] filesOrDirs;
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(9);
        }
        VirtualFile[] virtualFileArray = filesOrDirs = dataContext == null ? null : (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (filesOrDirs == null || filesOrDirs.length == 0 || filesOrDirs.length == 1 && currentFile != null && filesOrDirs[0].equals(currentFile.getVirtualFile())) {
            return null;
        }
        return new SelectedFilesScope(project2, filesOrDirs);
    }

    @NotNull
    protected static Set<VirtualFile> collectFiles(Set<? extends Usage> usages, boolean findFirst) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (Usage usage2 : usages) {
            VirtualFile file2;
            PsiFile psiFile;
            PsiElement psiElement;
            if (!(usage2 instanceof PsiElementUsage) || (psiElement = ((PsiElementUsage)usage2).getElement()) == null || !psiElement.isValid() || (psiFile = psiElement.getContainingFile()) == null || (file2 = psiFile.getVirtualFile()) == null) continue;
            files2.add(file2);
            if (!findFirst) continue;
            HashSet<VirtualFile> hashSet = files2;
            if (hashSet == null) {
                PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(10);
            }
            return hashSet;
        }
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentlyViewedFilesScopeName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentlyChangedFilesScopeName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFileScopeName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "recentFilesScope";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScopes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScopesAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getScopesFromUsageView";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addHierarchyScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recentFilesScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFilesScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class SelectedFilesScope
    extends GlobalSearchScope {
        private final Set<VirtualFile> myFiles = new HashSet<VirtualFile>();
        private final Set<VirtualFile> myDirectories = new HashSet<VirtualFile>();

        SelectedFilesScope(Project project2, VirtualFile ... filesOrDirs) {
            super(project2);
            if (filesOrDirs.length == 0) {
                throw new IllegalArgumentException("array is empty");
            }
            for (VirtualFile fileOrDir : filesOrDirs) {
                if (fileOrDir.isDirectory()) {
                    this.myDirectories.add(fileOrDir);
                    continue;
                }
                this.myFiles.add(fileOrDir);
            }
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                SelectedFilesScope.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                SelectedFilesScope.$$$reportNull$$$0(1);
            }
            for (VirtualFile virtualFile2 : this.myFiles) {
                if (!virtualFile2.equals(file2)) continue;
                return true;
            }
            return VfsUtilCore.isUnder(file2, this.myDirectories);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myFiles.isEmpty()) {
                String string2 = IdeBundle.message((String)"scope.selected.directories", (Object[])new Object[]{this.myDirectories.size()});
                if (string2 == null) {
                    SelectedFilesScope.$$$reportNull$$$0(2);
                }
                return string2;
            }
            if (this.myDirectories.isEmpty()) {
                String string3 = IdeBundle.message((String)"scope.selected.files", (Object[])new Object[]{this.myFiles.size()});
                if (string3 == null) {
                    SelectedFilesScope.$$$reportNull$$$0(3);
                }
                return string3;
            }
            String string4 = IdeBundle.message((String)"scope.selected.files.and.directories", (Object[])new Object[]{this.myFiles.size(), this.myDirectories.size()});
            if (string4 == null) {
                SelectedFilesScope.$$$reportNull$$$0(4);
            }
            return string4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$SelectedFilesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$SelectedFilesScope";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ScopeCollectionContext {
        private final PsiFile psiFile;
        private final Editor selectedTextEditor;
        private final Collection<SearchScope> scopesFromUsageView;
        private final PsiFile currentFile;
        private final SearchScope selectedFilesScope;
        private final Collection<SearchScope> result;

        private ScopeCollectionContext(PsiFile psiFile, Editor selectedTextEditor, Collection<SearchScope> scopesFromUsageView, PsiFile currentFile, SearchScope selectedFilesScope, Collection<SearchScope> result2) {
            this.psiFile = psiFile;
            this.selectedTextEditor = selectedTextEditor;
            this.scopesFromUsageView = scopesFromUsageView;
            this.currentFile = currentFile;
            this.selectedFilesScope = selectedFilesScope;
            this.result = result2;
        }

        static ScopeCollectionContext collectContext(@NotNull Project project2, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean usageView, boolean showEmptyScopes) {
            if (project2 == null) {
                ScopeCollectionContext.$$$reportNull$$$0(0);
            }
            LinkedHashSet<SearchScope> result2 = new LinkedHashSet<SearchScope>();
            result2.add(GlobalSearchScope.everythingScope(project2));
            result2.add(GlobalSearchScope.projectScope(project2));
            if (suggestSearchInLibs) {
                result2.add(GlobalSearchScope.allScope(project2));
            }
            DataContext adjustedContext = dataContext != null ? dataContext : SimpleDataContext.getProjectContext((Project)project2);
            for (SearchScopeProvider each : SearchScopeProvider.EP_NAME.getExtensions()) {
                result2.addAll(each.getGeneralSearchScopes(project2, adjustedContext));
            }
            if (ModuleUtil.hasTestSourceRoots(project2)) {
                result2.add(GlobalSearchScopesCore.projectProductionScope(project2));
                result2.add(GlobalSearchScopesCore.projectTestScope(project2));
            }
            result2.add(ScratchesSearchScope.getScratchesScope(project2));
            SearchScope recentFilesScope = PredefinedSearchScopeProviderImpl.recentFilesScope(project2, false);
            ContainerUtil.addIfNotNull(result2, !SearchScope.isEmptyScope(recentFilesScope) ? recentFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, PredefinedSearchScopeProviderImpl.getRecentlyViewedFilesScopeName()) : null));
            SearchScope recentModFilesScope = PredefinedSearchScopeProviderImpl.recentFilesScope(project2, true);
            ContainerUtil.addIfNotNull(result2, !SearchScope.isEmptyScope(recentModFilesScope) ? recentModFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, PredefinedSearchScopeProviderImpl.getRecentlyChangedFilesScopeName()) : null));
            GlobalSearchScope openFilesScope = GlobalSearchScopes.openFilesScope(project2);
            ContainerUtil.addIfNotNull(result2, openFilesScope != GlobalSearchScope.EMPTY_SCOPE ? openFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, OpenFilesScope.getNameText()) : null));
            Editor selectedTextEditor = ApplicationManager.getApplication().isDispatchThread() ? FileEditorManager.getInstance(project2).getSelectedTextEditor() : null;
            PsiFile psiFile = selectedTextEditor == null ? null : PsiDocumentManager.getInstance(project2).getPsiFile(selectedTextEditor.getDocument());
            PsiFile currentFile = PredefinedSearchScopeProviderImpl.fillFromDataContext(dataContext, result2, psiFile);
            SearchScope selectedFilesScope = PredefinedSearchScopeProviderImpl.getSelectedFilesScope(project2, dataContext, currentFile);
            List<SearchScope> scopesFromUsageView = usageView ? PredefinedSearchScopeProviderImpl.getScopesFromUsageView(project2, prevSearchFiles) : Collections.emptyList();
            return new ScopeCollectionContext(psiFile, selectedTextEditor, scopesFromUsageView, currentFile, selectedFilesScope, result2);
        }

        Collection<SearchScope> collectRestScopes(@NotNull Project project2, boolean currentSelection, boolean usageView, boolean showEmptyScopes) {
            SelectionModel selectionModel;
            if (project2 == null) {
                ScopeCollectionContext.$$$reportNull$$$0(1);
            }
            LinkedHashSet<SearchScope> backgroundResult = new LinkedHashSet<SearchScope>();
            if (project2.isDisposed() || this.psiFile != null && !this.psiFile.isValid() || this.selectedTextEditor != null && this.selectedTextEditor.isDisposed()) {
                return backgroundResult;
            }
            if (this.currentFile != null || showEmptyScopes) {
                PsiElement[] psiElementArray;
                if (this.currentFile != null) {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = this.currentFile;
                } else {
                    psiElementArray = PsiElement.EMPTY_ARRAY;
                }
                PsiElement[] scope = psiElementArray;
                backgroundResult.add(new LocalSearchScope(scope, PredefinedSearchScopeProviderImpl.getCurrentFileScopeName()));
            }
            if (currentSelection && this.selectedTextEditor != null && this.psiFile != null && (selectionModel = this.selectedTextEditor.getSelectionModel()).hasSelection()) {
                backgroundResult.add(new EditorSelectionLocalSearchScope(this.selectedTextEditor, project2, IdeBundle.message((String)"scope.selection", (Object[])new Object[0])));
            }
            if (usageView) {
                PredefinedSearchScopeProviderImpl.addHierarchyScope(project2, backgroundResult);
                backgroundResult.addAll(this.scopesFromUsageView);
            }
            ContainerUtil.addIfNotNull(backgroundResult, this.selectedFilesScope);
            return backgroundResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$ScopeCollectionContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectRestScopes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

