/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.FileTypeNameEnumerator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.storage.AbstractIntLog;
import com.intellij.util.indexing.impl.storage.IntLog;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogFileTypeIndex
implements UpdatableIndex<FileType, Void, FileContent, Void>,
FileTypeNameEnumerator {
    private static final Logger LOG = Logger.getInstance(LogFileTypeIndex.class);
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final LogBasedIntIntIndex myPersistentLog;
    @NotNull
    private final SimpleStringPersistentEnumerator myFileTypeEnumerator;
    @NotNull
    private final ConcurrentIntObjectMap<Ref<FileType>> myId2FileTypeCache;
    @NotNull
    private final ConcurrentIntObjectMap<Ref<String>> myId2FileNameCache;
    @NotNull
    private final FileBasedIndexExtension<FileType, Void> myExtension;
    @NotNull
    private final ReadWriteLock myLock;
    @NotNull
    private final AtomicBoolean myInMemoryMode;
    @NotNull
    private final ID<FileType, Void> myIndexId;
    @NotNull
    private final MemorySnapshot mySnapshot;

    public LogFileTypeIndex(@NotNull FileBasedIndexExtension<FileType, Void> extension2) throws IOException, StorageException {
        if (extension2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(0);
        }
        this.myId2FileTypeCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myId2FileNameCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myLock = new ReentrantReadWriteLock();
        this.myInMemoryMode = new AtomicBoolean();
        this.myExtension = extension2;
        this.myIndexId = extension2.getName();
        Path storageFile = IndexInfrastructure.getStorageFile(this.myIndexId);
        this.myPersistentLog = new LogBasedIntIntIndex(new IntLog(storageFile.resolveSibling(storageFile.getFileName().toString() + ".log.index"), true, new StorageLockContext(false, true)));
        this.myFileTypeEnumerator = new SimpleStringPersistentEnumerator(IndexInfrastructure.getStorageFile(this.myIndexId).resolveSibling("fileType.enum"));
        if (this.myExtension.dependsOnFileContent()) {
            throw new IllegalArgumentException(this.myExtension.getName() + " should not depend on content");
        }
        this.myDisposable = Disposer.newDisposable();
        this.mySnapshot = LogFileTypeIndex.loadIndexToMemory(this.myPersistentLog);
    }

    public boolean processAllKeys(@NotNull Processor<? super FileType> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            LogFileTypeIndex.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            LogFileTypeIndex.$$$reportNull$$$0(2);
        }
        for (String fileTypeName : this.myFileTypeEnumerator.entries()) {
            FileType fileType = FileTypeManager.getInstance().findFileTypeByName(fileTypeName);
            if (fileType == null || processor.process(fileType)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myLock;
        if (readWriteLock == null) {
            LogFileTypeIndex.$$$reportNull$$$0(3);
        }
        return readWriteLock;
    }

    @NotNull
    public Map<FileType, Void> getIndexedFileData(int fileId) throws StorageException {
        int foundData = this.getIndexedFileTypeId(fileId);
        if (foundData == 0) {
            Map<FileType, Void> map2 = Collections.emptyMap();
            if (map2 == null) {
                LogFileTypeIndex.$$$reportNull$$$0(4);
            }
            return map2;
        }
        Map<FileType, Object> map3 = Collections.singletonMap(this.getFileTypeById(foundData), null);
        if (map3 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(5);
        }
        return map3;
    }

    public Void getFileIndexMetaData(@NotNull IndexedFile file2) {
        if (file2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(6);
        }
        return null;
    }

    public void setIndexedStateForFileOnFileIndexMetaData(int fileId, @Nullable Void data2) {
        IndexingStamp.setFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(7);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, this.myIndexId);
    }

    public void invalidateIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, this.myIndexId);
    }

    public void setUnindexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateUnindexed(fileId, this.myIndexId);
    }

    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        int indexedFileTypeId;
        block9: {
            FileIndexingState fileIndexingState;
            FileIndexingState isIndexed;
            if (file2 == null) {
                LogFileTypeIndex.$$$reportNull$$$0(8);
            }
            if ((isIndexed = IndexingStamp.isFileIndexedStateCurrent(fileId, this.myIndexId)) != FileIndexingState.UP_TO_DATE) {
                FileIndexingState fileIndexingState2 = isIndexed;
                if (fileIndexingState2 == null) {
                    LogFileTypeIndex.$$$reportNull$$$0(9);
                }
                return fileIndexingState2;
            }
            try {
                indexedFileTypeId = this.getIndexedFileTypeId(fileId);
                if (indexedFileTypeId != 0) break block9;
                fileIndexingState = isIndexed;
            }
            catch (StorageException e) {
                LOG.error(e);
                FileIndexingState fileIndexingState3 = FileIndexingState.OUT_DATED;
                if (fileIndexingState3 == null) {
                    LogFileTypeIndex.$$$reportNull$$$0(12);
                }
                return fileIndexingState3;
            }
            if (fileIndexingState == null) {
                LogFileTypeIndex.$$$reportNull$$$0(10);
            }
            return fileIndexingState;
        }
        int actualFileTypeId = this.getFileTypeId(file2.getFileType());
        FileIndexingState fileIndexingState = indexedFileTypeId == actualFileTypeId ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        if (fileIndexingState == null) {
            LogFileTypeIndex.$$$reportNull$$$0(11);
        }
        return fileIndexingState;
    }

    public long getModificationStamp() {
        return this.myPersistentLog.getModificationStamp();
    }

    public void removeTransientDataForFile(int inputId) {
    }

    @NotNull
    public IndexExtension<FileType, Void, FileContent> getExtension() {
        FileBasedIndexExtension<FileType, Void> fileBasedIndexExtension = this.myExtension;
        if (fileBasedIndexExtension == null) {
            LogFileTypeIndex.$$$reportNull$$$0(13);
        }
        return fileBasedIndexExtension;
    }

    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<FileType, Void> diffBuilder) {
        if (diffBuilder == null) {
            LogFileTypeIndex.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    public void updateWithMap(@NotNull AbstractUpdateData<FileType, Void> updateData) {
        if (updateData == null) {
            LogFileTypeIndex.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    public void setBufferingEnabled(boolean enabled) {
        this.myInMemoryMode.set(enabled);
    }

    public void cleanupMemoryStorage() {
    }

    public void cleanupForNextTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ValueContainer<Void> getData(@NotNull FileType type) throws StorageException {
        if (type == null) {
            LogFileTypeIndex.$$$reportNull$$$0(16);
        }
        int fileTypeId = this.getFileTypeId(type);
        ValueContainerImpl<Void> result2 = new ValueContainerImpl<Void>(false);
        this.myLock.readLock().lock();
        try {
            this.mySnapshot.getFileIds(fileTypeId).forEach(id2 -> result2.addValue(id2, null));
        }
        finally {
            this.myLock.readLock().unlock();
        }
        ValueContainerImpl<Void> valueContainerImpl = result2;
        if (valueContainerImpl == null) {
            LogFileTypeIndex.$$$reportNull$$$0(17);
        }
        return valueContainerImpl;
    }

    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content2) {
        Computable<Boolean> computable;
        try {
            int fileTypeId = this.getFileTypeId(content2 == null ? null : content2.getFileType());
            computable = () -> this.updateIndex(fileTypeId, inputId);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        if (computable == null) {
            LogFileTypeIndex.$$$reportNull$$$0(18);
        }
        return computable;
    }

    @NotNull
    public Computable<Boolean> prepareUpdate(int inputId, @NotNull InputData<FileType, Void> data2) {
        if (data2 == null) {
            LogFileTypeIndex.$$$reportNull$$$0(19);
        }
        throw new UnsupportedOperationException();
    }

    private FileType getFileTypeById(int id2) {
        assert (id2 < Short.MAX_VALUE) : "file type id = " + id2;
        Ref<FileType> fileType = (Ref<FileType>)this.myId2FileTypeCache.get(id2);
        if (fileType == null) {
            String fileTypeName = this.myFileTypeEnumerator.valueOf(id2);
            FileType fileTypeByName = fileTypeName == null ? null : FileTypeManager.getInstance().findFileTypeByName(fileTypeName);
            fileType = Ref.create(fileTypeByName);
            this.myId2FileTypeCache.put(id2, fileType);
        }
        return (FileType)fileType.get();
    }

    private int getIndexedFileTypeId(int fileId) throws StorageException {
        this.myLock.readLock().lock();
        try {
            int n = this.mySnapshot.getIndexedData(fileId);
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private int getFileTypeId(@Nullable FileType fileType) throws StorageException {
        if (fileType == null) {
            return 0;
        }
        try {
            return this.getFileTypeId(fileType.getName());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Boolean updateIndex(int fileTypeId, int inputId) {
        this.myLock.writeLock().lock();
        try {
            if (this.myInMemoryMode.get()) {
                throw new IllegalStateException("file type index should not be updated for unsaved changes");
            }
            boolean snapshotModified = this.mySnapshot.addData(fileTypeId, inputId);
            if (snapshotModified) {
                this.myPersistentLog.addData(fileTypeId, inputId);
            }
        }
        catch (StorageException e) {
            LOG.error(e);
            Boolean bl = Boolean.FALSE;
            Boolean bl2 = bl;
            if (bl2 == null) {
                LogFileTypeIndex.$$$reportNull$$$0(20);
            }
            return bl2;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
        Boolean bl = Boolean.TRUE;
        if (bl == null) {
            LogFileTypeIndex.$$$reportNull$$$0(21);
        }
        return bl;
    }

    public void flush() throws StorageException {
        try {
            this.myPersistentLog.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public void clear() throws StorageException {
        this.mySnapshot.clear();
        this.myPersistentLog.clear();
    }

    public void dispose() {
        Disposer.dispose(this.myDisposable);
        try {
            this.myPersistentLog.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getFileTypeId(String name2) throws IOException {
        return this.myFileTypeEnumerator.enumerate(name2);
    }

    @Override
    public String getFileTypeName(int id2) {
        assert (id2 < Short.MAX_VALUE);
        Ref<String> fileType = (Ref<String>)this.myId2FileNameCache.get(id2);
        if (fileType == null) {
            String fileTypeName = this.myFileTypeEnumerator.valueOf(id2);
            fileType = Ref.create(fileTypeName);
            this.myId2FileNameCache.put(id2, fileType);
        }
        return (String)fileType.get();
    }

    @NotNull
    private static MemorySnapshot loadIndexToMemory(@NotNull LogBasedIntIntIndex intLogIndex) throws StorageException {
        if (intLogIndex == null) {
            LogFileTypeIndex.$$$reportNull$$$0(22);
        }
        Int2ObjectOpenHashMap<BitSet> invertedIndex = new Int2ObjectOpenHashMap<BitSet>();
        IntArrayList forwardIndex = new IntArrayList();
        intLogIndex.processEntries((data2, inputId) -> {
            if (data2 != 0) {
                LogFileTypeIndex.setForwardIndexData(forwardIndex, data2, inputId);
                invertedIndex.computeIfAbsent(data2, __ -> new BitSet()).set(inputId);
            } else {
                int previousData = MemorySnapshot.getDataFromForwardIndex(forwardIndex, inputId);
                if (previousData != 0) {
                    forwardIndex.set(inputId, 0);
                    ((BitSet)invertedIndex.get(previousData)).clear(inputId);
                }
            }
            return true;
        });
        return new MemorySnapshot(invertedIndex, forwardIndex);
    }

    private static boolean setForwardIndexData(@NotNull IntList forwardIndex, int data2, int inputId) {
        if (forwardIndex == null) {
            LogFileTypeIndex.$$$reportNull$$$0(23);
        }
        if (inputId >= forwardIndex.size()) {
            forwardIndex.size((inputId + 1) * 3 / 2);
        }
        return data2 != forwardIndex.set(inputId, data2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/LogFileTypeIndex";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intLogIndex";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileIndexMetaData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "prepareUpdate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadIndexToMemory";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setForwardIndexData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface IntSeq {
        public static final IntSeq EMPTY = new IntSeq(){

            @Override
            public void forEach(@NotNull IntConsumer consumer) {
                if (consumer == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            @NotNull
            public IntSeq copy() {
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "copy";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "forEach";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        public void forEach(@NotNull IntConsumer var1);

        @NotNull
        public IntSeq copy();

        public static class FromBitSet
        implements IntSeq {
            private final BitSet myBitSet;

            private FromBitSet(@NotNull BitSet set2) {
                if (set2 == null) {
                    FromBitSet.$$$reportNull$$$0(0);
                }
                this.myBitSet = set2;
            }

            @Override
            public void forEach(@NotNull IntConsumer consumer) {
                if (consumer == null) {
                    FromBitSet.$$$reportNull$$$0(1);
                }
                this.myBitSet.stream().forEach(consumer);
            }

            @Override
            @NotNull
            public IntSeq copy() {
                return new FromBitSet((BitSet)this.myBitSet.clone());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$IntSeq$FromBitSet";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "forEach";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MemorySnapshot
    implements IntIntIndex {
        @NotNull
        private final Int2ObjectMap<BitSet> myInvertedIndex;
        @NotNull
        private final IntList myForwardIndex;

        private MemorySnapshot(@NotNull Int2ObjectMap<BitSet> invertedIndex, @NotNull IntList forwardIndex) {
            if (invertedIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(0);
            }
            if (forwardIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(1);
            }
            this.myInvertedIndex = invertedIndex;
            this.myForwardIndex = forwardIndex;
        }

        @Override
        public synchronized boolean addData(int data2, int inputId) {
            int indexedData = this.getIndexedData(inputId);
            if (indexedData != 0) {
                BitSet indexedSet = (BitSet)this.myInvertedIndex.get(indexedData);
                assert (indexedSet != null);
                indexedSet.clear(inputId);
            }
            boolean updated = LogFileTypeIndex.setForwardIndexData(this.myForwardIndex, data2, inputId);
            if (data2 != 0) {
                this.myInvertedIndex.computeIfAbsent(data2, __ -> new BitSet()).set(inputId);
            }
            return updated;
        }

        @NotNull
        public synchronized IntSeq getFileIds(int data2) {
            BitSet fileIds = (BitSet)this.myInvertedIndex.get(data2);
            return fileIds == null ? IntSeq.EMPTY : new IntSeq.FromBitSet(fileIds);
        }

        public synchronized int getIndexedData(int inputId) {
            return MemorySnapshot.getDataFromForwardIndex(this.myForwardIndex, inputId);
        }

        private static int getDataFromForwardIndex(@NotNull IntList forwardIndex, int inputId) {
            if (forwardIndex == null) {
                MemorySnapshot.$$$reportNull$$$0(2);
            }
            if (forwardIndex.size() <= inputId) {
                return 0;
            }
            return forwardIndex.getInt(inputId);
        }

        private void clear() {
            this.myInvertedIndex.clear();
            this.myForwardIndex.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invertedIndex";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forwardIndex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$MemorySnapshot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataFromForwardIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LogBasedIntIntIndex
    implements IntIntIndex {
        private final AbstractIntLog myLog;

        private LogBasedIntIntIndex(@NotNull AbstractIntLog log) {
            if (log == null) {
                LogBasedIntIntIndex.$$$reportNull$$$0(0);
            }
            this.myLog = log;
        }

        @Override
        public boolean addData(int data2, int inputId) throws StorageException {
            this.myLog.addData(data2, inputId);
            return true;
        }

        private void processEntries(@NotNull AbstractIntLog.IntLogEntryProcessor processor) throws StorageException {
            if (processor == null) {
                LogBasedIntIntIndex.$$$reportNull$$$0(1);
            }
            this.myLog.processEntries(processor);
        }

        public long getModificationStamp() {
            return this.myLog.getModificationStamp();
        }

        public void clear() {
            this.myLog.clear();
        }

        public void close() throws IOException {
            this.myLog.close();
        }

        public void flush() throws IOException {
            this.myLog.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "log";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/LogFileTypeIndex$LogBasedIntIntIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEntries";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface IntIntIndex {
        public boolean addData(int var1, int var2) throws StorageException;
    }
}

