/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project2) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(0);
        }
        return new ProductionScopeFilter(project2);
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project2) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(1);
        }
        return new TestScopeFilter(project2);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(2);
        }
        return new DirectoryScope(directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project2, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(4);
        }
        return new DirectoryScope(project2, directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project2, boolean withSubdirectories, VirtualFile ... directories) {
        HashSet<VirtualFile> dirSet;
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(5);
        }
        if (directories == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(6);
        }
        if ((dirSet = ContainerUtil.newHashSet(directories)).isEmpty()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScopesCore.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        if (dirSet.size() == 1) {
            return GlobalSearchScopesCore.directoryScope(project2, (VirtualFile)dirSet.iterator().next(), withSubdirectories);
        }
        return new DirectoriesScope(project2, withSubdirectories ? Collections.emptySet() : dirSet, withSubdirectories ? dirSet : Collections.emptySet());
    }

    @NotNull
    public static GlobalSearchScope filterScope(@NotNull Project project2, @NotNull NamedScope set2) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(8);
        }
        if (set2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(9);
        }
        return new FilterScopeAdapter(project2, set2);
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static String getProjectProductionFilesScopeName() {
        String string2 = AnalysisBundle.message("psi.search.scope.production.files", new Object[0]);
        if (string2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static String getProjectTestFilesScopeName() {
        String string2 = AnalysisBundle.message("psi.search.scope.test.files", new Object[0]);
        if (string2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "directoriesScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectProductionFilesScopeName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectTestFilesScopeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectProductionScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "projectTestScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "directoryScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "directoriesScope";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class DirectoriesScope
    extends GlobalSearchScope {
        private final Set<? extends VirtualFile> myDirectories;
        private final Set<? extends VirtualFile> myDirectoriesWithSubdirectories;

        private DirectoriesScope(@NotNull Project project2, @NotNull Set<? extends VirtualFile> directories, @NotNull Set<? extends VirtualFile> directoriesWithSubdirectories) {
            if (project2 == null) {
                DirectoriesScope.$$$reportNull$$$0(0);
            }
            if (directories == null) {
                DirectoriesScope.$$$reportNull$$$0(1);
            }
            if (directoriesWithSubdirectories == null) {
                DirectoriesScope.$$$reportNull$$$0(2);
            }
            super(project2);
            this.myDirectories = directories;
            this.myDirectoriesWithSubdirectories = directoriesWithSubdirectories;
            if (directories.size() + directoriesWithSubdirectories.size() < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: directories " + directories + ", directories with subdirectories " + directoriesWithSubdirectories);
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                DirectoriesScope.$$$reportNull$$$0(3);
            }
            return this.myDirectories.contains(file2) || this.myDirectories.contains(file2.getParent()) || VfsUtilCore.isUnder(file2, this.myDirectoriesWithSubdirectories);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoriesScope.$$$reportNull$$$0(4);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @NonNls
        public String toString() {
            return "Directories scope: directories " + this.myDirectories + ", directories with subdirectories " + this.myDirectoriesWithSubdirectories;
        }

        @Override
        public int calcHashCode() {
            int result2 = this.myDirectories.hashCode();
            result2 = result2 * 31 + this.myDirectoriesWithSubdirectories.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoriesScope && this.myDirectories.equals(((DirectoriesScope)obj).myDirectories) && this.myDirectoriesWithSubdirectories.equals(((DirectoriesScope)obj).myDirectoriesWithSubdirectories);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoriesScope.$$$reportNull$$$0(5);
            }
            if (this.equals(scope)) {
                DirectoriesScope directoriesScope = this;
                if (directoriesScope == null) {
                    DirectoriesScope.$$$reportNull$$$0(6);
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.myDirectories.contains(other.myDirectory) || VfsUtilCore.isUnder(other.myDirectory, this.myDirectoriesWithSubdirectories)) {
                    DirectoriesScope directoriesScope = this;
                    if (directoriesScope == null) {
                        DirectoriesScope.$$$reportNull$$$0(7);
                    }
                    return directoriesScope;
                }
                Set<? extends VirtualFile> directories = this.myDirectories;
                Set<? extends VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (other.myWithSubdirectories) {
                    HashSet<? extends VirtualFile> copy = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    copy.add(other.myDirectory);
                    directoriesWithSubdirectories = copy;
                } else {
                    HashSet<? extends VirtualFile> copy = new HashSet<VirtualFile>(directories);
                    copy.add(other.myDirectory);
                    directories = copy;
                }
                return new DirectoriesScope(Objects.requireNonNull(this.getProject()), directories, directoriesWithSubdirectories);
            }
            if (scope instanceof DirectoriesScope) {
                HashSet<? extends VirtualFile> copy;
                DirectoriesScope other = (DirectoriesScope)scope;
                Set<? extends VirtualFile> directories = this.myDirectories;
                Set<? extends VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (!other.myDirectories.isEmpty()) {
                    copy = new HashSet<VirtualFile>(directories);
                    copy.addAll(other.myDirectories);
                    directories = copy;
                }
                if (!other.myDirectoriesWithSubdirectories.isEmpty()) {
                    copy = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    copy.addAll(other.myDirectoriesWithSubdirectories);
                    directoriesWithSubdirectories = copy;
                }
                return new DirectoriesScope(Objects.requireNonNull(this.getProject()), directories, directoriesWithSubdirectories);
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoriesScope.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.size() + this.myDirectoriesWithSubdirectories.size() == 1) {
                Set<? extends VirtualFile> dirs = this.myDirectories.size() == 1 ? this.myDirectories : this.myDirectoriesWithSubdirectories;
                VirtualFile root = Objects.requireNonNull(ContainerUtil.getFirstItem(dirs));
                String string2 = AnalysisBundle.message("display.name.directory.0", root.getName());
                if (string2 == null) {
                    DirectoriesScope.$$$reportNull$$$0(9);
                }
                return string2;
            }
            Iterable<? extends VirtualFile> allDirs = ContainerUtil.concat(this.myDirectories, this.myDirectoriesWithSubdirectories);
            String string3 = AnalysisBundle.message("display.name.directories.0", StringUtil.join(allDirs, file2 -> "'" + file2.getName() + "'", ", "));
            if (string3 == null) {
                DirectoriesScope.$$$reportNull$$$0(10);
            }
            return string3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directoriesWithSubdirectories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            if (psiDirectory == null) {
                DirectoryScope.$$$reportNull$$$0(0);
            }
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        public DirectoryScope(@NotNull Project project2, @NotNull VirtualFile directory, boolean withSubdirectories) {
            if (project2 == null) {
                DirectoryScope.$$$reportNull$$$0(1);
            }
            if (directory == null) {
                DirectoryScope.$$$reportNull$$$0(2);
            }
            super(project2);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @Override
        @NotNull
        public Collection<ModelBranch> getModelBranchesAffectingScope() {
            Set<ModelBranch> set2 = ContainerUtil.createMaybeSingletonSet(ModelBranch.getFileBranch(this.myDirectory));
            if (set2 == null) {
                DirectoryScope.$$$reportNull$$$0(3);
            }
            return set2;
        }

        @NotNull
        public VirtualFile getDirectory() {
            VirtualFile virtualFile2 = this.myDirectory;
            if (virtualFile2 == null) {
                DirectoryScope.$$$reportNull$$$0(4);
            }
            return virtualFile2;
        }

        public boolean isWithSubdirectories() {
            return this.myWithSubdirectories;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                DirectoryScope.$$$reportNull$$$0(5);
            }
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, file2, false) : this.myDirectory.equals(file2) || this.myDirectory.equals(file2.getParent());
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoryScope.$$$reportNull$$$0(6);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @NonNls
        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int calcHashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryScope && this.myDirectory.equals(((DirectoryScope)obj).myDirectory) && this.myWithSubdirectories == ((DirectoryScope)obj).myWithSubdirectories;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoryScope.$$$reportNull$$$0(7);
            }
            if (this.equals(scope)) {
                DirectoryScope directoryScope = this;
                if (directoryScope == null) {
                    DirectoryScope.$$$reportNull$$$0(8);
                }
                return directoryScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.containsScope(other)) {
                    DirectoryScope directoryScope = this;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(9);
                    }
                    return directoryScope;
                }
                if (other.containsScope(this)) {
                    DirectoryScope directoryScope = other;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(10);
                    }
                    return directoryScope;
                }
                return new DirectoriesScope(Objects.requireNonNull(this.getProject()), DirectoryScope.union(!this.myWithSubdirectories, this.myDirectory, !other.myWithSubdirectories, other.myDirectory), DirectoryScope.union(this.myWithSubdirectories, this.myDirectory, other.myWithSubdirectories, other.myDirectory));
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoryScope.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }

        private boolean containsScope(DirectoryScope other) {
            return this.myWithSubdirectories ? this.contains(other.myDirectory) : this.equals(other);
        }

        @NotNull
        private static Set<VirtualFile> union(boolean addDir1, @NotNull VirtualFile dir1, boolean addDir2, @NotNull VirtualFile dir2) {
            if (dir1 == null) {
                DirectoryScope.$$$reportNull$$$0(12);
            }
            if (dir2 == null) {
                DirectoryScope.$$$reportNull$$$0(13);
            }
            if (addDir1 && addDir2) {
                HashSet<VirtualFile> hashSet = ContainerUtil.newHashSet(dir1, dir2);
                if (hashSet == null) {
                    DirectoryScope.$$$reportNull$$$0(14);
                }
                return hashSet;
            }
            if (addDir1) {
                Set<VirtualFile> set2 = Collections.singleton(dir1);
                if (set2 == null) {
                    DirectoryScope.$$$reportNull$$$0(15);
                }
                return set2;
            }
            if (addDir2) {
                Set<VirtualFile> set3 = Collections.singleton(dir2);
                if (set3 == null) {
                    DirectoryScope.$$$reportNull$$$0(16);
                }
                return set3;
            }
            Set<VirtualFile> set4 = Collections.emptySet();
            if (set4 == null) {
                DirectoryScope.$$$reportNull$$$0(17);
            }
            return set4;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = AnalysisBundle.message("display.name.directory.0", this.myDirectory.getName());
            if (string2 == null) {
                DirectoryScope.$$$reportNull$$$0(18);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir1";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModelBranchesAffectingScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectory";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "union";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "union";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TestScopeFilter
    extends GlobalSearchScope {
        private TestScopeFilter(@NotNull Project project2) {
            if (project2 == null) {
                TestScopeFilter.$$$reportNull$$$0(0);
            }
            super(project2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                TestScopeFilter.$$$reportNull$$$0(1);
            }
            return TestSourcesFilter.isTestSources(file2, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(3);
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = GlobalSearchScopesCore.getProjectTestFilesScopeName();
            if (string2 == null) {
                TestScopeFilter.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project2) {
            if (project2 == null) {
                ProductionScopeFilter.$$$reportNull$$$0(0);
            }
            super(project2);
            this.myFileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ProductionScopeFilter.$$$reportNull$$$0(1);
            }
            return this.myFileIndex.isInSourceContent(file2) && !TestSourcesFilter.isTestSources(file2, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(3);
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection<UnloadedModuleDescription> collection = ModuleManager.getInstance(Objects.requireNonNull(this.getProject())).getUnloadedModuleDescriptions();
            if (collection == null) {
                ProductionScopeFilter.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = GlobalSearchScopesCore.getProjectProductionFilesScopeName();
            if (string2 == null) {
                ProductionScopeFilter.$$$reportNull$$$0(5);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;
        @NotNull
        private final GlobalSearchScope myAllScope;

        private FilterScopeAdapter(@NotNull Project project2, @NotNull NamedScope set2) {
            if (project2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(0);
            }
            if (set2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(1);
            }
            super(project2);
            this.mySet = set2;
            this.myManager = PsiManager.getInstance(project2);
            this.myAllScope = GlobalSearchScope.allScope(project2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(2);
            }
            if (!this.myAllScope.contains(file2)) {
                return false;
            }
            Project project2 = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(Objects.requireNonNull(project2));
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file2, project2, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file2);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = this.mySet.getPresentableName();
            if (string2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.mySet.getIcon();
            if (icon2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(4);
            }
            return icon2;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FilterScopeAdapter.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterScopeAdapter adapter = (FilterScopeAdapter)o;
            if (!this.mySet.equals(adapter.mySet)) {
                return false;
            }
            return this.myManager.equals(adapter.myManager);
        }

        @Override
        public int calcHashCode() {
            int result2 = super.calcHashCode();
            result2 = 31 * result2 + this.mySet.hashCode();
            result2 = 31 * result2 + this.myManager.hashCode();
            return result2;
        }

        @NonNls
        public String toString() {
            return "FilterScope adapted from " + this.mySet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

