/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.injection.ReferenceInjector;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InjectionResult
implements Supplier<InjectionResult> {
    private final PsiFile myHostFile;
    @Nullable
    final List<? extends PsiFile> files;
    @Nullable
    final List<? extends Pair<ReferenceInjector, Place>> references;
    private final long myModificationCount;

    InjectionResult(@NotNull PsiFile hostFile, @Nullable List<? extends PsiFile> files2, @Nullable List<? extends Pair<ReferenceInjector, Place>> references) {
        if (hostFile == null) {
            InjectionResult.$$$reportNull$$$0(0);
        }
        this.myHostFile = hostFile;
        this.files = files2;
        this.references = references;
        this.myModificationCount = this.calcModCount();
    }

    @Override
    public InjectionResult get() {
        return this;
    }

    boolean isEmpty() {
        return this.files == null && this.references == null;
    }

    boolean isValid() {
        block3: {
            block2: {
                if (this.files == null) break block2;
                for (PsiFile psiFile : this.files) {
                    if (psiFile.isValid()) continue;
                    return false;
                }
                break block3;
            }
            if (this.references == null) break block3;
            for (Pair<ReferenceInjector, Place> pair : this.references) {
                Place place = pair.getSecond();
                if (place.isValid()) continue;
                return false;
            }
        }
        return true;
    }

    boolean isModCountUpToDate() {
        return this.myModificationCount == this.calcModCount();
    }

    private long calcModCount() {
        return (this.myHostFile.getModificationStamp() << 32) + this.myHostFile.getManager().getModificationTracker().getModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/psi/impl/source/tree/injected/InjectionResult", "<init>"));
    }
}

