/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTracker;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTrackerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class InjectedLanguageUtil
extends InjectedLanguageUtilBase {
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = InjectedLanguageManager.FRANKENSTEIN_INJECTION;
    private static final Comparator<PsiFile> LONGEST_INJECTION_HOST_RANGE_COMPARATOR = Comparator.comparing(psiFile -> InjectedLanguageManager.getInstance(psiFile.getProject()).getInjectionHost((PsiElement)psiFile), Comparator.nullsLast(Comparator.comparingInt(PsiElement::getTextLength)));

    public static void enumerate(@NotNull DocumentWindow documentWindow, @NotNull PsiFile hostPsiFile, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement element2;
        Segment[] ranges2;
        if (documentWindow == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(0);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(1);
        }
        if (visitor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(2);
        }
        Segment rangeMarker = (ranges2 = documentWindow.getHostRanges()).length > 0 ? ranges2[0] : null;
        PsiElement psiElement = element2 = rangeMarker == null ? null : hostPsiFile.findElementAt(rangeMarker.getStartOffset());
        if (element2 != null) {
            InjectedLanguageUtil.enumerate(element2, hostPsiFile, true, visitor);
        }
    }

    @Contract(value="null,_->null;!null,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor2, @Nullable PsiFile file2) {
        if (editor2 == null || file2 == null || editor2 instanceof EditorWindow) {
            return editor2;
        }
        int offset = editor2.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor2, file2, offset);
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor2, @Nullable Caret caret, @Nullable PsiFile file2) {
        if (editor2 == null || file2 == null || editor2 instanceof EditorWindow || caret == null) {
            return editor2;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, caret, injectedFile);
    }

    public static Caret getCaretForInjectedLanguageNoCommit(@Nullable Caret caret, @Nullable PsiFile file2) {
        if (caret == null || file2 == null || caret instanceof InjectedCaret) {
            return caret;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(caret.getEditor(), injectedFile);
        if (!(injectedEditor instanceof EditorWindow)) {
            return caret;
        }
        for (Caret injectedCaret : injectedEditor.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)injectedCaret).getDelegate() != caret) continue;
            return injectedCaret;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiFileBase> T findInjectedFile(@NotNull PsiElement expression, @NotNull Class<T> classToFind) {
        List<Pair<PsiElement, TextRange>> files2;
        if (expression == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(3);
        }
        if (classToFind == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(4);
        }
        if ((files2 = InjectedLanguageManager.getInstance(expression.getProject()).getInjectedPsiFiles(expression)) == null) {
            return null;
        }
        for (Pair<PsiElement, TextRange> fileInfo : files2) {
            PsiElement injectedFile = (PsiElement)fileInfo.first;
            if (!classToFind.isAssignableFrom(injectedFile.getClass())) continue;
            return (T)((PsiFileBase)injectedFile);
        }
        return null;
    }

    @Contract(value="null,_,_->null;!null,_,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor2, @Nullable PsiFile file2, int offset) {
        if (editor2 == null || file2 == null || editor2 instanceof EditorWindow) {
            return editor2;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable PsiFile injectedFile) {
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(5);
        }
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, hostEditor.getCaretModel().getCurrentCaret(), injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable Caret hostCaret, @Nullable PsiFile injectedFile) {
        int selend;
        int selstart;
        Document document;
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(6);
        }
        if (injectedFile == null || hostEditor instanceof EditorWindow || hostEditor.isDisposed()) {
            Editor editor2 = hostEditor;
            if (editor2 == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(7);
            }
            return editor2;
        }
        Project project2 = hostEditor.getProject();
        if (project2 == null) {
            project2 = injectedFile.getProject();
        }
        if (!((document = PsiDocumentManager.getInstance(project2).getDocument(injectedFile)) instanceof DocumentWindowImpl)) {
            Editor editor3 = hostEditor;
            if (editor3 == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(8);
            }
            return editor3;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        if (hostCaret != null && hostCaret.hasSelection() && (selstart = hostCaret.getSelectionStart()) != -1 && !documentWindow.containsRange(selstart, selend = Math.max(selstart, hostCaret.getSelectionEnd()))) {
            Editor editor4 = hostEditor;
            if (editor4 == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(9);
            }
            return editor4;
        }
        if (!documentWindow.isValid()) {
            Editor editor5 = hostEditor;
            if (editor5 == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(10);
            }
            return editor5;
        }
        EditorWindowTrackerImpl tracker = (EditorWindowTrackerImpl)ApplicationManager.getApplication().getService(EditorWindowTracker.class);
        Editor editor6 = tracker.createEditor(documentWindow, (EditorImpl)hostEditor, injectedFile);
        if (editor6 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(11);
        }
        return editor6;
    }

    public static Editor openEditorFor(@NotNull PsiFile file2, @NotNull Project project2) {
        Editor editor2;
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(13);
        }
        Document document = PsiDocumentManager.getInstance(project2).getDocument(file2);
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        if (virtualFile2 instanceof VirtualFileWindow) {
            virtualFile2 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
        }
        if ((editor2 = FileEditorManager.getInstance(project2).openTextEditor(new OpenFileDescriptor(project2, virtualFile2, -1), false)) == null || editor2 instanceof EditorWindow || editor2.isDisposed()) {
            return editor2;
        }
        if (document instanceof DocumentWindowImpl) {
            EditorWindowTrackerImpl tracker = (EditorWindowTrackerImpl)ApplicationManager.getApplication().getService(EditorWindowTracker.class);
            return tracker.createEditor((DocumentWindowImpl)document, (EditorImpl)editor2, file2);
        }
        return editor2;
    }

    @NotNull
    public static Editor getTopLevelEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(14);
        }
        Editor editor3 = InjectedLanguageEditorUtil.getTopLevelEditor(editor2);
        if (editor3 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(15);
        }
        return editor3;
    }

    public static int hostToInjectedUnescaped(DocumentWindow window, int hostOffset) {
        Place shreds = ((DocumentWindowImpl)window).getShreds();
        Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getHostRangeMarker();
        if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
            return ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getPrefix().length();
        }
        StringBuilder chars = new StringBuilder();
        int unescaped = 0;
        for (int i = 0; i < shreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            int prefixLength = shred.getPrefix().length();
            int suffixLength = shred.getSuffix().length();
            PsiLanguageInjectionHost host = shred.getHost();
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper = host == null ? null : host.createLiteralTextEscaper();
            unescaped += prefixLength;
            Segment currentRange = shred.getHostRangeMarker();
            if (currentRange != null) {
                Segment nextRange;
                Segment segment = nextRange = i == shreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)shreds.get(i + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    hostOffset = Math.min(hostOffset, currentRange.getEndOffset());
                    int inHost = hostOffset - currentRange.getStartOffset();
                    if (escaper != null && escaper.decode(rangeInsideHost, chars)) {
                        int found2 = ObjectUtils.binarySearch(0, inHost, index -> Comparing.compare(escaper.getOffsetInHost(index, TextRange.create(0, host.getTextLength())), inHost));
                        return unescaped + (found2 >= 0 ? found2 : -found2 - 1);
                    }
                    return unescaped + inHost;
                }
                unescaped = escaper != null && escaper.decode(rangeInsideHost, chars) ? (unescaped += chars.length()) : (unescaped += currentRange.getEndOffset() - currentRange.getStartOffset());
                unescaped += suffixLength;
            }
            chars.setLength(0);
        }
        return unescaped - ((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getSuffix().length();
    }

    @Nullable
    public static DocumentWindow getDocumentWindow(@NotNull PsiElement element2) {
        PsiFile file2;
        if (element2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(16);
        }
        if ((file2 = element2.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 instanceof VirtualFileWindow) {
            return ((VirtualFileWindow)((Object)virtualFile2)).getDocumentWindow();
        }
        return null;
    }

    public static boolean isHighlightInjectionBackground(@Nullable PsiLanguageInjectionHost host) {
        return !(host instanceof InjectionBackgroundSuppressor);
    }

    public static int getInjectedStart(@NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
        if (places == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(17);
        }
        PsiLanguageInjectionHost.Shred shred = places.get(0);
        PsiLanguageInjectionHost host = shred.getHost();
        assert (host != null);
        return shred.getRangeInsideHost().getStartOffset() + host.getTextRange().getStartOffset();
    }

    @Nullable
    public static PsiElement findElementInInjected(@NotNull PsiLanguageInjectionHost injectionHost, int offset) {
        if (injectionHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(18);
        }
        Ref ref = Ref.create();
        InjectedLanguageUtil.enumerate(injectionHost, (injectedPsi, places) -> ref.set(injectedPsi.findElementAt(offset - InjectedLanguageUtil.getInjectedStart(places))));
        return (PsiElement)ref.get();
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element2, @NotNull Language language, @NotNull Key<T> key, @Nullable T value) {
        PsiFile file2;
        if (element2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(19);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(20);
        }
        if (key == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(21);
        }
        if ((file2 = InjectedLanguageUtil.getCachedInjectedFileWithLanguage(element2, language)) != null) {
            file2.putUserData(key, value);
        }
    }

    @Nullable
    public static PsiFile getCachedInjectedFileWithLanguage(@NotNull PsiElement element2, @NotNull Language language) {
        if (element2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(22);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(23);
        }
        if (!element2.isValid()) {
            return null;
        }
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile(element2.getContainingFile());
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        return InjectedLanguageManager.getInstance(containingFile.getProject()).getCachedInjectedDocumentsInRange(containingFile, element2.getTextRange()).stream().map(documentWindow -> PsiDocumentManager.getInstance(containingFile.getProject()).getPsiFile((Document)documentWindow)).filter(file2 -> file2 != null && file2.getLanguage() == LanguageSubstitutors.getInstance().substituteLanguage(language, file2.getVirtualFile(), file2.getProject())).max(LONGEST_INJECTION_HOST_RANGE_COMPARATOR).orElse(null);
    }

    public static void injectReference(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (registrar == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(24);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(25);
        }
        if (prefix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(26);
        }
        if (suffix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(27);
        }
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(28);
        }
        if (rangeInsideHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(29);
        }
        ((InjectionRegistrarImpl)registrar).injectReference(language, prefix, suffix, host, rangeInsideHost);
    }

    public static BooleanRunnable reparse(@NotNull PsiFile injectedPsiFile, @NotNull DocumentWindow injectedDocument, @NotNull PsiFile hostPsiFile, @NotNull Document hostDocument, @NotNull FileViewProvider hostViewProvider, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiDocumentManagerBase documentManager) {
        VirtualFile hostVirtualFile;
        InjectedFileViewProvider provider2;
        VirtualFile oldInjectedVFile;
        Language language;
        BooleanRunnable runnable;
        if (injectedPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(30);
        }
        if (injectedDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(31);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(32);
        }
        if (hostDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(33);
        }
        if (hostViewProvider == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(34);
        }
        if (indicator == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(35);
        }
        if (oldRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(36);
        }
        if (newRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(37);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(38);
        }
        if ((runnable = InjectionRegistrarImpl.reparse(language = injectedPsiFile.getLanguage(), (DocumentWindowImpl)injectedDocument, injectedPsiFile, (VirtualFileWindow)((Object)(oldInjectedVFile = (provider2 = (InjectedFileViewProvider)injectedPsiFile.getViewProvider()).getVirtualFile())), hostVirtualFile = hostViewProvider.getVirtualFile(), hostPsiFile, (DocumentEx)hostDocument, indicator, oldRoot, newRoot, documentManager)) == null) {
            ApplicationManager.getApplication().getService(EditorWindowTracker.class).disposeEditorFor(injectedDocument);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToFind";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsiFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedDocument";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostViewProvider";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "openEditorFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelEditor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentWindow";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedStart";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findElementInInjected";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putInjectedFileUserData";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedFileWithLanguage";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "injectReference";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

