/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileReferenceHelper {
    public static final ExtensionPointName<FileReferenceHelper> EP_NAME = new ExtensionPointName("com.intellij.psi.fileReferenceHelper");

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            FileReferenceHelper.$$$reportNull$$$0(0);
        }
        String string2 = url;
        if (string2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(@NotNull FileReference reference2) {
        if (reference2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(2);
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public PsiFileSystemItem getPsiFileSystemItem(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(5);
        }
        PsiManager psiManager = PsiManager.getInstance(project2);
        return FileReferenceHelper.getPsiFileSystemItem(psiManager, file2);
    }

    public static PsiFileSystemItem getPsiFileSystemItem(@NotNull PsiManager psiManager, @NotNull VirtualFile file2) {
        if (psiManager == null) {
            FileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(7);
        }
        return file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
    }

    @Nullable
    public PsiFileSystemItem findRoot(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Deprecated
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            FileReferenceHelper.$$$reportNull$$$0(10);
        }
        List<PsiFileSystemItem> list2 = Collections.emptyList();
        if (list2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module, @NotNull VirtualFile file2) {
        if (module == null) {
            FileReferenceHelper.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(13);
        }
        Collection<PsiFileSystemItem> collection = this.getRoots(module);
        if (collection == null) {
            FileReferenceHelper.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public abstract Collection<PsiFileSystemItem> getContexts(@NotNull Project var1, @NotNull VirtualFile var2);

    @ApiStatus.Experimental
    public boolean isMine(@NotNull Project project2, @NotNull VirtualFile contextFile, @NotNull VirtualFile referencedFile) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(15);
        }
        if (contextFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(16);
        }
        if (referencedFile == null) {
            FileReferenceHelper.$$$reportNull$$$0(17);
        }
        return this.isMine(project2, referencedFile);
    }

    public abstract boolean isMine(@NotNull Project var1, @NotNull VirtualFile var2);

    public boolean isFallback() {
        return false;
    }

    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project2, @NotNull VirtualFile file2, boolean isAbsoluteReference) {
        if (project2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(19);
        }
        if (isAbsoluteReference) {
            ProjectFileIndex index = ProjectRootManager.getInstance(project2).getFileIndex();
            Module module = index.getModuleForFile(file2);
            if (module == null) {
                List<FileTargetContext> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileReferenceHelper.$$$reportNull$$$0(20);
                }
                return list2;
            }
            List<FileTargetContext> list3 = ContainerUtil.map(this.getRoots(module, file2), FileTargetContext::new);
            if (list3 == null) {
                FileReferenceHelper.$$$reportNull$$$0(21);
            }
            return list3;
        }
        List<FileTargetContext> list4 = ContainerUtil.map(this.getContexts(project2, file2), FileTargetContext::new);
        if (list4 == null) {
            FileReferenceHelper.$$$reportNull$$$0(22);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 8: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileSystemItem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContexts";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

