/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.values.ClassSerializer;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleDeriveProcessor {
    protected final LangCodeStyleExtractor myLangExtractor;

    protected CodeStyleDeriveProcessor(@NotNull LangCodeStyleExtractor langExtractor) {
        if (langExtractor == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(0);
        }
        this.myLangExtractor = langExtractor;
    }

    public abstract ValuesExtractionResult runWithProgress(Project var1, CodeStyleSettings var2, PsiFile var3, ProgressIndicator var4);

    @NotNull
    public Map<Value, Object> backupValues(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (settings == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(2);
        }
        List<Value> baseValues = this.getFormattingValues(settings, language);
        HashMap<Value, Object> res = new HashMap<Value, Object>();
        for (Value baseValue : baseValues) {
            res.put(baseValue, baseValue.value);
        }
        HashMap<Value, Object> hashMap = res;
        if (hashMap == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private Collection<Value.VAR_KIND> getVarKinds() {
        LinkedList<Value.VAR_KIND> varKinds = new LinkedList<Value.VAR_KIND>();
        varKinds.addAll(this.myLangExtractor.getCustomVarKinds());
        varKinds.addAll(Arrays.asList(Value.VAR_KIND.defaultKinds));
        LinkedList<Value.VAR_KIND> linkedList = varKinds;
        if (linkedList == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(4);
        }
        return linkedList;
    }

    @NotNull
    private Value.VAR_KIND getVarKind(@NotNull String name2, @NotNull Object value) {
        if (name2 == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(5);
        }
        if (value == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(6);
        }
        for (Value.VAR_KIND varKind : this.getVarKinds()) {
            if (!varKind.accepts(name2, value)) continue;
            Value.VAR_KIND vAR_KIND = varKind;
            if (vAR_KIND == null) {
                CodeStyleDeriveProcessor.$$$reportNull$$$0(7);
            }
            return vAR_KIND;
        }
        Value.VAR_KIND vAR_KIND = Value.VAR_KIND.NOTHING;
        if (vAR_KIND == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(8);
        }
        return vAR_KIND;
    }

    @NotNull
    private List<Value> readAll(@NotNull String instanceName, @NotNull Object instance2) {
        if (instanceName == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(9);
        }
        if (instance2 == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(10);
        }
        Class<?> cls = instance2.getClass();
        ArrayList<Value> ret = new ArrayList<Value>();
        ClassSerializer serializer = new ClassSerializer(instanceName, instance2);
        for (Field field : cls.getDeclaredFields()) {
            if ((field = ClassSerializer.getPreparedField(field)) == null || field.getName().endsWith("_FORCE")) continue;
            try {
                ret.add(this.buildFValue(field, instance2, serializer));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Value> arrayList = ret;
        if (arrayList == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private Value buildFValue(@NotNull Field field, @NotNull Object instance2, @NotNull ClassSerializer serializer) throws IllegalAccessException {
        if (field == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(12);
        }
        if (instance2 == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(13);
        }
        if (serializer == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(14);
        }
        String name2 = field.getName();
        Object value = field.get(instance2);
        Value.VAR_KIND varKind = this.getVarKind(name2, value);
        return new Value(name2, value, serializer, varKind);
    }

    @NotNull
    protected List<Value> getFormattingValues(CodeStyleSettings settings, Language language) {
        LanguageCodeStyleSettingsProvider provider2;
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            Utils.logError("IndentOptions from common settings are null; using indent options from settings.");
            indentOptions = settings.getIndentOptions();
        }
        CustomCodeStyleSettings languageSettings = Utils.getLanguageSettings(settings, language);
        List<Value> values2 = this.readAll("commonSettings", commonSettings);
        if (languageSettings != null) {
            values2.addAll(this.readAll("languageSettings", languageSettings));
        }
        if ((provider2 = LanguageCodeStyleSettingsProvider.forLanguage(language)) != null) {
            Set<String> supportedFields = provider2.getSupportedFields();
            ArrayList<Value> cvalues = new ArrayList<Value>(values2.size());
            for (Value value : values2) {
                if (!supportedFields.contains(value.name)) continue;
                cvalues.add(value);
            }
            values2 = cvalues;
        }
        List<Value> valuesOrder = this.readAll("indentOptions", indentOptions);
        valuesOrder.addAll(values2);
        List<Value> list2 = valuesOrder;
        if (list2 == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    public abstract String getHTMLReport();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langExtractor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "backupValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKinds";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readAll";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattingValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "backupValues";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVarKind";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readAll";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildFValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

