/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.ui.HighlightingChooser;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class HighlightingRenderer
extends ComboBoxTableRenderer<TextAttributesKey> {
    private final List<Pair<TextAttributesKey, @Nls String>> myEditorAttributesKey;
    public static final TextAttributesKey EDIT_HIGHLIGHTING = TextAttributesKey.createTextAttributesKey("-");

    public HighlightingRenderer(List<Pair<TextAttributesKey, @Nls String>> editorAttributesKey) {
        super((Object[])((TextAttributesKey[])editorAttributesKey.stream().map(pair -> (TextAttributesKey)pair.first).toArray(TextAttributesKey[]::new)));
        this.myEditorAttributesKey = editorAttributesKey;
    }

    @Nls
    protected String getTextFor(@NotNull TextAttributesKey value) {
        if (value == null) {
            HighlightingRenderer.$$$reportNull$$$0(0);
        }
        if (HighlightingChooser.ATTRIBUTES_CUSTOM_NAMES.containsKey(value)) {
            return HighlightingChooser.ATTRIBUTES_CUSTOM_NAMES.get(value).get();
        }
        String text2 = value.getExternalName();
        for (Pair<TextAttributesKey, String> pair : this.myEditorAttributesKey) {
            if (value != pair.first) continue;
            text2 = (String)pair.second;
            break;
        }
        text2 = HighlightingChooser.stripColorOptionCategory(text2);
        return text2;
    }

    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
    }

    protected ListSeparator getSeparatorAbove(TextAttributesKey value) {
        return value == EDIT_HIGHLIGHTING ? new ListSeparator() : null;
    }

    public void onClosed(@NotNull LightweightWindowEvent event) {
        if (event == null) {
            HighlightingRenderer.$$$reportNull$$$0(1);
        }
        super.onClosed(event);
        if (this.getCellEditorValue() == EDIT_HIGHLIGHTING) {
            this.openColorSettings();
        }
    }

    abstract void openColorSettings();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/profile/codeInspection/ui/table/HighlightingRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

