/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class LevelChooserAction
extends ComboBoxAction
implements DumbAware {
    private final SeverityRegistrar mySeverityRegistrar;
    private final boolean myIncludeDoNotShow;
    private HighlightSeverity myChosen = null;

    public LevelChooserAction(SeverityRegistrar severityRegistrar) {
        this(severityRegistrar, false);
    }

    public LevelChooserAction(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        this.mySeverityRegistrar = severityRegistrar;
        this.myIncludeDoNotShow = includeDoNotShow;
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(JComponent anchor) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(this.mySeverityRegistrar, this.myIncludeDoNotShow)) {
            HighlightSeverityAction action2 = new HighlightSeverityAction(severity);
            if (this.myChosen == null) {
                this.setChosen(action2.getSeverity());
            }
            group.add((AnAction)action2);
        }
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(InspectionsBundle.message("inspection.edit.severities.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project2;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project2 = e.getProject()) != null) {
                    SeverityEditorDialog.show(project2, LevelChooserAction.this.myChosen, LevelChooserAction.this.mySeverityRegistrar, true, severity -> {
                        LevelChooserAction.this.setChosen((HighlightSeverity)severity);
                        LevelChooserAction.this.onChosen((HighlightSeverity)severity);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/LevelChooserAction$1", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            LevelChooserAction.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    @NotNull
    public static @NotNull List<@NotNull HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar) {
        return LevelChooserAction.getSeverities(severityRegistrar, true);
    }

    @NotNull
    public static @NotNull List<@NotNull HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        ArrayList<HighlightSeverity> severities = new ArrayList<HighlightSeverity>();
        for (SeverityRegistrar.SeverityBasedTextAttributes type : SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar)) {
            if (!type.getType().isApplicableToInspections()) continue;
            severities.add(type.getSeverity());
        }
        if (includeDoNotShow) {
            severities.add(HighlightSeverity.INFORMATION);
        }
        ArrayList<HighlightSeverity> arrayList = severities;
        if (arrayList == null) {
            LevelChooserAction.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected abstract void onChosen(@NotNull HighlightSeverity var1);

    public void setChosen(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            LevelChooserAction.$$$reportNull$$$0(2);
        }
        this.myChosen = severity;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(SingleInspectionProfilePanel.renderSeverity(severity));
        templatePresentation.setIcon(HighlightDisplayLevel.find(severity).getIcon());
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            LevelChooserAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            LevelChooserAction.$$$reportNull$$$0(4);
        }
        ComboBoxAction.ComboBoxButton button2 = this.createComboBoxButton(presentation2);
        button2.setMinimumSize(new Dimension(100, 0));
        ComboBoxAction.ComboBoxButton comboBoxButton = button2;
        if (comboBoxButton == null) {
            LevelChooserAction.$$$reportNull$$$0(5);
        }
        return comboBoxButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/LevelChooserAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverities";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/LevelChooserAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setChosen";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class HighlightSeverityAction
    extends DumbAwareAction {
        @NotNull
        private final HighlightSeverity mySeverity;

        @NotNull
        HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.mySeverity;
            if (highlightSeverity == null) {
                HighlightSeverityAction.$$$reportNull$$$0(0);
            }
            return highlightSeverity;
        }

        private HighlightSeverityAction(HighlightSeverity severity) {
            if (severity == null) {
                HighlightSeverityAction.$$$reportNull$$$0(1);
            }
            this.mySeverity = severity;
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(SingleInspectionProfilePanel.renderSeverity(severity));
            presentation2.setIcon(HighlightDisplayLevel.find(severity).getIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HighlightSeverityAction.$$$reportNull$$$0(2);
            }
            HighlightSeverity severity = this.getSeverity();
            LevelChooserAction.this.setChosen(severity);
            LevelChooserAction.this.onChosen(severity);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/LevelChooserAction$HighlightSeverityAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/LevelChooserAction$HighlightSeverityAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

