/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.ui.HighlightAction;
import com.intellij.profile.codeInspection.ui.HighlightPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HighlightingChooser
extends ComboBoxAction
implements DumbAware {
    public static final Map<TextAttributesKey, Supplier<@Nls String>> ATTRIBUTES_CUSTOM_NAMES = new HashMap<TextAttributesKey, Supplier<String>>();
    private HighlightPopup myPopup;
    private final SeverityRegistrar mySeverityRegistrar;

    public HighlightingChooser(@NotNull SeverityRegistrar severityRegistrar) {
        if (severityRegistrar == null) {
            HighlightingChooser.$$$reportNull$$$0(0);
        }
        this.myPopup = null;
        this.mySeverityRegistrar = severityRegistrar;
    }

    abstract void onKeyChosen(@NotNull TextAttributesKey var1);

    public void setChosen(@NotNull TextAttributesKey key) {
        if (key == null) {
            HighlightingChooser.$$$reportNull$$$0(1);
        }
        if (ATTRIBUTES_CUSTOM_NAMES.containsKey(key)) {
            this.getTemplatePresentation().setText(ATTRIBUTES_CUSTOM_NAMES.get(key));
            return;
        }
        ArrayList attributes = ColorSettingsUtil.getErrorTextAttributes();
        String displayName = key.getExternalName();
        for (Pair pair : attributes) {
            if (!key.toString().equals(((TextAttributesKey)pair.first).toString())) continue;
            displayName = (String)pair.second;
            break;
        }
        String name2 = HighlightingChooser.stripColorOptionCategory(displayName);
        this.getTemplatePresentation().setText(name2);
    }

    @NotNull
    @Nls
    public static String stripColorOptionCategory(@NotNull @Nls String displayName) {
        int separatorPos;
        String name2;
        if (displayName == null) {
            HighlightingChooser.$$$reportNull$$$0(2);
        }
        String string2 = name2 = (separatorPos = displayName.indexOf("//")) == -1 ? displayName : displayName.substring(separatorPos + 2);
        if (string2 == null) {
            HighlightingChooser.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
        DefaultActionGroup group = new DefaultActionGroup();
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (Pair pair : ColorSettingsUtil.getErrorTextAttributes()) {
            group.add((AnAction)new HighlightAction(HighlightingChooser.stripColorOptionCategory((String)pair.second), (TextAttributesKey)pair.first, scheme.getAttributes((TextAttributesKey)pair.first), this::onKeyChosen));
        }
        Collection<HighlightInfoType> standardSeverities = SeverityRegistrar.standardSeverities();
        for (HighlightSeverity severity : this.mySeverityRegistrar.getAllSeverities()) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoType = this.mySeverityRegistrar.getHighlightInfoTypeBySeverity(severity);
            if (standardSeverities.contains(highlightInfoType)) continue;
            TextAttributesKey attributes = this.mySeverityRegistrar.getHighlightInfoTypeBySeverity(severity).getAttributesKey();
            group.add((AnAction)new HighlightAction(severity.getDisplayName(), attributes, this.mySeverityRegistrar.getTextAttributesBySeverity(severity), this::onKeyChosen));
        }
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(InspectionsBundle.message("inspection.edit.highlighting.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DataContext dataContext = HighlightingChooser.this.myPopup == null ? e.getDataContext() : DataManager.getInstance().getDataContext((Component)HighlightingChooser.this.myPopup.getComponent());
                ColorAndFontOptions.selectOrEditColor((DataContext)dataContext, (String)OptionsBundle.message((String)"options.java.attribute.descriptor.error", (Object[])new Object[0]).split("//")[0], (String)OptionsBundle.message((String)"options.general.display.name", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/HighlightingChooser$1", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            HighlightingChooser.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    @NotNull
    protected ListPopup createActionPopup(@NotNull DataContext context2, @NotNull JComponent component2, @Nullable Runnable disposeCallback) {
        if (context2 == null) {
            HighlightingChooser.$$$reportNull$$$0(5);
        }
        if (component2 == null) {
            HighlightingChooser.$$$reportNull$$$0(6);
        }
        DefaultActionGroup group = this.createPopupActionGroup(component2);
        this.myPopup = new HighlightPopup(this.myPopupTitle, (ActionGroup)group, context2, this.shouldShowDisabledActions(), disposeCallback, this.getMaxRows(), this.getPreselectCondition());
        this.myPopup.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
        HighlightPopup highlightPopup = this.myPopup;
        if (highlightPopup == null) {
            HighlightingChooser.$$$reportNull$$$0(7);
        }
        return highlightPopup;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            HighlightingChooser.$$$reportNull$$$0(8);
        }
        if (place == null) {
            HighlightingChooser.$$$reportNull$$$0(9);
        }
        ComboBoxAction.ComboBoxButton button2 = this.createComboBoxButton(presentation2);
        button2.setMinimumSize(new Dimension(100, 0));
        ComboBoxAction.ComboBoxButton comboBoxButton = button2;
        if (comboBoxButton == null) {
            HighlightingChooser.$$$reportNull$$$0(10);
        }
        return comboBoxButton;
    }

    static {
        ATTRIBUTES_CUSTOM_NAMES.put(CodeInsightColors.INFORMATION_ATTRIBUTES, InspectionsBundle.messagePointer("inspection.no.highlighting", new Object[0]));
        ATTRIBUTES_CUSTOM_NAMES.put(CodeInsightColors.CONSIDERATION_ATTRIBUTES, InspectionsBundle.messagePointer("inspection.choose.highlighting", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/HighlightingChooser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/HighlightingChooser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stripColorOptionCategory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setChosen";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stripColorOptionCategory";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

