/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeManagerIprProvider;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.BaseInspectionProfileManagerKt;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileProcessor;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManagerKt;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManagerState;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.JdomKt;
import com.intellij.util.messages.MessageBus;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="InspectionProjectProfileManager", storages={@Storage(exclusive=true, value="inspectionProfiles/profiles_settings.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\b\u0017\u0018\u0000 12\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u00011B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0007J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0016J\r\u0010#\u001a\u00070$\u00a2\u0006\u0002\b%H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\u0006\u0010*\u001a\u00020 J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0010H\u0014J\u0012\u0010.\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010/\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0016J\u000e\u00100\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "Lcom/intellij/profile/codeInspection/BaseInspectionProfileManager;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectProfile", "", "getProjectProfile", "()Ljava/lang/String;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "schemeManagerIprProvider", "Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "state", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManagerState;", "dispose", "", "fireProfileChanged", "profile", "forceLoadSchemes", "getCurrentProfile", "getProfile", "name", "returnRootProfileIfNamedIsAbsent", "", "getProfiles", "", "getScopesManager", "Lcom/intellij/packageDependencies/DependencyValidationManager;", "Lorg/jetbrains/annotations/NotNull;", "getState", "getStateModificationCount", "", "initializeComponent", "isCurrentProfileInitialized", "loadState", "schemeRemoved", "scheme", "setCurrentProfile", "setRootProfile", "useApplicationProfile", "Companion", "intellij.platform.analysis.impl"})
public class ProjectInspectionProfileManager
extends BaseInspectionProfileManager
implements PersistentStateComponentWithModificationTracker<Element>,
Disposable {
    private ProjectInspectionProfileManagerState state;
    private final SchemeManagerIprProvider schemeManagerIprProvider;
    @NotNull
    private final SchemeManager<InspectionProfileImpl> schemeManager;
    @NotNull
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected SchemeManager<InspectionProfileImpl> getSchemeManager() {
        return this.schemeManager;
    }

    @Override
    public void initializeComponent() {
        block3: {
            block2: {
                Application app = ApplicationManager.getApplication();
                if (!ProjectKt.isDirectoryBased(this.project)) break block2;
                Application application = app;
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                if (!application.isUnitTestMode()) break block3;
            }
            return;
        }
        String name$iv = "project inspection profile loading";
        ActivityCategory category$iv = ActivityCategory.DEFAULT;
        boolean $i$f$runActivity = false;
        Activity activity = StartUpMeasurer.startActivity(name$iv, category$iv);
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startActivity(name, category)");
        Activity activity$iv = activity;
        boolean bl = false;
        this.getSchemeManager().loadSchemes();
        this.getCurrentProfile().initInspectionTools(this.project);
        Unit result$iv = Unit.INSTANCE;
        activity$iv.end();
        StartupManager.getInstance(this.project).runAfterOpened(new Runnable(this){
            final /* synthetic */ ProjectInspectionProfileManager this$0;

            public final void run() {
                this.this$0.getProject().getMessageBus().syncPublisher(ProfileChangeAdapter.TOPIC).profilesInitialized();
                NamedScopesHolder.ScopeListener projectScopeListener2 = new NamedScopesHolder.ScopeListener(this){
                    final /* synthetic */ initializeComponent.2 this$0;

                    public final void scopesChanged() {
                        for (InspectionProfileImpl profile : this.this$0.this$0.getSchemeManager().getAllSchemes()) {
                            profile.scopesChanged();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
                this.this$0.getScopesManager().addScopeListener(projectScopeListener2, this.this$0.getProject());
                NamedScopeManager.getInstance(this.this$0.getProject()).addScopeListener(projectScopeListener2, this.this$0.getProject());
            }
            {
                this.this$0 = projectInspectionProfileManager;
            }
        });
    }

    @Override
    public void dispose() {
        Application app;
        Function0 cleanupInspectionProfilesRunnable2 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectInspectionProfileManager this$0;

            @Nullable
            public final Unit invoke() {
                Unit unit;
                this.this$0.cleanupSchemes$intellij_platform_analysis_impl(this.this$0.getProject());
                boolean $i$f$serviceIfCreated = false;
                BaseInspectionProfileManager baseInspectionProfileManager = (BaseInspectionProfileManager)ApplicationManager.getApplication().getServiceIfCreated(InspectionProfileManager.class);
                if (baseInspectionProfileManager != null) {
                    baseInspectionProfileManager.cleanupSchemes$intellij_platform_analysis_impl(this.this$0.getProject());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.this$0 = projectInspectionProfileManager;
                super(0);
            }
        };
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isUnitTestMode() || app.isHeadlessEnvironment()) {
            cleanupInspectionProfilesRunnable2.invoke();
        } else {
            Function0 function0 = cleanupInspectionProfilesRunnable2;
            app.executeOnPooledThread(new Callable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ Object call() {
                    return this.function.invoke();
                }
            });
        }
    }

    @Override
    public long getStateModificationCount() {
        SchemeManagerIprProvider schemeManagerIprProvider = this.schemeManagerIprProvider;
        return this.state.getModificationCount() + this.getSeverityRegistrar().getModificationCount() + (schemeManagerIprProvider != null ? schemeManagerIprProvider.getModificationCount() : 0L);
    }

    @TestOnly
    public final void forceLoadSchemes() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        BaseInspectionProfileManagerKt.LOG.assertTrue(application.isUnitTestMode());
        this.getSchemeManager().loadSchemes();
    }

    public final boolean isCurrentProfileInitialized() {
        return this.getCurrentProfile().wasInitialized();
    }

    @Override
    protected void schemeRemoved(@NotNull InspectionProfileImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        scheme.cleanup(this.project);
    }

    @Override
    @Nullable
    public synchronized Element getState() {
        Element result2 = new Element("settings");
        SchemeManagerIprProvider schemeManagerIprProvider = this.schemeManagerIprProvider;
        if (schemeManagerIprProvider != null) {
            schemeManagerIprProvider.writeState(result2);
        }
        XmlSerializer.serializeObjectInto$default(this.state, result2, null, 4, null);
        List<Element> list2 = result2.getChildren();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"result.children");
        Collection collection = list2;
        if (!collection.isEmpty()) {
            result2.addContent(new Element("version").setAttribute("value", "1.0"));
        }
        this.getSeverityRegistrar().writeExternal(result2);
        return Scheme_implKt.wrapState(result2, this.project);
    }

    @Override
    public synchronized void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Element data2 = Scheme_implKt.unwrapState(state, this.project, this.schemeManagerIprProvider, this.getSchemeManager());
        ProjectInspectionProfileManagerState newState = new ProjectInspectionProfileManagerState();
        Element element2 = data2;
        if (element2 != null) {
            Element element3;
            Element it = element3 = element2;
            boolean bl = false;
            try {
                this.getSeverityRegistrar().readExternal(it);
            }
            catch (Throwable e) {
                BaseInspectionProfileManagerKt.LOG.error(e);
            }
            XmlSerializer.deserializeInto(it, newState);
        }
        this.state = newState;
        if (data2 != null) {
            Element element4 = data2.getChild("version");
            if (Intrinsics.areEqual((Object)(element4 != null ? element4.getAttributeValue("value") : null), (Object)"1.0") ^ true) {
                for (Element o : data2.getChildren("option")) {
                    if (!Intrinsics.areEqual((Object)o.getAttributeValue("name"), (Object)"USE_PROJECT_LEVEL_SETTINGS")) continue;
                    Element element5 = o;
                    Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"o");
                    if (!JdomKt.getAttributeBooleanValue(element5, "value") || newState.getProjectProfile() == null) break;
                    this.getCurrentProfile().convert(data2, this.project);
                    break;
                }
            }
        }
    }

    @Override
    @NotNull
    public DependencyValidationManager getScopesManager() {
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyValidationManager, (String)"DependencyValidationManager.getInstance(project)");
        return dependencyValidationManager;
    }

    @Override
    @NotNull
    public synchronized Collection<InspectionProfileImpl> getProfiles() {
        this.getCurrentProfile();
        return this.getSchemeManager().getAllSchemes();
    }

    @Nullable
    public final String getProjectProfile() {
        return this.state.getProjectProfile();
    }

    @Override
    public synchronized void setRootProfile(@Nullable String name2) {
        this.state.setUseProjectProfile(name2 != null);
        if (name2 != null) {
            this.state.setProjectProfile(name2);
        }
        this.getSchemeManager().setCurrentSchemeName(name2, true);
    }

    public final synchronized void useApplicationProfile(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.state.setUseProjectProfile(false);
        this.state.setProjectProfile(name2);
    }

    @TestOnly
    public final synchronized void setCurrentProfile(@Nullable InspectionProfileImpl profile) {
        SchemeManager.setCurrent$default(this.getSchemeManager(), profile, false, false, 6, null);
        this.state.setUseProjectProfile(profile != null);
        if (profile != null) {
            this.state.setProjectProfile(profile.getName());
        }
    }

    @Override
    @NotNull
    public synchronized InspectionProfileImpl getCurrentProfile() {
        InspectionProfileImpl currentScheme;
        InspectionProfileImpl inspectionProfileImpl;
        block7: {
            Object object;
            block9: {
                InspectionProfileManager applicationProfileManager;
                block8: {
                    String string2;
                    if (this.state.getUseProjectProfile()) break block7;
                    InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileManager, (String)"InspectionProfileManager.getInstance()");
                    applicationProfileManager = inspectionProfileManager;
                    object = this.state.getProjectProfile();
                    if (object == null) break block8;
                    String it = string2 = object;
                    boolean bl = false;
                    object = applicationProfileManager.getProfile(it, false);
                    if (object != null) break block9;
                }
                InspectionProfileImpl inspectionProfileImpl2 = applicationProfileManager.getCurrentProfile();
                object = inspectionProfileImpl2;
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl2, (String)"applicationProfileManager.currentProfile");
            }
            return object;
        }
        String string3 = this.state.getProjectProfile();
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            inspectionProfileImpl = this.getSchemeManager().findSchemeByName(it);
        } else {
            inspectionProfileImpl = currentScheme = null;
        }
        if (currentScheme == null) {
            currentScheme = (InspectionProfileImpl)CollectionsKt.firstOrNull(this.getSchemeManager().getAllSchemes());
            if (currentScheme == null) {
                currentScheme = new InspectionProfileImpl("Project Default", (InspectionToolsSupplier)InspectionToolRegistrar.Companion.getInstance(), this);
                InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileManager, (String)"InspectionProfileManager.getInstance()");
                InspectionProfileImpl inspectionProfileImpl3 = inspectionProfileManager.getCurrentProfile();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl3, (String)"InspectionProfileManager\u2026Instance().currentProfile");
                currentScheme.copyFrom(inspectionProfileImpl3);
                currentScheme.setProjectLevel(true);
                currentScheme.setName("Project Default");
                this.getSchemeManager().addScheme(currentScheme);
            }
            SchemeManager.setCurrent$default(this.getSchemeManager(), currentScheme, false, false, 4, null);
        }
        return currentScheme;
    }

    @Override
    @Nullable
    public synchronized InspectionProfileImpl getProfile(@NotNull String name2, boolean returnRootProfileIfNamedIsAbsent) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        InspectionProfileImpl profile = this.getSchemeManager().findSchemeByName(name2);
        InspectionProfileImpl inspectionProfileImpl = profile;
        if (inspectionProfileImpl == null) {
            inspectionProfileImpl = InspectionProfileManager.getInstance().getProfile(name2, returnRootProfileIfNamedIsAbsent);
        }
        return inspectionProfileImpl;
    }

    public final void fireProfileChanged() {
        this.fireProfileChanged(this.getCurrentProfile());
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        profile.profileChanged();
        this.project.getMessageBus().syncPublisher(ProfileChangeAdapter.TOPIC).profileChanged(profile);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectInspectionProfileManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MessageBus messageBus = project2.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"project.messageBus");
        super(messageBus);
        this.project = project2;
        this.state = new ProjectInspectionProfileManagerState();
        this.schemeManagerIprProvider = ProjectKt.isDirectoryBased(this.project) ? null : new SchemeManagerIprProvider("profile", null, 2, null);
        this.schemeManager = SchemeManagerFactory.create$default(SchemeManagerFactory.Companion.getInstance(this.project), "inspectionProfiles", new InspectionProfileProcessor(this){
            final /* synthetic */ ProjectInspectionProfileManager this$0;

            @NotNull
            public InspectionProfileImpl createScheme(@NotNull SchemeDataHolder<? super InspectionProfileImpl> dataHolder, @NotNull String name2, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
                InspectionProfileImpl profile = new InspectionProfileImpl(name2, InspectionToolRegistrar.Companion.getInstance(), this.this$0, dataHolder);
                profile.setProjectLevel(true);
                return profile;
            }

            public boolean isSchemeFile(@NotNull CharSequence name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return !StringUtil.equals(name2, "profiles_settings.xml");
            }

            public boolean isSchemeDefault(@NotNull InspectionProfileImpl scheme, @NotNull byte[] digest) {
                byte[] byArray;
                byte[] byArray2;
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
                return Intrinsics.areEqual((Object)scheme.getName(), (Object)"Project Default") && Arrays.equals(byArray2 = digest, byArray = ProjectInspectionProfileManagerKt.access$getDefaultSchemeDigest$p());
            }

            public void onSchemeDeleted(@NotNull InspectionProfileImpl scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                this.this$0.schemeRemoved(scheme);
            }

            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                if (scheme.wasInitialized()) {
                    this.this$0.fireProfileChanged(scheme);
                }
            }

            public void onCurrentSchemeSwitched(@Nullable InspectionProfileImpl oldScheme, @Nullable InspectionProfileImpl newScheme, boolean processChangeSynchronously) {
                this.this$0.getProject().getMessageBus().syncPublisher(ProfileChangeAdapter.TOPIC).profileActivated(oldScheme, newScheme);
            }
            {
                this.this$0 = this$0;
            }
        }, null, null, Scheme_implKt.getOLD_NAME_CONVERTER(), this.schemeManagerIprProvider, null, false, 204, null);
    }

    @JvmStatic
    @NotNull
    public static final ProjectInspectionProfileManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.analysis.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProjectInspectionProfileManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            InspectionProjectProfileManager inspectionProjectProfileManager = project2.getService(InspectionProjectProfileManager.class);
            if (inspectionProjectProfileManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.profile.codeInspection.ProjectInspectionProfileManager");
            }
            return (ProjectInspectionProfileManager)inspectionProjectProfileManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

