/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.PrimaryModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.platform.ModuleAttachListener;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor;", "Lcom/intellij/projectImport/ProjectAttachProcessor;", "()V", "attachToProject", "", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "beforeDetach", "", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "intellij.platform.lang.impl"})
public final class ModuleAttachProcessor
extends ProjectAttachProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean attachToProject(@NotNull Project project2, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback) {
        Path dotIdeaDir;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Logger logger = ModuleAttachProcessorKt.access$getLOG$p();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "Attaching directory: \"%s\"";
        Object object = new Object[]{projectDir};
        String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        logger.info(string3);
        Path path2 = dotIdeaDir = projectDir.resolve(".idea");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dotIdeaDir");
        if (!PathKt.exists(path2)) {
            object = null;
            Function1 function1 = null;
            Function1 function12 = null;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n = 0;
            int n2 = 0;
            Object var17_19 = null;
            ProjectOpenedCallback projectOpenedCallback = null;
            boolean bl6 = false;
            String string5 = null;
            Project project3 = null;
            boolean bl7 = true;
            boolean bl8 = true;
            OpenProjectTask options = new OpenProjectTask(false, null, bl7, bl8, project3, string5, bl6, projectOpenedCallback, var17_19, n2, n, bl5, bl4, bl3, string4, bl2, bl, function12, function1, (Function1)object, 1048563, null);
            Project project4 = ProjectManagerEx.getInstanceEx().newProject(projectDir, options);
            if (project4 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"ProjectManagerEx.getInst\u2026 options) ?: return false");
            Project newProject = project4;
            PlatformProjectOpenProcessor.Companion.runDirectoryProjectConfigurators(projectDir, newProject, true);
            StoreUtil.Companion.saveSettings$default((StoreUtil.Companion)StoreUtil.Companion, (ComponentManager)newProject, (boolean)false, (int)2, null);
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(newProject){
                final /* synthetic */ Project $newProject$inlined;
                {
                    this.$newProject$inlined = project2;
                }

                public final T compute() {
                    boolean bl = false;
                    Disposer.dispose(this.$newProject$inlined);
                    return (T)Unit.INSTANCE;
                }
            });
        }
        try {
            Module module = ModuleAttachProcessorKt.access$findMainModule(project2, dotIdeaDir);
            if (module == null) {
                module = ModuleAttachProcessorKt.access$findMainModule(project2, projectDir);
            }
            object = module;
        }
        catch (Exception e) {
            ModuleAttachProcessorKt.access$getLOG$p().info(e);
            Messages.showErrorDialog((Project)project2, (String)LangBundle.message("module.attach.dialog.message.cannot.attach.project", e.getMessage()), (String)CommonBundle.getErrorTitle());
            return false;
        }
        Object newModule = object;
        LifecycleUsageTriggerCollector.onProjectModuleAttached((Project)project2);
        if (newModule != null) {
            ProjectOpenedCallback projectOpenedCallback = callback;
            if (projectOpenedCallback != null) {
                projectOpenedCallback.projectOpened(project2, (Module)newModule);
            }
            return true;
        }
        return Messages.showYesNoDialog((Project)project2, (String)LangBundle.message("module.attach.dialog.message.project.uses.non.standard.layout", projectDir), (String)LangBundle.message("module.attach.dialog.title.open.project", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0;
    }

    public void beforeDetach(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        project2.getMessageBus().syncPublisher(ModuleAttachListener.TOPIC).beforeDetach(module);
    }

    @JvmStatic
    @Nullable
    public static final Module getPrimaryModule(@NotNull Project project2) {
        return Companion.getPrimaryModule(project2);
    }

    @JvmStatic
    @NotNull
    public static final List<Module> getSortedModules(@NotNull Project project2) {
        return Companion.getSortedModules(project2);
    }

    @JvmStatic
    @NlsSafe
    @Nullable
    public static final String getMultiProjectDisplayName(@NotNull Project project2) {
        return Companion.getMultiProjectDisplayName(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor$Companion;", "", "()V", "getMultiProjectDisplayName", "", "project", "Lcom/intellij/openapi/project/Project;", "getPrimaryModule", "Lcom/intellij/openapi/module/Module;", "getSortedModules", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Module getPrimaryModule(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return ProjectAttachProcessor.canAttachToProject() ? PrimaryModuleManager.findPrimaryModule(project2) : null;
        }

        @JvmStatic
        @NotNull
        public final List<Module> getSortedModules(@NotNull Project project2) {
            ArrayList<Module> result2;
            block2: {
                Module module;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Module primaryModule = this.getPrimaryModule(project2);
                result2 = new ArrayList<Module>();
                ModuleManager moduleManager = ModuleManager.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Module[] $this$filterTo$iv = moduleArray;
                boolean $i$f$filterTo = false;
                int n = $this$filterTo$iv.length;
                for (int i = 0; i < n; ++i) {
                    Module element$iv;
                    Module it = element$iv = $this$filterTo$iv[i];
                    boolean bl = false;
                    if (!(it != primaryModule)) continue;
                    ((Collection)result2).add(element$iv);
                }
                List $this$sortBy$iv = result2;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Module p1 = (Module)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)p1.getName());
                            p1 = (Module)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            String string2 = p1.getName();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                        }
                    });
                }
                Module module2 = primaryModule;
                if (module2 == null) break block2;
                Module it = module = module2;
                boolean bl = false;
                result2.add(0, it);
            }
            return result2;
        }

        @JvmStatic
        @NlsSafe
        @Nullable
        public final String getMultiProjectDisplayName(@NotNull Project project2) {
            Module primaryModule;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (!ProjectAttachProcessor.canAttachToProject()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Object[] modules2 = moduleManager.getModules();
            if (modules2.length <= 1) {
                return null;
            }
            Module module = this.getPrimaryModule(project2);
            if (module == null) {
                Intrinsics.checkNotNullExpressionValue((Object)modules2, (String)"modules");
                module = (Module)ArraysKt.first((Object[])modules2);
            }
            Module module2 = primaryModule = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"primaryModule");
            StringBuilder stringBuilder = new StringBuilder(module2.getName()).append(", ");
            Intrinsics.checkNotNullExpressionValue((Object)modules2, (String)"modules");
            Object object = SequencesKt.first((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])modules2), (Function1)((Function1)new Function1<Module, Boolean>(primaryModule){
                final /* synthetic */ Module $primaryModule;

                public final boolean invoke(Module it) {
                    return it != this.$primaryModule;
                }
                {
                    this.$primaryModule = module;
                    super(1);
                }
            })));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"modules.asSequence().fil\u2026= primaryModule }.first()");
            StringBuilder result2 = stringBuilder.append(((Module)object).getName());
            if (modules2.length > 2) {
                result2.append("...");
            }
            return result2.toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

