/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    @NotNull
    public static StringPattern string() {
        StringPattern stringPattern = StringPattern.STRING_PATTERN;
        if (stringPattern == null) {
            StandardPatterns.$$$reportNull$$$0(0);
        }
        return stringPattern;
    }

    @NotNull
    public static CharPattern character() {
        return new CharPattern();
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> instanceOf(@NotNull Class<T> aClass) {
        if (aClass == null) {
            StandardPatterns.$$$reportNull$$$0(1);
        }
        return new ObjectPattern.Capture<T>(aClass);
    }

    @SafeVarargs
    @NotNull
    public static <T> ElementPattern<T> instanceOf(Class<T> ... classes) {
        if (classes == null) {
            StandardPatterns.$$$reportNull$$$0(2);
        }
        ElementPattern[] patterns = ContainerUtil.map(classes, StandardPatterns::instanceOf, new ElementPattern[0]);
        return StandardPatterns.or(patterns);
    }

    @NotNull
    public static <T> ElementPattern save(final Key<T> key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                context2.put(key, o);
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                builder2.append("save(").append(key).append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$1", "append"));
            }
        });
    }

    @NotNull
    public static ObjectPattern.Capture<Object> object() {
        return StandardPatterns.instanceOf(Object.class);
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> object(@NotNull T value) {
        if (value == null) {
            StandardPatterns.$$$reportNull$$$0(3);
        }
        ObjectPattern.Capture capture2 = (ObjectPattern.Capture)StandardPatterns.instanceOf(value.getClass()).equalTo(value);
        if (capture2 == null) {
            StandardPatterns.$$$reportNull$$$0(4);
        }
        return capture2;
    }

    @NotNull
    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        return new CollectionPattern();
    }

    @NotNull
    public static ElementPattern get(final @NotNull @NonNls String key) {
        if (key == null) {
            StandardPatterns.$$$reportNull$$$0(5);
        }
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                return Comparing.equal(o, context2.get(key));
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                builder2.append("get(").append(key).append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$2", "append"));
            }
        });
    }

    @NotNull
    public static <T> CollectionPattern<T> collection() {
        return new CollectionPattern();
    }

    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        if (patterns == null) {
            StandardPatterns.$$$reportNull$$$0(6);
        }
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o, context2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean first2 = true;
                for (ElementPattern pattern : patterns) {
                    if (!first2) {
                        builder2.append("\n").append(indent);
                    }
                    first2 = false;
                    pattern.getCondition().append(builder2, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$3", "append"));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> and(ElementPattern<? extends E> ... patterns) {
        void var5_8;
        SmartList<InitialPatternCondition<? extends E>> initial = new SmartList<InitialPatternCondition<? extends E>>();
        for (ElementPattern<E> elementPattern : patterns) {
            initial.add(elementPattern.getCondition().getInitialCondition());
        }
        ObjectPattern.Capture result2 = StandardPatterns.composeInitialConditions(initial);
        ElementPattern<? extends E>[] elementPatternArray = patterns;
        int n = elementPatternArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            ElementPattern<E> elementPattern = elementPatternArray[var5_8];
            for (PatternCondition<? extends E> patternCondition : elementPattern.getCondition().getConditions()) {
                result2 = (ObjectPattern.Capture)result2.with(patternCondition);
            }
            ++var5_8;
        }
        ObjectPattern.Capture capture2 = result2;
        if (capture2 == null) {
            StandardPatterns.$$$reportNull$$$0(7);
        }
        return capture2;
    }

    @NotNull
    private static <E> ObjectPattern.Capture<E> composeInitialConditions(final List<? extends InitialPatternCondition> initial) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                for (InitialPatternCondition pattern : initial) {
                    if (pattern.accepts(o, context2)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                boolean first2 = true;
                for (InitialPatternCondition pattern : initial) {
                    if (!first2) {
                        builder2.append("\n").append(indent);
                    }
                    first2 = false;
                    pattern.append(builder2, indent + "  ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$4", "append"));
            }
        });
    }

    @NotNull
    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                return !pattern.accepts(o, context2);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                pattern.getCondition().append(builder2.append("not("), indent + "  ");
                builder2.append(")");
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(pattern);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$5", "append"));
            }
        });
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                pattern.accepts(o, context2);
                return true;
            }
        });
    }

    @NotNull
    public static <E> ElementPattern<E> alwaysFalse() {
        FalsePattern falsePattern = FALSE_PATTERN;
        if (falsePattern == null) {
            StandardPatterns.$$$reportNull$$$0(8);
        }
        return falsePattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "string";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "object";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "object";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context2) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                    return false;
                }
            });
        }
    }
}

