/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.packageDependencies.BackwardDependenciesBuilder;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesHandler;
import com.intellij.packageDependencies.actions.BackwardDependenciesHandler;
import com.intellij.packageDependencies.ui.DependenciesUsagesPanel;
import com.intellij.packageDependencies.ui.DependencyConfigurable;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DependenciesPanel
extends JPanel
implements Disposable,
DataProvider {
    private final Map<PsiFile, Set<PsiFile>> myDependencies;
    private Map<VirtualFile, Map<DependencyRule, Set<PsiFile>>> myIllegalDependencies;
    private final MyTree myLeftTree = new MyTree();
    private final MyTree myRightTree = new MyTree();
    private final DependenciesUsagesPanel myUsagesPanel;
    private static final Set<PsiFile> EMPTY_FILE_SET = new HashSet<PsiFile>(0);
    private final TreeExpansionMonitor myRightTreeExpansionMonitor;
    private final TreeExpansionMonitor myLeftTreeExpansionMonitor;
    private final Marker myRightTreeMarker;
    private final Marker myLeftTreeMarker;
    private Set<VirtualFile> myIllegalsInRightTree = new HashSet<VirtualFile>();
    private final Project myProject;
    private final List<DependenciesBuilder> myBuilders;
    private final Set<PsiFile> myExcluded;
    private Content myContent;
    private final DependencyPanelSettings mySettings = new DependencyPanelSettings();
    private static final Logger LOG = Logger.getInstance(DependenciesPanel.class);
    private final boolean myForward;
    private final AnalysisScope myScopeOfInterest;
    private final int myTransitiveBorder;

    public DependenciesPanel(Project project2, DependenciesBuilder builder2) {
        this(project2, Collections.singletonList(builder2), new HashSet<PsiFile>());
    }

    public DependenciesPanel(Project project2, List<DependenciesBuilder> builders, Set<PsiFile> excluded) {
        super(new BorderLayout());
        Set<PsiFile> oneFileSet;
        AnalysisScope scope;
        this.myBuilders = builders;
        this.myExcluded = excluded;
        DependenciesBuilder main = this.myBuilders.get(0);
        this.myForward = !main.isBackward();
        this.myScopeOfInterest = main instanceof BackwardDependenciesBuilder ? ((BackwardDependenciesBuilder)main).getScopeOfInterest() : null;
        this.myTransitiveBorder = main instanceof ForwardDependenciesBuilder ? ((ForwardDependenciesBuilder)main).getTransitiveBorder() : 0;
        this.myDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myIllegalDependencies = new HashMap<VirtualFile, Map<DependencyRule, Set<PsiFile>>>();
        for (DependenciesBuilder builder2 : builders) {
            this.myDependencies.putAll(builder2.getDependencies());
            this.putAllDependencies(builder2);
        }
        this.exclude(excluded);
        this.myProject = project2;
        this.myUsagesPanel = new DependenciesUsagesPanel(this.myProject, this.myBuilders);
        Disposer.register(this, this.myUsagesPanel);
        final Splitter treeSplitter = new Splitter();
        Disposer.register(this, new Disposable(){

            @Override
            public void dispose() {
                treeSplitter.dispose();
            }
        });
        treeSplitter.setFirstComponent(ScrollPaneFactory.createScrollPane((Component)((Object)this.myLeftTree)));
        treeSplitter.setSecondComponent(ScrollPaneFactory.createScrollPane((Component)((Object)this.myRightTree)));
        final Splitter splitter = new Splitter(true);
        Disposer.register(this, new Disposable(){

            @Override
            public void dispose() {
                splitter.dispose();
            }
        });
        splitter.setFirstComponent(treeSplitter);
        splitter.setSecondComponent(this.myUsagesPanel);
        this.add((Component)splitter, "Center");
        this.add((Component)this.createToolbar(), "North");
        this.myRightTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myRightTree), this.myProject);
        this.myLeftTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myLeftTree), this.myProject);
        this.myRightTreeMarker = new Marker(){

            @Override
            public boolean isMarked(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return DependenciesPanel.this.myIllegalsInRightTree.contains(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/DependenciesPanel$3", "isMarked"));
            }
        };
        this.myLeftTreeMarker = new Marker(){

            @Override
            public boolean isMarked(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return DependenciesPanel.this.myIllegalDependencies.containsKey(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ui/DependenciesPanel$4", "isMarked"));
            }
        };
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
        this.myLeftTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DependenciesPanel.this.updateRightTreeModel();
                StringBuffer denyRules = new StringBuffer();
                StringBuffer allowRules = new StringBuffer();
                TreePath[] paths2 = DependenciesPanel.this.myLeftTree.getSelectionPaths();
                if (paths2 == null) {
                    return;
                }
                for (TreePath path2 : paths2) {
                    PackageDependenciesNode selectedNode = (PackageDependenciesNode)path2.getLastPathComponent();
                    DependenciesPanel.this.traverseToLeaves(selectedNode, denyRules, allowRules);
                }
                if (denyRules.length() + allowRules.length() > 0) {
                    StatusBar.Info.set((String)CodeInsightBundle.message("status.bar.rule.violation.message", denyRules.length() == 0 || allowRules.length() == 0 ? 1 : 2, (String)(denyRules.length() > 0 ? denyRules.toString() + (allowRules.length() > 0 ? "; " : "") : " ") + (allowRules.length() > 0 ? allowRules.toString() : " ")), (Project)DependenciesPanel.this.myProject);
                } else {
                    StatusBar.Info.set((String)CodeInsightBundle.message("status.bar.no.rule.violation.message", new Object[0]), (Project)DependenciesPanel.this.myProject);
                }
            }
        });
        this.myRightTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SwingUtilities.invokeLater(() -> {
                    Set<PsiFile> searchIn = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree);
                    Set<PsiFile> searchFor = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree);
                    if (searchIn.isEmpty() || searchFor.isEmpty()) {
                        DependenciesPanel.this.myUsagesPanel.setToInitialPosition();
                        DependenciesPanel.this.processDependencies(searchIn, searchFor, path2 -> {
                            searchFor.add((PsiFile)path2.get(1));
                            return true;
                        });
                    } else {
                        DependenciesPanel.this.myUsagesPanel.findUsages(searchIn, searchFor);
                    }
                });
            }
        });
        this.initTree(this.myLeftTree, false);
        this.initTree(this.myRightTree, true);
        this.setEmptyText(this.mySettings.UI_FILTER_LEGALS);
        if (builders.size() == 1 && (scope = builders.get(0).getScope()).getScopeType() == 3 && (oneFileSet = this.myDependencies.keySet()).size() == 1) {
            this.selectElementInLeftTree(oneFileSet.iterator().next());
            return;
        }
        TreeUtil.promiseSelectFirst((JTree)((Object)this.myLeftTree));
    }

    private void putAllDependencies(DependenciesBuilder builder2) {
        Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> dependencies = builder2.getIllegalDependencies();
        for (Map.Entry<PsiFile, Map<DependencyRule, Set<PsiFile>>> entry : dependencies.entrySet()) {
            this.myIllegalDependencies.put(entry.getKey().getVirtualFile(), entry.getValue());
        }
    }

    private void processDependencies(Set<? extends PsiFile> searchIn, Set<? extends PsiFile> searchFor, Processor<? super List<PsiFile>> processor) {
        if (this.myTransitiveBorder == 0) {
            return;
        }
        HashSet<? extends PsiFile> initialSearchFor = new HashSet<PsiFile>(searchFor);
        for (DependenciesBuilder builder2 : this.myBuilders) {
            for (PsiFile psiFile : searchIn) {
                for (PsiFile psiFile2 : initialSearchFor) {
                    List<List<PsiFile>> paths2 = builder2.findPaths(psiFile, psiFile2);
                    paths2.sort(Comparator.comparingInt(List::size));
                    for (List<PsiFile> path2 : paths2) {
                        if (path2.isEmpty()) continue;
                        path2.add(0, psiFile);
                        path2.add(psiFile2);
                        if (processor.process(path2)) continue;
                        return;
                    }
                }
            }
        }
    }

    private void exclude(Set<? extends PsiFile> excluded) {
        for (PsiFile psiFile : excluded) {
            this.myDependencies.remove(psiFile);
            this.myIllegalDependencies.remove(psiFile);
        }
    }

    private void traverseToLeaves(PackageDependenciesNode treeNode2, StringBuffer denyRules, StringBuffer allowRules) {
        Enumeration<TreeNode> enumeration = treeNode2.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            PsiElement childPsiElement = ((PackageDependenciesNode)enumeration.nextElement()).getPsiElement();
            if (!this.myIllegalDependencies.containsKey(childPsiElement)) continue;
            Map<DependencyRule, Set<PsiFile>> illegalDeps = this.myIllegalDependencies.get(childPsiElement);
            for (DependencyRule rule : illegalDeps.keySet()) {
                if (rule.isDenyRule()) {
                    if (denyRules.indexOf(rule.getDisplayText()) != -1) continue;
                    denyRules.append(rule.getDisplayText());
                    denyRules.append("\n");
                    continue;
                }
                if (allowRules.indexOf(rule.getDisplayText()) != -1) continue;
                allowRules.append(rule.getDisplayText());
                allowRules.append("\n");
            }
        }
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new CloseAction());
        group.add((AnAction)new RerunAction(this));
        group.add((AnAction)new FlattenPackagesAction());
        group.add((AnAction)new ShowFilesAction());
        if (ModuleManager.getInstance(this.myProject).getModules().length > 1) {
            group.add((AnAction)new ShowModulesAction());
            group.add((AnAction)this.createFlattenModulesAction());
            if (ModuleManager.getInstance(this.myProject).hasModuleGroups()) {
                group.add((AnAction)new ShowModuleGroupsAction());
            }
        }
        group.add((AnAction)new GroupByScopeTypeAction());
        group.add((AnAction)new FilterLegalsAction());
        group.add((AnAction)new MarkAsIllegalAction());
        group.add((AnAction)new ChooseScopeTypeAction());
        group.add((AnAction)new EditDependencyRulesAction());
        group.add(CommonActionsManager.getInstance().createExportToTextFileAction((ExporterToTextFile)new DependenciesExporterToTextFile()));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("PackageDependencies", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    @NotNull
    private FlattenModulesToggleAction createFlattenModulesAction() {
        return new FlattenModulesToggleAction(this.myProject, () -> this.mySettings.UI_SHOW_MODULES, () -> !this.mySettings.UI_SHOW_MODULE_GROUPS, value -> {
            DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS = value == false;
            this.mySettings.UI_SHOW_MODULE_GROUPS = value == false;
            this.rebuild();
        });
    }

    private void rebuild() {
        this.myIllegalDependencies = new HashMap<VirtualFile, Map<DependencyRule, Set<PsiFile>>>();
        for (DependenciesBuilder builder2 : this.myBuilders) {
            this.putAllDependencies(builder2);
        }
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
    }

    private void initTree(MyTree tree, boolean isRightTree) {
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)((Object)tree));
        SmartExpander.installOn((JTree)((Object)tree));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)tree));
        new TreeSpeedSearch((JTree)((Object)tree));
        PopupHandler.installPopupMenu((JComponent)((Object)tree), (ActionGroup)this.createTreePopupActions(isRightTree), (String)"DependenciesPopup");
    }

    private void updateRightTreeModel() {
        HashSet<PsiFile> deps = new HashSet<PsiFile>();
        Set<PsiFile> scope = this.getSelectedScope(this.myLeftTree);
        this.myIllegalsInRightTree = new HashSet<VirtualFile>();
        for (PsiFile psiFile : scope) {
            Set<PsiFile> psiFiles;
            Map<DependencyRule, Set<PsiFile>> illegalDeps = this.myIllegalDependencies.get(psiFile.getVirtualFile());
            if (illegalDeps != null) {
                for (DependencyRule rule : illegalDeps.keySet()) {
                    Set<PsiFile> files2 = illegalDeps.get(rule);
                    for (PsiFile file2 : files2) {
                        this.myIllegalsInRightTree.add(file2.getVirtualFile());
                    }
                }
            }
            if ((psiFiles = this.myDependencies.get(psiFile)) == null) continue;
            for (PsiFile file3 : psiFiles) {
                if (file3 == null || !file3.isValid()) continue;
                deps.add(file3);
            }
        }
        deps.removeAll(scope);
        this.myRightTreeExpansionMonitor.freeze();
        this.myRightTree.setModel(this.buildTreeModel(deps, this.myRightTreeMarker));
        this.myRightTreeExpansionMonitor.restore();
        DependenciesPanel.expandFirstLevel(this.myRightTree);
    }

    private ActionGroup createTreePopupActions(boolean isRightTree) {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("EditSource"));
        group.add(actionManager.getAction("VersionControlsGroup"));
        if (isRightTree) {
            group.add(actionManager.getAction("AnalyzeMenu"));
            group.add((AnAction)new AddToScopeAction());
            group.add((AnAction)new SelectInLeftTreeAction());
            group.add((AnAction)new ShowDetailedInformationAction());
        } else {
            group.add((AnAction)new RemoveFromScopeAction());
        }
        return group;
    }

    private TreeModel buildTreeModel(Set<? extends PsiFile> deps, Marker marker) {
        return Objects.requireNonNull(PatternDialectProvider.getInstance(this.mySettings.SCOPE_TYPE)).createTreeModel(this.myProject, deps, marker, this.mySettings);
    }

    private void updateLeftTreeModel() {
        Set<PsiFile> psiFiles = this.myDependencies.keySet();
        this.myLeftTreeExpansionMonitor.freeze();
        this.myLeftTree.setModel(this.buildTreeModel(psiFiles, this.myLeftTreeMarker));
        this.myLeftTreeExpansionMonitor.restore();
        DependenciesPanel.expandFirstLevel(this.myLeftTree);
    }

    private static void expandFirstLevel(Tree tree) {
        PackageDependenciesNode root = (PackageDependenciesNode)tree.getModel().getRoot();
        int count2 = root.getChildCount();
        if (count2 < 10) {
            for (int i = 0; i < count2; ++i) {
                PackageDependenciesNode child = (PackageDependenciesNode)root.getChildAt(i);
                DependenciesPanel.expandNodeIfNotTooWide(tree, child);
            }
        }
    }

    private static void expandNodeIfNotTooWide(Tree tree, PackageDependenciesNode node2) {
        int count2 = node2.getChildCount();
        if (count2 > 5) {
            return;
        }
        if (count2 == 1 && node2.getChildAt(0).getChildCount() > 5) {
            return;
        }
        tree.expandPath(new TreePath(node2.getPath()));
    }

    private Set<PsiFile> getSelectedScope(Tree tree) {
        TreePath[] paths2 = tree.getSelectionPaths();
        if (paths2 == null) {
            return EMPTY_FILE_SET;
        }
        HashSet<PsiFile> result2 = new HashSet<PsiFile>();
        for (TreePath path2 : paths2) {
            PackageDependenciesNode node2 = (PackageDependenciesNode)path2.getLastPathComponent();
            node2.fillFiles(result2, !this.mySettings.UI_FLATTEN_PACKAGES);
        }
        return result2;
    }

    public void setContent(Content content2) {
        this.myContent = content2;
    }

    public JTree getLeftTree() {
        return this.myLeftTree;
    }

    public JTree getRightTree() {
        return this.myRightTree;
    }

    @Override
    public void dispose() {
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    @Nullable
    @NonNls
    public Object getData(@NotNull @NonNls String dataId) {
        PackageDependenciesNode selectedNode;
        if (dataId == null) {
            DependenciesPanel.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (selectedNode = this.myRightTree.getSelectedNode()) != null) {
            PsiElement element2 = selectedNode.getPsiElement();
            return element2 != null && element2.isValid() ? element2 : null;
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return "dependency.viewer.tool.window";
        }
        return null;
    }

    private void setEmptyText(boolean flag) {
        String emptyText = flag ? LangBundle.message("status.text.no.illegal.dependencies.found", new Object[0]) : LangBundle.message("status.text.nothing.to.show", new Object[0]);
        this.myLeftTree.getEmptyText().setText(emptyText);
        this.myRightTree.getEmptyText().setText(emptyText);
    }

    private void selectElementInLeftTree(PsiElement elt) {
        PsiManager manager = PsiManager.getInstance(this.myProject);
        PackageDependenciesNode root = (PackageDependenciesNode)this.myLeftTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            PackageDependenciesNode child = (PackageDependenciesNode)enumeration.nextElement();
            if (!manager.areElementsEquivalent(child.getPsiElement(), elt)) continue;
            this.myLeftTree.setSelectionPath(new TreePath(((DefaultTreeModel)this.myLeftTree.getModel()).getPathToRoot(child)));
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/packageDependencies/ui/DependenciesPanel", "getData"));
    }

    public static class DependencyPanelSettings {
        public boolean UI_FLATTEN_PACKAGES;
        public boolean UI_SHOW_FILES;
        public boolean UI_SHOW_MODULES;
        public boolean UI_SHOW_MODULE_GROUPS;
        public boolean UI_FILTER_LEGALS;
        public boolean UI_GROUP_BY_SCOPE_TYPE;
        public String SCOPE_TYPE;
        public boolean UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        public boolean UI_FILTER_OUT_OF_CYCLE_PACKAGES;

        public DependencyPanelSettings() {
            DependencyUISettings settings = DependencyUISettings.getInstance();
            this.UI_FLATTEN_PACKAGES = settings.UI_FLATTEN_PACKAGES;
            this.UI_SHOW_FILES = settings.UI_SHOW_FILES;
            this.UI_SHOW_MODULES = settings.UI_SHOW_MODULES;
            this.UI_SHOW_MODULE_GROUPS = settings.UI_SHOW_MODULE_GROUPS;
            this.UI_FILTER_LEGALS = settings.UI_FILTER_LEGALS;
            this.UI_GROUP_BY_SCOPE_TYPE = settings.UI_GROUP_BY_SCOPE_TYPE;
            this.SCOPE_TYPE = settings.SCOPE_TYPE;
            this.UI_COMPACT_EMPTY_MIDDLE_PACKAGES = settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
            this.UI_FILTER_OUT_OF_CYCLE_PACKAGES = settings.UI_FILTER_OUT_OF_CYCLE_PACKAGES;
        }

        public void copyToApplicationDependencySettings() {
            DependencyUISettings settings = DependencyUISettings.getInstance();
            settings.UI_FLATTEN_PACKAGES = this.UI_FLATTEN_PACKAGES;
            settings.UI_SHOW_FILES = this.UI_SHOW_FILES;
            settings.UI_SHOW_MODULES = this.UI_SHOW_MODULES;
            settings.UI_SHOW_MODULE_GROUPS = this.UI_SHOW_MODULE_GROUPS;
            settings.UI_FILTER_LEGALS = this.UI_FILTER_LEGALS;
            settings.UI_GROUP_BY_SCOPE_TYPE = this.UI_GROUP_BY_SCOPE_TYPE;
            settings.SCOPE_TYPE = this.SCOPE_TYPE;
            settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES = this.UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
            settings.UI_FILTER_OUT_OF_CYCLE_PACKAGES = this.UI_FILTER_OUT_OF_CYCLE_PACKAGES;
        }
    }

    private final class ChooseScopeTypeAction
    extends ComboBoxAction {
        private ChooseScopeTypeAction() {
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (final PatternDialectProvider provider2 : PatternDialectProvider.EP_NAME.getExtensionList()) {
                group.add(new AnAction(provider2.getDisplayName()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DependenciesPanel.this.mySettings.SCOPE_TYPE = provider2.getShortName();
                        DependencyUISettings.getInstance().SCOPE_TYPE = provider2.getShortName();
                        DependenciesPanel.this.rebuild();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/packageDependencies/ui/DependenciesPanel$ChooseScopeTypeAction$1", "actionPerformed"));
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                ChooseScopeTypeAction.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseScopeTypeAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            PatternDialectProvider provider2 = PatternDialectProvider.getInstance(DependenciesPanel.this.mySettings.SCOPE_TYPE);
            assert (provider2 != null);
            e.getPresentation().setText(provider2.getDisplayName());
            e.getPresentation().setIcon(provider2.getIcon());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/packageDependencies/ui/DependenciesPanel$ChooseScopeTypeAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$ChooseScopeTypeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MarkAsIllegalAction
    extends AnAction {
        MarkAsIllegalAction() {
            super(CodeInsightBundle.messagePointer("mark.dependency.illegal.text", new Object[0]), CodeInsightBundle.messagePointer("mark.dependency.illegal.text", new Object[0]), AllIcons.Actions.Lightning);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MarkAsIllegalAction.$$$reportNull$$$0(0);
            }
            PackageDependenciesNode leftNode = DependenciesPanel.this.myLeftTree.getSelectedNode();
            PackageDependenciesNode rightNode = DependenciesPanel.this.myRightTree.getSelectedNode();
            if (leftNode != null && rightNode != null) {
                boolean hasDirectDependencies;
                boolean bl = hasDirectDependencies = DependenciesPanel.this.myTransitiveBorder == 0;
                if (DependenciesPanel.this.myTransitiveBorder > 0) {
                    Set<PsiFile> searchIn = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree);
                    Set<PsiFile> searchFor = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree);
                    block0: for (DependenciesBuilder builder2 : DependenciesPanel.this.myBuilders) {
                        if (hasDirectDependencies) break;
                        block1: for (PsiFile from : searchIn) {
                            if (hasDirectDependencies) continue block0;
                            block2: for (PsiFile to : searchFor) {
                                if (hasDirectDependencies) continue block1;
                                List<List<PsiFile>> paths2 = builder2.findPaths(from, to);
                                for (List<PsiFile> path2 : paths2) {
                                    if (!path2.isEmpty()) continue;
                                    hasDirectDependencies = true;
                                    continue block2;
                                }
                            }
                        }
                    }
                }
                PatternDialectProvider provider2 = PatternDialectProvider.getInstance(DependenciesPanel.this.mySettings.SCOPE_TYPE);
                assert (provider2 != null);
                PackageSet leftPackageSet = provider2.createPackageSet(leftNode, true);
                if (leftPackageSet == null) {
                    leftPackageSet = provider2.createPackageSet(leftNode, false);
                }
                LOG.assertTrue(leftPackageSet != null);
                PackageSet rightPackageSet = provider2.createPackageSet(rightNode, true);
                if (rightPackageSet == null) {
                    rightPackageSet = provider2.createPackageSet(rightNode, false);
                }
                LOG.assertTrue(rightPackageSet != null);
                if (hasDirectDependencies) {
                    DependencyValidationManager.getInstance(DependenciesPanel.this.myProject).addRule(new DependencyRule(new NamedScope.UnnamedScope(leftPackageSet), new NamedScope.UnnamedScope(rightPackageSet), true));
                    DependenciesPanel.this.rebuild();
                } else {
                    Messages.showErrorDialog((Component)DependenciesPanel.this, (String)CodeInsightBundle.message("analyze.dependencies.unable.to.create.rule.error.message", leftPackageSet.getText(), rightPackageSet.getText()), (String)CodeInsightBundle.message("mark.dependency.illegal.text", new Object[0]));
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MarkAsIllegalAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(false);
            PackageDependenciesNode leftNode = DependenciesPanel.this.myLeftTree.getSelectedNode();
            PackageDependenciesNode rightNode = DependenciesPanel.this.myRightTree.getSelectedNode();
            if (leftNode != null && rightNode != null) {
                PatternDialectProvider provider2 = PatternDialectProvider.getInstance(DependenciesPanel.this.mySettings.SCOPE_TYPE);
                assert (provider2 != null);
                presentation2.setEnabled(!(provider2.createPackageSet(leftNode, true) == null && provider2.createPackageSet(leftNode, false) == null || provider2.createPackageSet(rightNode, true) == null && provider2.createPackageSet(rightNode, false) == null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$MarkAsIllegalAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SelectInLeftTreeAction
    extends AnAction {
        SelectInLeftTreeAction() {
            super(CodeInsightBundle.messagePointer("action.select.in.left.tree", new Object[0]), CodeInsightBundle.messagePointer("action.select.in.left.tree.description", new Object[0]), null);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectInLeftTreeAction.$$$reportNull$$$0(0);
            }
            PackageDependenciesNode node2 = DependenciesPanel.this.myRightTree.getSelectedNode();
            e.getPresentation().setEnabled(node2 != null && node2.canSelectInLeftTree(DependenciesPanel.this.myDependencies));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PsiElement elt;
            PackageDependenciesNode node2;
            if (e == null) {
                SelectInLeftTreeAction.$$$reportNull$$$0(1);
            }
            if ((node2 = DependenciesPanel.this.myRightTree.getSelectedNode()) != null && (elt = node2.getPsiElement()) != null) {
                DependencyUISettings.getInstance().UI_FILTER_LEGALS = false;
                DependenciesPanel.this.mySettings.UI_FILTER_LEGALS = false;
                DependenciesPanel.this.selectElementInLeftTree(elt);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$SelectInLeftTreeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddToScopeAction
    extends AnAction {
        private AddToScopeAction() {
            super(ActionsBundle.messagePointer((String)"action.AddToScopeAction.text", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddToScopeAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(this.getScope() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AnalysisScope scope;
            if (e == null) {
                AddToScopeAction.$$$reportNull$$$0(1);
            }
            LOG.assertTrue((scope = this.getScope()) != null);
            DependenciesBuilder builder2 = !DependenciesPanel.this.myForward ? new BackwardDependenciesBuilder(DependenciesPanel.this.myProject, scope, DependenciesPanel.this.myScopeOfInterest) : new ForwardDependenciesBuilder(DependenciesPanel.this.myProject, scope, DependenciesPanel.this.myTransitiveBorder);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(DependenciesPanel.this.myProject, CodeInsightBundle.message("package.dependencies.progress.title", new Object[0]), () -> builder2.analyze(), () -> {
                DependenciesPanel.this.myBuilders.add(builder2);
                DependenciesPanel.this.myDependencies.putAll(builder2.getDependencies());
                DependenciesPanel.this.putAllDependencies(builder2);
                DependenciesPanel.this.exclude(DependenciesPanel.this.myExcluded);
                DependenciesPanel.this.rebuild();
            }, null, new PerformAnalysisInBackgroundOption(DependenciesPanel.this.myProject));
        }

        @Nullable
        private AnalysisScope getScope() {
            Set<PsiFile> selectedScope = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree);
            HashSet result2 = new HashSet();
            ((PackageDependenciesNode)DependenciesPanel.this.myLeftTree.getModel().getRoot()).fillFiles(result2, !DependenciesPanel.this.mySettings.UI_FLATTEN_PACKAGES);
            selectedScope.removeAll(result2);
            if (selectedScope.isEmpty()) {
                return null;
            }
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(DependenciesPanel.this.myProject).getFileIndex();
            for (PsiFile psiFile : selectedScope) {
                VirtualFile file2 = psiFile.getVirtualFile();
                LOG.assertTrue(file2 != null);
                if (!fileIndex.isInContent(file2)) continue;
                files2.add(file2);
            }
            if (!files2.isEmpty()) {
                return new AnalysisScope(DependenciesPanel.this.myProject, files2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$AddToScopeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveFromScopeAction
    extends AnAction {
        private RemoveFromScopeAction() {
            super(ActionsBundle.messagePointer((String)"action.RemoveFromScopeAction.text", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveFromScopeAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree).isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveFromScopeAction.$$$reportNull$$$0(1);
            }
            Set<PsiFile> selectedScope = DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree);
            DependenciesPanel.this.exclude(selectedScope);
            DependenciesPanel.this.myExcluded.addAll(selectedScope);
            TreePath[] paths2 = DependenciesPanel.this.myLeftTree.getSelectionPaths();
            assert (paths2 != null);
            for (TreePath path2 : paths2) {
                TreeUtil.removeLastPathComponent((JTree)((Object)DependenciesPanel.this.myLeftTree), (TreePath)path2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$RemoveFromScopeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowDetailedInformationAction
    extends AnAction {
        private ShowDetailedInformationAction() {
            super(ActionsBundle.messagePointer((String)"action.ShowDetailedInformationAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDetailedInformationAction.$$$reportNull$$$0(0);
            }
            @NonNls String delim = "&nbsp;-&gt;&nbsp;";
            StringBuffer buf = new StringBuffer();
            DependenciesPanel.this.processDependencies(DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree), DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree), path2 -> {
                if (buf.length() > 0) {
                    buf.append("<br>");
                }
                buf.append(StringUtil.join(path2, psiFile -> psiFile.getName(), "&nbsp;-&gt;&nbsp;"));
                return true;
            });
            JEditorPane pane = new JEditorPane("text/html", XmlStringUtil.wrapInHtml(buf));
            pane.setForeground(JBColor.foreground());
            pane.setBackground(HintUtil.getInformationColor());
            pane.setOpaque(true);
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)pane);
            Dimension dimension = pane.getPreferredSize();
            scrollPane.setMinimumSize(new Dimension(dimension.width, dimension.height + 20));
            scrollPane.setPreferredSize(new Dimension(dimension.width, dimension.height + 20));
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)pane).setTitle(LangBundle.message("popup.title.dependencies", new Object[0])).setMovable(true).createPopup().showInBestPositionFor(e.getDataContext());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDetailedInformationAction.$$$reportNull$$$0(1);
            }
            boolean[] direct = new boolean[]{true};
            DependenciesPanel.this.processDependencies(DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myLeftTree), DependenciesPanel.this.getSelectedScope(DependenciesPanel.this.myRightTree), path2 -> {
                direct[0] = false;
                return false;
            });
            e.getPresentation().setEnabled(!direct[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$ShowDetailedInformationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTree
    extends Tree
    implements DataProvider {
        private MyTree() {
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            PackageDependenciesNode node2 = this.getSelectedNode();
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return node2;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && node2 != null) {
                PsiElement element2 = node2.getPsiElement();
                return element2 != null && element2.isValid() ? element2 : null;
            }
            return null;
        }

        @Nullable
        public PackageDependenciesNode getSelectedNode() {
            TreePath[] paths2 = this.getSelectionPaths();
            if (paths2 == null || paths2.length != 1) {
                return null;
            }
            return (PackageDependenciesNode)paths2[0].getLastPathComponent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/packageDependencies/ui/DependenciesPanel$MyTree", "getData"));
        }
    }

    private class RerunAction
    extends AnAction {
        RerunAction(JComponent comp) {
            super(CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), CodeInsightBundle.message("action.rerun.dependency", new Object[0]), AllIcons.Actions.Rerun);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), comp);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            boolean enabled = true;
            for (DependenciesBuilder builder2 : DependenciesPanel.this.myBuilders) {
                enabled &= builder2.getScope().isValid();
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            DependenciesToolWindow.getInstance(DependenciesPanel.this.myProject).closeContent(DependenciesPanel.this.myContent);
            DependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
            SwingUtilities.invokeLater(() -> {
                ArrayList<AnalysisScope> scopes = new ArrayList<AnalysisScope>();
                for (DependenciesBuilder builder2 : DependenciesPanel.this.myBuilders) {
                    AnalysisScope scope = builder2.getScope();
                    scope.invalidate();
                    scopes.add(scope);
                }
                if (!DependenciesPanel.this.myForward) {
                    new BackwardDependenciesHandler(DependenciesPanel.this.myProject, scopes, DependenciesPanel.this.myScopeOfInterest, DependenciesPanel.this.myExcluded).analyze();
                } else {
                    new AnalyzeDependenciesHandler(DependenciesPanel.this.myProject, scopes, DependenciesPanel.this.myTransitiveBorder, DependenciesPanel.this.myExcluded).analyze();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$RerunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DependenciesExporterToTextFile
    implements ExporterToTextFile {
        private DependenciesExporterToTextFile() {
        }

        @NotNull
        public String getReportText() {
            String string2;
            Element rootElement = new Element("root");
            rootElement.setAttribute("isBackward", String.valueOf(!DependenciesPanel.this.myForward));
            ArrayList<PsiFile> files2 = new ArrayList<PsiFile>(DependenciesPanel.this.myDependencies.keySet());
            files2.sort((f1, f2) -> {
                VirtualFile virtualFile1 = f1.getVirtualFile();
                VirtualFile virtualFile2 = f2.getVirtualFile();
                if (virtualFile1 != null && virtualFile2 != null) {
                    return virtualFile1.getPath().compareToIgnoreCase(virtualFile2.getPath());
                }
                return 0;
            });
            for (PsiFile file2 : files2) {
                Element fileElement = new Element("file");
                fileElement.setAttribute("path", file2.getVirtualFile().getPath());
                for (PsiFile dep : DependenciesPanel.this.myDependencies.get(file2)) {
                    Element depElement = new Element("dependency");
                    depElement.setAttribute("path", dep.getVirtualFile().getPath());
                    fileElement.addContent(depElement);
                }
                rootElement.addContent(fileElement);
            }
            try {
                string2 = JbXmlOutputter.collapseMacrosAndWrite(rootElement, DependenciesPanel.this.myProject);
            }
            catch (IOException e) {
                LOG.error(e);
                return "";
            }
            if (string2 == null) {
                DependenciesExporterToTextFile.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @NotNull
        public String getDefaultFilePath() {
            return "";
        }

        public boolean canExport() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/DependenciesPanel$DependenciesExporterToTextFile", "getReportText"));
        }
    }

    private final class EditDependencyRulesAction
    extends AnAction {
        EditDependencyRulesAction() {
            super(CodeInsightBundle.messagePointer("action.edit.rules", new Object[0]), CodeInsightBundle.messagePointer("action.edit.rules.description", new Object[0]), AllIcons.General.Settings);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean applied;
            if (e == null) {
                EditDependencyRulesAction.$$$reportNull$$$0(0);
            }
            if (applied = ShowSettingsUtil.getInstance().editConfigurable((Component)DependenciesPanel.this, (Configurable)new DependencyConfigurable(DependenciesPanel.this.myProject))) {
                DependenciesPanel.this.rebuild();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/packageDependencies/ui/DependenciesPanel$EditDependencyRulesAction", "actionPerformed"));
        }
    }

    private final class FilterLegalsAction
    extends ToggleAction {
        FilterLegalsAction() {
            super(CodeInsightBundle.messagePointer("action.show.illegals.only", new Object[0]), CodeInsightBundle.messagePointer("action.show.illegals.only.description", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                FilterLegalsAction.$$$reportNull$$$0(0);
            }
            return DependenciesPanel.this.mySettings.UI_FILTER_LEGALS;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                FilterLegalsAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_FILTER_LEGALS = flag;
            DependenciesPanel.this.mySettings.UI_FILTER_LEGALS = flag;
            DependenciesPanel.this.setEmptyText(flag);
            DependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$FilterLegalsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class GroupByScopeTypeAction
    extends ToggleAction {
        GroupByScopeTypeAction() {
            super(CodeInsightBundle.messagePointer("action.group.by.scope.type", new Object[0]), CodeInsightBundle.messagePointer("action.group.by.scope.type.description", new Object[0]), AllIcons.Actions.GroupByTestProduction);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                GroupByScopeTypeAction.$$$reportNull$$$0(0);
            }
            return DependenciesPanel.this.mySettings.UI_GROUP_BY_SCOPE_TYPE;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                GroupByScopeTypeAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_GROUP_BY_SCOPE_TYPE = flag;
            DependenciesPanel.this.mySettings.UI_GROUP_BY_SCOPE_TYPE = flag;
            DependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$GroupByScopeTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowModuleGroupsAction
    extends ToggleAction {
        ShowModuleGroupsAction() {
            super(CodeInsightBundle.message("analyze.dependencies.show.module.groups.action.text", new Object[0]), CodeInsightBundle.message("analyze.dependencies.show.module.groups.action.text", new Object[0]), AllIcons.Actions.GroupByModuleGroup);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowModuleGroupsAction.$$$reportNull$$$0(0);
            }
            return DependenciesPanel.this.mySettings.UI_SHOW_MODULE_GROUPS;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowModuleGroupsAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_SHOW_MODULE_GROUPS = flag;
            DependenciesPanel.this.mySettings.UI_SHOW_MODULE_GROUPS = flag;
            DependenciesPanel.this.rebuild();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowModuleGroupsAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setVisible(ModuleManager.getInstance(DependenciesPanel.this.myProject).hasModuleGroups());
            e.getPresentation().setEnabled(DependenciesPanel.this.mySettings.UI_SHOW_MODULES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$ShowModuleGroupsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowModulesAction
    extends ToggleAction {
        ShowModulesAction() {
            super(CodeInsightBundle.messagePointer("action.show.modules", new Object[0]), CodeInsightBundle.messagePointer("action.show.modules.description", new Object[0]), AllIcons.Actions.GroupByModule);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowModulesAction.$$$reportNull$$$0(0);
            }
            return DependenciesPanel.this.mySettings.UI_SHOW_MODULES;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowModulesAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_SHOW_MODULES = flag;
            DependenciesPanel.this.mySettings.UI_SHOW_MODULES = flag;
            DependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$ShowModulesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowFilesAction
    extends ToggleAction {
        ShowFilesAction() {
            super(CodeInsightBundle.messagePointer("action.show.files", new Object[0]), CodeInsightBundle.messagePointer("action.show.files.description", new Object[0]), AllIcons.FileTypes.Unknown);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowFilesAction.$$$reportNull$$$0(0);
            }
            return DependenciesPanel.this.mySettings.UI_SHOW_FILES;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowFilesAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_SHOW_FILES = flag;
            DependenciesPanel.this.mySettings.UI_SHOW_FILES = flag;
            if (!flag && DependenciesPanel.this.myLeftTree.getSelectionPath() != null && DependenciesPanel.this.myLeftTree.getSelectionPath().getLastPathComponent() instanceof FileNode) {
                TreeUtil.selectPath((JTree)((Object)DependenciesPanel.this.myLeftTree), (TreePath)DependenciesPanel.this.myLeftTree.getSelectionPath().getParentPath());
            }
            DependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$ShowFilesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class FlattenPackagesAction
    extends ToggleAction {
        FlattenPackagesAction() {
            super(CodeInsightBundle.messagePointer("action.flatten.packages", new Object[0]), CodeInsightBundle.messagePointer("action.flatten.packages", new Object[0]), PlatformIcons.FLATTEN_PACKAGES_ICON);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                FlattenPackagesAction.$$$reportNull$$$0(0);
            }
            return DependenciesPanel.this.mySettings.UI_FLATTEN_PACKAGES;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                FlattenPackagesAction.$$$reportNull$$$0(1);
            }
            DependencyUISettings.getInstance().UI_FLATTEN_PACKAGES = flag;
            DependenciesPanel.this.mySettings.UI_FLATTEN_PACKAGES = flag;
            DependenciesPanel.this.rebuild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/packageDependencies/ui/DependenciesPanel$FlattenPackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CloseAction
    extends AnAction
    implements DumbAware {
        CloseAction() {
            super(CommonBundle.messagePointer((String)"action.close", (Object[])new Object[0]), CodeInsightBundle.messagePointer("action.close.dependency.description", new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            Disposer.dispose(DependenciesPanel.this.myUsagesPanel);
            DependenciesToolWindow.getInstance(DependenciesPanel.this.myProject).closeContent(DependenciesPanel.this.myContent);
            DependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/packageDependencies/ui/DependenciesPanel$CloseAction", "actionPerformed"));
        }
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            PackageDependenciesNode node2;
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((node2 = (PackageDependenciesNode)value).isValid()) {
                this.setIcon(node2.getIcon());
            } else {
                this.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            this.append(node2.toString(), node2.hasMarked() && !selected ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(node2.getPresentableFilesCount(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/packageDependencies/ui/DependenciesPanel$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

